/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FileBody {
    private char[] buffer = new char[16384];
    private int bufferEnd;
    private int lineBegin;
    private int lineEnd;
    private int nextLineStart;
    private int lineNumber;
    ReplaceItem firstReplace;
    ReplaceItem lastReplace;

    public char[] getBuffer() {
        return this.buffer;
    }

    public void readData(Reader reader) throws IOException {
        int n;
        int n2 = this.buffer.length;
        int n3 = 0;
        while ((n = reader.read(this.buffer, n3, n2 - n3)) >= 0) {
            if (n2 != (n3 += n)) continue;
            char[] cArray = new char[n2 *= 2];
            System.arraycopy(this.buffer, 0, cArray, 0, n3);
            this.buffer = cArray;
        }
        this.bufferEnd = n3;
    }

    public void writeInitialData(Writer writer) throws IOException {
        writer.write(this.buffer, 0, this.bufferEnd);
    }

    public void writeData(Writer writer) throws IOException {
        int n;
        int n2 = 0;
        ReplaceItem replaceItem = this.firstReplace;
        while (replaceItem != null) {
            n = replaceItem.begin - n2;
            if (n > 0) {
                writer.write(this.buffer, n2, n);
            }
            writer.write(replaceItem.replacement);
            n2 = replaceItem.end;
            replaceItem = replaceItem.next;
        }
        n = this.bufferEnd - n2;
        if (n != 0) {
            writer.write(this.buffer, n2, n);
        }
    }

    public boolean wasModified() {
        return this.firstReplace != null;
    }

    public boolean setReplacement(int n, int n2, String string) {
        if (FileBody.equals(string, this.buffer, n, n2)) {
            return false;
        }
        ReplaceItem replaceItem = new ReplaceItem(n, n2, string);
        if (this.firstReplace == null) {
            this.firstReplace = this.lastReplace = replaceItem;
        } else if (n < this.firstReplace.begin) {
            replaceItem.next = this.firstReplace;
            this.firstReplace = replaceItem;
        } else {
            ReplaceItem replaceItem2 = this.firstReplace;
            ReplaceItem replaceItem3 = replaceItem2.next;
            while (replaceItem3 != null) {
                if (n < replaceItem3.begin) {
                    replaceItem.next = replaceItem3;
                    replaceItem2.next = replaceItem;
                    break;
                }
                replaceItem2 = replaceItem3;
                replaceItem3 = replaceItem3.next;
            }
            if (replaceItem3 == null) {
                this.lastReplace.next = replaceItem;
            }
        }
        return true;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineBegin() {
        return this.lineBegin;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public void startLineLoop() {
        this.lineNumber = 0;
        this.nextLineStart = 0;
        this.lineEnd = 0;
        this.lineBegin = 0;
    }

    public boolean nextLine() {
        if (this.nextLineStart == this.bufferEnd) {
            this.lineNumber = 0;
            return false;
        }
        char c = '\u0000';
        int n = this.nextLineStart;
        while (n != this.bufferEnd) {
            c = this.buffer[n];
            if (c == '\n' || c == '\r') break;
            ++n;
        }
        this.lineBegin = this.nextLineStart;
        this.lineEnd = n;
        this.nextLineStart = n == this.bufferEnd ? n : (c == '\r' && n + 1 != this.bufferEnd && this.buffer[n + 1] == '\n' ? n + 2 : n + 1);
        ++this.lineNumber;
        return true;
    }

    private static boolean equals(String string, char[] cArray, int n, int n2) {
        if (string.length() == n2 - n) {
            int n3 = n;
            int n4 = 0;
            while (n3 != n2) {
                if (cArray[n3] != string.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
        return false;
    }

    private static class ReplaceItem {
        ReplaceItem next;
        int begin;
        int end;
        String replacement;

        ReplaceItem(int n, int n2, String string) {
            this.begin = n;
            this.end = n2;
            this.replacement = string;
        }
    }
}

