/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.Runner;

public class Global
extends ImporterTopLevel {
    static final String privateName = "org.mozilla.javascript.tools.shell.Global private";
    NativeArray history;
    public InputStream inStream;
    public PrintStream outStream;
    public PrintStream errStream;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$shell$Global;
    static /* synthetic */ Class class$org$mozilla$javascript$Script;

    public Global(Context context) {
        super(context);
        String[] stringArray = new String[]{"print", "quit", "version", "load", "help", "loadClass", "defineClass", "spawn", "sync", "serialize", "deserialize"};
        try {
            this.defineFunctionProperties(stringArray, class$org$mozilla$javascript$tools$shell$Global == null ? (class$org$mozilla$javascript$tools$shell$Global = Global.class$("org.mozilla.javascript.tools.shell.Global")) : class$org$mozilla$javascript$tools$shell$Global, 2);
        }
        catch (PropertyException propertyException) {
            throw new Error();
        }
        this.defineProperty(privateName, this, 2);
        Environment.defineClass(this);
        Environment environment = new Environment(this);
        this.defineProperty("environment", environment, 2);
        this.history = (NativeArray)context.newArray((Scriptable)this, 0);
        this.defineProperty("history", this.history, 2);
    }

    public static void help(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(scriptable).getOut();
        printStream.println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static Object print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(scriptable).getOut();
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                printStream.print(" ");
            }
            String string = Context.toString(objectArray[n]);
            printStream.print(string);
            ++n;
        }
        printStream.println();
        return Context.getUndefinedValue();
    }

    public static void quit(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        System.exit(objectArray.length > 0 ? (int)Context.toNumber(objectArray[0]) : 0);
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            double d2 = Context.toNumber(objectArray[0]);
            context.setLanguageVersion((int)d2);
        }
        return d;
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = 0;
        while (n < objectArray.length) {
            Main.processFile(context, scriptable, Context.toString(objectArray[n]));
            ++n;
        }
    }

    public static void defineClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Class clazz = Global.getClass(objectArray);
        ScriptableObject.defineClass(scriptable, clazz);
    }

    public static void loadClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, JavaScriptException {
        Class clazz;
        if (!(class$org$mozilla$javascript$Script == null ? (class$org$mozilla$javascript$Script = Global.class$("org.mozilla.javascript.Script")) : class$org$mozilla$javascript$Script).isAssignableFrom(clazz = Global.getClass(objectArray))) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.must.implement.Script"));
        }
        Script script = (Script)clazz.newInstance();
        script.exec(context, scriptable);
    }

    private static Class getClass(Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (objectArray.length == 0) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.expected.string.arg"));
        }
        String string = Context.toString(objectArray[0]);
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.class.not.found", string));
        }
    }

    public static void serialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length < 2) {
            throw Context.reportRuntimeError("Expected an object to serialize and a filename to write the serialization to");
        }
        Object object = objectArray[0];
        String string = Context.toString(objectArray[1]);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ScriptableOutputStream scriptableOutputStream = new ScriptableOutputStream(fileOutputStream, scriptable2);
        scriptableOutputStream.writeObject(object);
        scriptableOutputStream.close();
    }

    public static Object deserialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException, ClassNotFoundException {
        if (objectArray.length < 1) {
            throw Context.reportRuntimeError("Expected a filename to read the serialization from");
        }
        String string = Context.toString(objectArray[0]);
        FileInputStream fileInputStream = new FileInputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ScriptableInputStream scriptableInputStream = new ScriptableInputStream(fileInputStream, scriptable2);
        Object object = scriptableInputStream.readObject();
        scriptableInputStream.close();
        return Context.toObject(object, scriptable2);
    }

    public static Object spawn(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Runner runner;
        Object object;
        Scriptable scriptable2 = function.getParentScope();
        if (objectArray.length != 0 && objectArray[0] instanceof Function) {
            object = null;
            if (objectArray.length > 1 && objectArray[1] instanceof Scriptable) {
                object = context.getElements((Scriptable)objectArray[1]);
            }
            runner = new Runner(scriptable2, (Function)objectArray[0], (Object[])object);
        } else if (objectArray.length != 0 && objectArray[0] instanceof Script) {
            runner = new Runner(scriptable2, (Script)objectArray[0]);
        } else {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.spawn.args"));
        }
        object = new Thread(runner);
        ((Thread)object).start();
        return object;
    }

    public static Object sync(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length == 1 && objectArray[0] instanceof Function) {
            return new Synchronizer((Function)objectArray[0]);
        }
        throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.spawn.args"));
    }

    public InputStream getIn() {
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream printStream) {
        this.outStream = printStream;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream printStream) {
        this.errStream = printStream;
    }

    public static Global getInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty(scriptable, privateName);
        if (object instanceof Global) {
            return (Global)object;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

