/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.Authenticator;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.JAuthenticator;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.PreferenceDialog;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.util.ApplicationSecurityEnforcer;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.util.gui.resource.ResourceManager;

public class Main
implements Application {
    public static final String UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION = ".load";
    public static final String PROPERTY_USER_HOME = "user.home";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String BATIK_CONFIGURATION_SUBDIRECTORY = ".batik";
    public static final String SQUIGGLE_CONFIGURATION_FILE = "preferences.xml";
    public static final String SQUIGGLE_POLICY_FILE = "__svgbrowser.policy";
    public static final String POLICY_GRANT_SCRIPT_NETWORK_ACCESS = "grant {\n  permission java.net.SocketPermission \"*\", \"listen, connect, resolve, accept\";\n};\n\n";
    public static final String POLICY_GRANT_SCRIPT_FILE_ACCESS = "grant {\n  permission java.io.FilePermission \"<<ALL FILES>>\", \"read\";\n};\n\n";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST = "preference.key.visited.uri.list";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST_LENGTH = "preference.key.visited.uri.list.length";
    public static final String URI_SEPARATOR = " ";
    public static final String SVG_INITIALIZATION = "resources/init.svg";
    protected String svgInitializationURI;
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.Main";
    public static final String SQUIGGLE_SECURITY_POLICY = "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.Main", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected static ImageIcon frameIcon = new ImageIcon((class$org$apache$batik$apps$svgbrowser$Main == null ? (class$org$apache$batik$apps$svgbrowser$Main = Main.class$("org.apache.batik.apps.svgbrowser.Main")) : class$org$apache$batik$apps$svgbrowser$Main).getResource(resources.getString("Frame.icon")));
    protected XMLPreferenceManager preferenceManager;
    public static final int MAX_VISITED_URIS = 10;
    protected Vector lastVisited = new Vector();
    protected int maxVisitedURIs = 10;
    protected String[] arguments;
    protected boolean overrideSecurityPolicy = false;
    protected ApplicationSecurityEnforcer securityEnforcer;
    protected Map handlers = new HashMap();
    protected List viewerFrames;
    protected PreferenceDialog preferenceDialog;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$Main;

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    public Main(String[] stringArray) {
        Serializable serializable;
        Object object;
        this.handlers.put("-font-size", new FontSizeHandler());
        this.viewerFrames = new LinkedList();
        this.arguments = stringArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(11);
        hashMap.put("preference.key.languages", Locale.getDefault().getLanguage());
        hashMap.put("preference.key.show.rendering", Boolean.FALSE);
        hashMap.put("preference.key.auto.adjust.window", Boolean.TRUE);
        hashMap.put("preference.key.selection.xor.mode", Boolean.FALSE);
        hashMap.put("preference.key.enable.double.buffering", Boolean.TRUE);
        hashMap.put("preference.key.show.debug.trace", Boolean.FALSE);
        hashMap.put("preference.key.proxy.host", "");
        hashMap.put("preference.key.proxy.port", "");
        hashMap.put("preference.key.cssmedia", "screen");
        hashMap.put("preference.key.is.xml.parser.validating", Boolean.FALSE);
        hashMap.put("preference.key.enforce.secure.scripting", Boolean.TRUE);
        hashMap.put("preference.key.grant.script.file.access", Boolean.FALSE);
        hashMap.put("preferenced.key.grant.script.network.access", Boolean.FALSE);
        hashMap.put("preference.key.load.java.script", Boolean.TRUE);
        hashMap.put("preference.key.load.ecmascript", Boolean.TRUE);
        hashMap.put("preference.key.allowed.script.origin", new Integer(2));
        hashMap.put("preference.key.allowed.external.resource.origin", new Integer(1));
        hashMap.put(PREFERENCE_KEY_VISITED_URI_LIST, "");
        hashMap.put(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH, new Integer(10));
        this.securityEnforcer = new ApplicationSecurityEnforcer(this.getClass(), SQUIGGLE_SECURITY_POLICY);
        Authenticator.setDefault(new JAuthenticator());
        try {
            this.preferenceManager = new XMLPreferenceManager(SQUIGGLE_CONFIGURATION_FILE, hashMap);
            object = System.getProperty(PROPERTY_USER_HOME);
            serializable = new File((String)object, BATIK_CONFIGURATION_SUBDIRECTORY);
            ((File)serializable).mkdir();
            XMLPreferenceManager.setPreferenceDirectory(((File)serializable).getCanonicalPath());
            this.preferenceManager.load();
            this.setPreferences();
            this.initializeLastVisited();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new AboutDialog();
        serializable = new JProgressBar(0, 3);
        ((JWindow)object).getContentPane().add("South", (Component)serializable);
        Dimension dimension = ((Window)object).getToolkit().getScreenSize();
        Dimension dimension2 = ((Container)object).getPreferredSize();
        ((Window)object).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Window)object).setSize(dimension2);
        ((Window)object).setVisible(true);
        JSVGViewerFrame jSVGViewerFrame = new JSVGViewerFrame(this);
        JSVGCanvas jSVGCanvas = jSVGViewerFrame.getJSVGCanvas();
        jSVGCanvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter((JProgressBar)serializable){
            private final /* synthetic */ JProgressBar val$pb;
            {
                this.val$pb = jProgressBar;
            }

            public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                this.val$pb.setValue(1);
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                this.val$pb.setValue(2);
            }
        });
        jSVGCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter((JProgressBar)serializable){
            private final /* synthetic */ JProgressBar val$pb;
            {
                this.val$pb = jProgressBar;
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                this.val$pb.setValue(3);
            }
        });
        jSVGCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter((AboutDialog)object, jSVGViewerFrame){
            private final /* synthetic */ AboutDialog val$initDialog;
            private final /* synthetic */ JSVGViewerFrame val$v;
            {
                this.val$initDialog = aboutDialog;
                this.val$v = jSVGViewerFrame;
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
                this.val$initDialog.dispose();
                this.val$v.dispose();
                System.gc();
                Main.this.run();
            }
        });
        jSVGCanvas.setSize(100, 100);
        this.svgInitializationURI = (class$org$apache$batik$apps$svgbrowser$Main == null ? (class$org$apache$batik$apps$svgbrowser$Main = Main.class$("org.apache.batik.apps.svgbrowser.Main")) : class$org$apache$batik$apps$svgbrowser$Main).getResource(SVG_INITIALIZATION).toString();
        jSVGCanvas.loadSVGDocument(this.svgInitializationURI);
    }

    public void installCustomPolicyFile() throws IOException {
        String string = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (this.overrideSecurityPolicy || string == null || "".equals(string)) {
            ParsedURL parsedURL = new ParsedURL(this.securityEnforcer.getPolicyURL());
            String string2 = System.getProperty(PROPERTY_USER_HOME);
            File file = new File(string2, BATIK_CONFIGURATION_SUBDIRECTORY);
            File file2 = new File(file, SQUIGGLE_POLICY_FILE);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(parsedURL.openStream()));
            FileWriter fileWriter = new FileWriter(file2);
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) != -1) {
                ((Writer)fileWriter).write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            boolean bl = this.preferenceManager.getBoolean("preferenced.key.grant.script.network.access");
            boolean bl2 = this.preferenceManager.getBoolean("preference.key.grant.script.file.access");
            if (bl) {
                fileWriter.write(POLICY_GRANT_SCRIPT_NETWORK_ACCESS);
            }
            if (bl2) {
                fileWriter.write(POLICY_GRANT_SCRIPT_FILE_ACCESS);
            }
            ((Writer)fileWriter).close();
            this.overrideSecurityPolicy = true;
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, file2.toURL().toString());
        }
    }

    public void run() {
        try {
            Object object;
            int n = 0;
            while (n < this.arguments.length) {
                object = (OptionHandler)this.handlers.get(this.arguments[n]);
                if (object == null) break;
                n = object.handleOption(n);
                ++n;
            }
            object = this.createAndShowJSVGViewerFrame();
            while (n < this.arguments.length) {
                if (this.arguments[n].length() == 0) {
                    ++n;
                    continue;
                }
                File file = new File(this.arguments[n]);
                String string = null;
                try {
                    if (file.canRead()) {
                        string = file.toURL().toString();
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (string == null) {
                    string = this.arguments[n];
                    ParsedURL parsedURL = null;
                    parsedURL = new ParsedURL(this.arguments[n]);
                    if (!parsedURL.complete()) {
                        string = null;
                    }
                }
                if (string != null) {
                    if (object == null) {
                        object = this.createAndShowJSVGViewerFrame();
                    }
                    ((JSVGViewerFrame)object).showSVGDocument(string);
                    object = null;
                } else {
                    JOptionPane.showMessageDialog((Component)object, resources.getString("Error.skipping.file") + this.arguments[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        System.out.println();
        System.out.println(resources.getString("Command.header"));
        System.out.println(resources.getString("Command.syntax"));
        System.out.println();
        System.out.println(resources.getString("Command.options"));
        Iterator iterator = this.handlers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(((OptionHandler)this.handlers.get(string)).getDescription());
        }
    }

    public JSVGViewerFrame createAndShowJSVGViewerFrame() {
        JSVGViewerFrame jSVGViewerFrame = new JSVGViewerFrame(this);
        jSVGViewerFrame.setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        jSVGViewerFrame.setIconImage(frameIcon.getImage());
        jSVGViewerFrame.setTitle(resources.getString("Frame.title"));
        jSVGViewerFrame.show();
        this.viewerFrames.add(jSVGViewerFrame);
        this.setPreferences(jSVGViewerFrame);
        return jSVGViewerFrame;
    }

    public void closeJSVGViewerFrame(JSVGViewerFrame jSVGViewerFrame) {
        jSVGViewerFrame.getJSVGCanvas().stopProcessing();
        this.viewerFrames.remove(jSVGViewerFrame);
        if (this.viewerFrames.size() == 0) {
            System.exit(0);
        }
        jSVGViewerFrame.dispose();
    }

    public Action createExitAction(JSVGViewerFrame jSVGViewerFrame) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
    }

    public void openLink(String string) {
        JSVGViewerFrame jSVGViewerFrame = this.createAndShowJSVGViewerFrame();
        jSVGViewerFrame.getJSVGCanvas().loadSVGDocument(string);
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public boolean isXMLParserValidating() {
        return this.preferenceManager.getBoolean("preference.key.is.xml.parser.validating");
    }

    public void showPreferenceDialog(JSVGViewerFrame jSVGViewerFrame) {
        block3: {
            if (this.preferenceDialog == null) {
                this.preferenceDialog = new PreferenceDialog(this.preferenceManager);
            }
            if (this.preferenceDialog.showDialog() != 0) break block3;
            try {
                this.preferenceManager.save();
                this.setPreferences();
            }
            catch (Exception exception) {}
        }
    }

    private void setPreferences() throws IOException {
        Iterator iterator = this.viewerFrames.iterator();
        while (iterator.hasNext()) {
            this.setPreferences((JSVGViewerFrame)iterator.next());
        }
        System.setProperty("proxyHost", this.preferenceManager.getString("preference.key.proxy.host"));
        System.setProperty("proxyPort", this.preferenceManager.getString("preference.key.proxy.port"));
        this.installCustomPolicyFile();
        this.securityEnforcer.enforceSecurity(this.preferenceManager.getBoolean("preference.key.enforce.secure.scripting"));
    }

    private void setPreferences(JSVGViewerFrame jSVGViewerFrame) {
        boolean bl = this.preferenceManager.getBoolean("preference.key.enable.double.buffering");
        jSVGViewerFrame.getJSVGCanvas().setDoubleBufferedRendering(bl);
        boolean bl2 = this.preferenceManager.getBoolean("preference.key.show.rendering");
        jSVGViewerFrame.getJSVGCanvas().setProgressivePaint(bl2);
        boolean bl3 = this.preferenceManager.getBoolean("preference.key.show.debug.trace");
        jSVGViewerFrame.setDebug(bl3);
        boolean bl4 = this.preferenceManager.getBoolean("preference.key.auto.adjust.window");
        jSVGViewerFrame.setAutoAdjust(bl4);
        boolean bl5 = this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
        jSVGViewerFrame.getJSVGCanvas().setSelectionOverlayXORMode(bl5);
    }

    public String getLanguages() {
        String string = this.preferenceManager.getString("preference.key.languages");
        return string == null ? Locale.getDefault().getLanguage() : string;
    }

    public String getUserStyleSheetURI() {
        return this.preferenceManager.getString("preference.key.user.stylesheet");
    }

    public String getMedia() {
        String string = this.preferenceManager.getString("preference.key.cssmedia");
        return string == null ? "screen" : string;
    }

    public boolean isSelectionOverlayXORMode() {
        return this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
    }

    public boolean canLoadScriptType(String string) {
        if ("text/ecmascript".equals(string)) {
            return this.preferenceManager.getBoolean("preference.key.load.ecmascript");
        }
        if ("application/java-archive".equals(string)) {
            return this.preferenceManager.getBoolean("preference.key.load.java.script");
        }
        return this.preferenceManager.getBoolean(string + UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION);
    }

    public int getAllowedScriptOrigin() {
        int n = this.preferenceManager.getInteger("preference.key.allowed.script.origin");
        return n;
    }

    public int getAllowedExternalResourceOrigin() {
        int n = this.preferenceManager.getInteger("preference.key.allowed.external.resource.origin");
        return n;
    }

    public void addVisitedURI(String string) {
        if (this.svgInitializationURI.equals(string)) {
            return;
        }
        int n = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH);
        if (n < 0) {
            n = 0;
        }
        if (this.lastVisited.contains(string)) {
            this.lastVisited.removeElement(string);
        }
        while (this.lastVisited.size() > 0 && this.lastVisited.size() > n - 1) {
            this.lastVisited.removeElementAt(0);
        }
        if (n > 0) {
            this.lastVisited.addElement(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.lastVisited.size()) {
            stringBuffer.append(URLEncoder.encode(this.lastVisited.elementAt(n2).toString()));
            stringBuffer.append(URI_SEPARATOR);
            ++n2;
        }
        this.preferenceManager.setString(PREFERENCE_KEY_VISITED_URI_LIST, stringBuffer.toString());
        try {
            this.preferenceManager.save();
        }
        catch (Exception exception) {}
    }

    public String[] getVisitedURIs() {
        Object[] objectArray = new String[this.lastVisited.size()];
        this.lastVisited.copyInto(objectArray);
        return objectArray;
    }

    protected void initializeLastVisited() {
        int n;
        String string = this.preferenceManager.getString(PREFERENCE_KEY_VISITED_URI_LIST);
        StringTokenizer stringTokenizer = new StringTokenizer(string, URI_SEPARATOR);
        int n2 = stringTokenizer.countTokens();
        if (n2 > (n = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH))) {
            n2 = n;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.lastVisited.addElement(URLDecoder.decode(stringTokenizer.nextToken()));
            ++n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FontSizeHandler
    implements OptionHandler {
        protected FontSizeHandler() {
        }

        public int handleOption(int n) {
            int n2 = Integer.parseInt(Main.this.arguments[++n]);
            Font font = new Font("Dialog", 0, n2);
            FontUIResource fontUIResource = new FontUIResource(font);
            UIManager.put("CheckBox.font", fontUIResource);
            UIManager.put("PopupMenu.font", fontUIResource);
            UIManager.put("TextPane.font", fontUIResource);
            UIManager.put("MenuItem.font", fontUIResource);
            UIManager.put("ComboBox.font", fontUIResource);
            UIManager.put("Button.font", fontUIResource);
            UIManager.put("Tree.font", fontUIResource);
            UIManager.put("ScrollPane.font", fontUIResource);
            UIManager.put("TabbedPane.font", fontUIResource);
            UIManager.put("EditorPane.font", fontUIResource);
            UIManager.put("TitledBorder.font", fontUIResource);
            UIManager.put("Menu.font", fontUIResource);
            UIManager.put("TextArea.font", fontUIResource);
            UIManager.put("OptionPane.font", fontUIResource);
            UIManager.put("DesktopIcon.font", fontUIResource);
            UIManager.put("MenuBar.font", fontUIResource);
            UIManager.put("ToolBar.font", fontUIResource);
            UIManager.put("RadioButton.font", fontUIResource);
            UIManager.put("RadioButtonMenuItem.font", fontUIResource);
            UIManager.put("ToggleButton.font", fontUIResource);
            UIManager.put("ToolTip.font", fontUIResource);
            UIManager.put("ProgressBar.font", fontUIResource);
            UIManager.put("TableHeader.font", fontUIResource);
            UIManager.put("Panel.font", fontUIResource);
            UIManager.put("List.font", fontUIResource);
            UIManager.put("ColorChooser.font", fontUIResource);
            UIManager.put("PasswordField.font", fontUIResource);
            UIManager.put("TextField.font", fontUIResource);
            UIManager.put("Table.font", fontUIResource);
            UIManager.put("Label.font", fontUIResource);
            UIManager.put("InternalFrameTitlePane.font", fontUIResource);
            UIManager.put("CheckBoxMenuItem.font", fontUIResource);
            return n;
        }

        public String getDescription() {
            return resources.getString("Command.font-size");
        }
    }

    protected static interface OptionHandler {
        public int handleOption(int var1);

        public String getDescription();
    }
}

