/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.DOMKeyEvent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

public class BridgeEventSupport
implements SVGConstants {
    private BridgeEventSupport() {
    }

    public static void addGVTListener(BridgeContext bridgeContext, Document document) {
        EventDispatcher eventDispatcher;
        UserAgent userAgent = bridgeContext.getUserAgent();
        if (userAgent != null && (eventDispatcher = userAgent.getEventDispatcher()) != null) {
            Listener listener = new Listener(bridgeContext, userAgent);
            eventDispatcher.addGraphicsNodeMouseListener(listener);
            eventDispatcher.addGraphicsNodeKeyListener(listener);
            GVTUnloadListener gVTUnloadListener = new GVTUnloadListener(eventDispatcher, listener);
            EventTarget eventTarget = (EventTarget)((Object)document);
            eventTarget.addEventListener("SVGUnload", gVTUnloadListener, false);
            bridgeContext.storeEventListener(eventTarget, "SVGUnload", gVTUnloadListener, false);
        }
    }

    protected static class Listener
    implements GraphicsNodeMouseListener,
    GraphicsNodeKeyListener {
        protected BridgeContext context;
        protected UserAgent ua;
        protected Element lastTargetElement;
        protected boolean isDown;

        public Listener(BridgeContext bridgeContext, UserAgent userAgent) {
            this.context = bridgeContext;
            this.ua = userAgent;
        }

        public void keyPressed(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            if (!this.isDown) {
                this.isDown = true;
                this.dispatchKeyEvent("keydown", graphicsNodeKeyEvent);
            }
        }

        public void keyReleased(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            this.dispatchKeyEvent("keyup", graphicsNodeKeyEvent);
            this.isDown = false;
        }

        public void keyTyped(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            this.dispatchKeyEvent("keypress", graphicsNodeKeyEvent);
        }

        protected void dispatchKeyEvent(String string, GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
            Element element = (Element)((Object)this.context.getFocusManager().getCurrentEventTarget());
            if (element == null) {
                return;
            }
            DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
            DOMKeyEvent dOMKeyEvent = (DOMKeyEvent)documentEvent.createEvent("KeyEvents");
            dOMKeyEvent.initKeyEvent(string, true, true, graphicsNodeKeyEvent.isControlDown(), graphicsNodeKeyEvent.isAltDown(), graphicsNodeKeyEvent.isShiftDown(), graphicsNodeKeyEvent.isMetaDown(), graphicsNodeKeyEvent.getKeyCode(), graphicsNodeKeyEvent.getKeyChar(), null);
            try {
                ((EventTarget)((Object)element)).dispatchEvent(dOMKeyEvent);
            }
            catch (RuntimeException runtimeException) {
                this.ua.displayError(runtimeException);
            }
        }

        public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("click", graphicsNodeMouseEvent, true);
        }

        public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousedown", graphicsNodeMouseEvent, true);
        }

        public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseup", graphicsNodeMouseEvent, true);
        }

        public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseover", graphicsNodeMouseEvent, true);
        }

        public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            Point point = this.getClientMouseLocation(graphicsNodeMouseEvent.getPoint2D());
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.getEventTarget(graphicsNode, point);
            if (this.lastTargetElement != null) {
                this.dispatchMouseEvent("mouseout", this.lastTargetElement, element, point, graphicsNodeMouseEvent, true);
            }
        }

        public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousemove", graphicsNodeMouseEvent, false);
        }

        public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            Point point = this.getClientMouseLocation(graphicsNodeMouseEvent.getPoint2D());
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.getEventTarget(graphicsNode, point);
            if (this.lastTargetElement != element) {
                if (this.lastTargetElement != null) {
                    this.dispatchMouseEvent("mouseout", this.lastTargetElement, element, point, graphicsNodeMouseEvent, true);
                }
                if (element != null) {
                    this.dispatchMouseEvent("mouseover", element, this.lastTargetElement, point, graphicsNodeMouseEvent, true);
                }
            }
            this.dispatchMouseEvent("mousemove", element, null, point, graphicsNodeMouseEvent, false);
        }

        protected void dispatchMouseEvent(String string, GraphicsNodeMouseEvent graphicsNodeMouseEvent, boolean bl) {
            Point point = this.getClientMouseLocation(graphicsNodeMouseEvent.getPoint2D());
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.getEventTarget(graphicsNode, point);
            Element element2 = this.getRelatedElement(graphicsNodeMouseEvent);
            this.dispatchMouseEvent(string, element, element2, point, graphicsNodeMouseEvent, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseEvent(String string, Element element, Element element2, Point point, GraphicsNodeMouseEvent graphicsNodeMouseEvent, boolean bl) {
            if (element == null) {
                return;
            }
            short s = this.getButton(graphicsNodeMouseEvent);
            Point point2 = graphicsNodeMouseEvent.getScreenPoint();
            DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
            MouseEvent mouseEvent = (MouseEvent)documentEvent.createEvent("MouseEvents");
            mouseEvent.initMouseEvent(string, true, bl, null, graphicsNodeMouseEvent.getClickCount(), point2.x, point2.y, point.x, point.y, graphicsNodeMouseEvent.isControlDown(), graphicsNodeMouseEvent.isAltDown(), graphicsNodeMouseEvent.isShiftDown(), graphicsNodeMouseEvent.isMetaDown(), s, (EventTarget)((Object)element2));
            try {
                try {
                    ((EventTarget)((Object)element)).dispatchEvent(mouseEvent);
                }
                catch (RuntimeException runtimeException) {
                    this.ua.displayError(runtimeException);
                    Object var13_12 = null;
                    this.lastTargetElement = element;
                }
                Object var13_11 = null;
                this.lastTargetElement = element;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                this.lastTargetElement = element;
                throw throwable;
            }
        }

        protected Element getRelatedElement(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            Element element = null;
            if (graphicsNode != null) {
                element = this.context.getElement(graphicsNode);
            }
            return element;
        }

        protected short getButton(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            int n = 1;
            if ((0x10 & graphicsNodeMouseEvent.getModifiers()) != 0) {
                n = 0;
            } else if ((4 & graphicsNodeMouseEvent.getModifiers()) != 0) {
                n = 2;
            }
            return (short)n;
        }

        protected Point getClientMouseLocation(Point2D point2D) {
            AffineTransform affineTransform = this.ua.getTransform();
            Point2D point2D2 = point2D;
            if (affineTransform != null && !affineTransform.isIdentity()) {
                point2D2 = affineTransform.transform(point2D, null);
            }
            return new Point((int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()));
        }

        protected Element getEventTarget(GraphicsNode graphicsNode, Point2D point2D) {
            Element element = this.context.getElement(graphicsNode);
            if (element != null && graphicsNode instanceof TextNode) {
                TextNode textNode = (TextNode)graphicsNode;
                List list = textNode.getTextRuns();
                try {
                    graphicsNode.getGlobalTransform().createInverse().transform(point2D, point2D);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
                if (list != null) {
                    int n = 0;
                    while (n < list.size()) {
                        Object object;
                        float f;
                        float f2;
                        StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n);
                        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
                        TextSpanLayout textSpanLayout = textRun.getLayout();
                        TextHit textHit = textSpanLayout.hitTestChar(f2 = (float)point2D.getX(), f = (float)point2D.getY());
                        if (textHit != null && textSpanLayout.getBounds2D().contains(f2, f) && (object = attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER)) instanceof Element) {
                            return (Element)object;
                        }
                        ++n;
                    }
                }
            }
            return element;
        }
    }

    protected static class GVTUnloadListener
    implements EventListener {
        protected EventDispatcher dispatcher;
        protected Listener listener;

        public GVTUnloadListener(EventDispatcher eventDispatcher, Listener listener) {
            this.dispatcher = eventDispatcher;
            this.listener = listener;
        }

        public void handleEvent(Event event) {
            this.dispatcher.removeGraphicsNodeMouseListener(this.listener);
            this.dispatcher.removeGraphicsNodeKeyListener(this.listener);
            event.getTarget().removeEventListener("SVGUnload", this, false);
        }
    }
}

