/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;

public abstract class MultipleGradientPaint
implements Paint {
    protected int transparency;
    protected float[] fractions;
    protected Color[] colors;
    protected AffineTransform gradientTransform;
    protected CycleMethodEnum cycleMethod;
    protected ColorSpaceEnum colorSpace;
    public static final CycleMethodEnum NO_CYCLE = new CycleMethodEnum();
    public static final CycleMethodEnum REFLECT = new CycleMethodEnum();
    public static final CycleMethodEnum REPEAT = new CycleMethodEnum();
    public static final ColorSpaceEnum SRGB = new ColorSpaceEnum();
    public static final ColorSpaceEnum LINEAR_RGB = new ColorSpaceEnum();

    public MultipleGradientPaint(float[] fArray, Color[] colorArray, CycleMethodEnum cycleMethodEnum, ColorSpaceEnum colorSpaceEnum, AffineTransform affineTransform) {
        if (fArray == null) {
            throw new IllegalArgumentException("Fractions array cannot be null");
        }
        if (colorArray == null) {
            throw new IllegalArgumentException("Colors array cannot be null");
        }
        if (fArray.length != colorArray.length) {
            throw new IllegalArgumentException("Colors and fractions must have equal size");
        }
        if (colorArray.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        if (colorSpaceEnum != LINEAR_RGB && colorSpaceEnum != SRGB) {
            throw new IllegalArgumentException("Invalid colorspace for interpolation.");
        }
        if (cycleMethodEnum != NO_CYCLE && cycleMethodEnum != REFLECT && cycleMethodEnum != REPEAT) {
            throw new IllegalArgumentException("Invalid cycle method.");
        }
        if (affineTransform == null) {
            throw new IllegalArgumentException("Gradient transform cannot be null.");
        }
        this.fractions = new float[fArray.length];
        System.arraycopy(fArray, 0, this.fractions, 0, fArray.length);
        this.colors = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.colors, 0, colorArray.length);
        this.colorSpace = colorSpaceEnum;
        this.cycleMethod = cycleMethodEnum;
        this.gradientTransform = (AffineTransform)affineTransform.clone();
        boolean bl = true;
        int n = 0;
        while (n < colorArray.length) {
            bl = bl && colorArray[n].getAlpha() == 255;
            ++n;
        }
        this.transparency = bl ? 1 : 3;
    }

    public Color[] getColors() {
        Color[] colorArray = new Color[this.colors.length];
        System.arraycopy(this.colors, 0, colorArray, 0, this.colors.length);
        return colorArray;
    }

    public float[] getFractions() {
        float[] fArray = new float[this.fractions.length];
        System.arraycopy(this.fractions, 0, fArray, 0, this.fractions.length);
        return fArray;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public CycleMethodEnum getCycleMethod() {
        return this.cycleMethod;
    }

    public ColorSpaceEnum getColorSpace() {
        return this.colorSpace;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.gradientTransform.clone();
    }

    public static class CycleMethodEnum {
    }

    public static class ColorSpaceEnum {
    }
}

