/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JDKRegistryEntry
extends AbstractRegistryEntry
implements URLRegistryEntry {
    public static final float PRIORITY = 1000000.0f;
    static Component mediaComponent = new Label();
    static MediaTracker mediaTracker = new MediaTracker(mediaComponent);
    static int id = 0;

    public JDKRegistryEntry() {
        super("JDK", 1000000.0f, new String[0], new String[]{"image/gif"});
    }

    public boolean isCompatibleURL(ParsedURL parsedURL) {
        try {
            URL uRL = new URL(parsedURL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public Filter handleURL(ParsedURL parsedURL, boolean bl) {
        URL uRL;
        try {
            uRL = new URL(parsedURL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(uRL);
        if (image == null) {
            return null;
        }
        RenderedImage renderedImage = this.loadImage(image);
        if (renderedImage == null) {
            return null;
        }
        return new RedRable(GraphicsUtil.wrap(renderedImage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage loadImage(Image image) {
        int n;
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        MediaTracker mediaTracker = JDKRegistryEntry.mediaTracker;
        synchronized (mediaTracker) {
            n = id++;
        }
        JDKRegistryEntry.mediaTracker.addImage(image, n);
        while (true) {
            try {
                JDKRegistryEntry.mediaTracker.waitForID(n);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        JDKRegistryEntry.mediaTracker.removeImage(image, n);
        if (image.getWidth(null) == -1 || image.getHeight(null) == -1) {
            return null;
        }
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

