/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.GlyphLayout;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONT_FAMILIES = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    private static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final Integer ADJUST_SPACING = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
    public static final Integer ADJUST_ALL = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
    public static final GVTAttributedCharacterIterator.TextAttribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    private void printAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        int n = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n2 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n2 - n) + ", ");
            attributedCharacterIterator.setIndex(n2);
            n = n2;
        }
        System.out.println("");
    }

    public List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        ArrayList arrayList = textNode.getTextRuns();
        if (arrayList != null) {
            return arrayList;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        int[][] nArrayArray = new int[attributedCharacterIteratorArray.length][];
        int n = attributedCharacterIterator.getBeginIndex();
        int n2 = 0;
        while (n2 < attributedCharacterIteratorArray.length) {
            object = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[n2], this.fontRenderContext, n);
            attributedCharacterIteratorArray[n2] = object;
            nArrayArray[n2] = ((BidiAttributedCharacterIterator)object).getCharMap();
            attributedCharacterIteratorArray[n2] = this.createModifiedACIForFontMatching(textNode, attributedCharacterIteratorArray[n2]);
            n += attributedCharacterIteratorArray[n2].getEndIndex() - attributedCharacterIteratorArray[n2].getBeginIndex();
            ++n2;
        }
        arrayList = new ArrayList();
        Object object2 = null;
        int n3 = 0;
        Point2D point2D = textNode.getLocation();
        do {
            attributedCharacterIteratorArray[n3].first();
            object = this.getTextChunk(textNode, attributedCharacterIteratorArray[n3], nArrayArray[n3], arrayList, (TextChunk)object2);
            attributedCharacterIteratorArray[n3].first();
            if (object != null) {
                point2D = this.adjustChunkOffsets(point2D, arrayList, (TextChunk)object);
            }
            object2 = object;
        } while (object != null && ++n3 < attributedCharacterIteratorArray.length);
        attributedCharacterIterator.first();
        List list = (List)attributedCharacterIterator.getAttribute(FLOW_REGIONS);
        if (list != null) {
            Iterator iterator = arrayList.iterator();
            ArrayList arrayList2 = new ArrayList();
            TextRun textRun = (TextRun)iterator.next();
            ArrayList<TextSpanLayout> arrayList3 = new ArrayList<TextSpanLayout>();
            arrayList2.add(arrayList3);
            arrayList3.add(textRun.getLayout());
            while (iterator.hasNext()) {
                textRun = (TextRun)iterator.next();
                if (textRun.isFirstRunInChunk()) {
                    arrayList3 = new ArrayList();
                    arrayList2.add(arrayList3);
                }
                arrayList3.add(textRun.getLayout());
            }
            GlyphLayout.textWrapTextChunk(attributedCharacterIteratorArray, arrayList2, list);
        }
        textNode.setTextRuns(arrayList);
        return arrayList;
    }

    private AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Object object;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        int n2 = attributedCharacterIterator.getBeginIndex();
        attributedCharacterIterator.first();
        Object object2 = attributedCharacterIterator.getAttribute(WRITING_MODE);
        boolean bl = object2 == WRITING_MODE_TTB;
        while (attributedCharacterIterator.setIndex(n2) != '\uffff') {
            object = null;
            int n3 = n2;
            n = 0;
            while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
                Float f;
                Serializable serializable;
                TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
                if (n3 != n2) {
                    if (!bl ? (serializable = (Float)attributedCharacterIterator.getAttribute(XPOS)) != null && !serializable.isNaN() : (serializable = (Float)attributedCharacterIterator.getAttribute(YPOS)) != null && !serializable.isNaN()) break;
                    if (object == null && textPath != null) break;
                }
                object = textPath;
                if (attributedCharacterIterator.getAttribute(FLOW_PARAGRAPH) != null) {
                    n = attributedCharacterIterator.getRunLimit(FLOW_PARAGRAPH);
                    attributedCharacterIterator.setIndex(n);
                    break;
                }
                n = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
                if (n3 == n2 && (serializable = (TextNode.Anchor)attributedCharacterIterator.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START && !(bl ? (f = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f.isNaN() : (f = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f.isNaN())) {
                    int n4 = n3 + 1;
                    while (n4 < n) {
                        Float f2;
                        attributedCharacterIterator.setIndex(n4);
                        if (bl ? (f2 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f2.isNaN() : (f2 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f2.isNaN()) break;
                        arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n4 - 1, n4));
                        n2 = n4++;
                    }
                }
                n3 = n;
            }
            int n5 = attributedCharacterIterator.getIndex();
            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n5));
            n2 = n5;
        }
        object = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            object[n] = (AttributedCharacterIterator)iterator.next();
            ++n;
        }
        return object;
    }

    private AttributedCharacterIterator createModifiedACIForFontMatching(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedString attributedString = null;
        int n = 0;
        int n2 = attributedCharacterIterator.getBeginIndex();
        boolean bl = true;
        int n3 = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_DELIMITER);
        while (bl) {
            int n4;
            GVTFont gVTFont;
            GVTFontFamily gVTFontFamily;
            int n5;
            int n6 = n3;
            n3 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
            int n7 = n3 - n6;
            Vector vector = (Vector)attributedCharacterIterator.getAttributes().get(GVT_FONT_FAMILIES);
            if (vector == null) {
                n += n7;
                bl = attributedCharacterIterator.setIndex(n3) != '\uffff';
                continue;
            }
            ArrayList<GVTFontFamily> arrayList = new ArrayList<GVTFontFamily>(vector.size());
            int n8 = 0;
            while (n8 < vector.size()) {
                GVTFontFamily gVTFontFamily2 = (GVTFontFamily)vector.get(n8);
                if (gVTFontFamily2 instanceof UnresolvedFontFamily) {
                    gVTFontFamily2 = FontFamilyResolver.resolve((UnresolvedFontFamily)gVTFontFamily2);
                }
                if (gVTFontFamily2 != null) {
                    arrayList.add(gVTFontFamily2);
                }
                ++n8;
            }
            if (arrayList.size() == 0) {
                arrayList.add(FontFamilyResolver.defaultFont);
            }
            float f = 12.0f;
            Float f2 = (Float)attributedCharacterIterator.getAttributes().get(TextAttribute.SIZE);
            if (f2 != null) {
                f = f2.floatValue();
            }
            boolean[] blArray = new boolean[n7];
            if (attributedString == null) {
                attributedString = new AttributedString(attributedCharacterIterator);
            }
            GVTFont gVTFont2 = null;
            int n9 = 0;
            int n10 = n6;
            int n11 = 0;
            while (n11 < arrayList.size()) {
                n5 = n10;
                boolean bl2 = false;
                attributedCharacterIterator.setIndex(n5);
                gVTFontFamily = (GVTFontFamily)arrayList.get(n11);
                gVTFont = gVTFontFamily.deriveFont(f, attributedCharacterIterator);
                if (gVTFont2 == null) {
                    gVTFont2 = gVTFont;
                }
                while (n5 < n3) {
                    n4 = gVTFont.canDisplayUpTo(attributedCharacterIterator, n5, n3);
                    Object object = attributedCharacterIterator.getAttributes().get(ALT_GLYPH_HANDLER);
                    if (object != null) {
                        n4 = -1;
                    }
                    if (n4 == -1) {
                        n4 = n3;
                    }
                    if (n4 <= n5) {
                        if (!bl2) {
                            n10 = n5;
                            bl2 = true;
                        }
                        ++n5;
                        continue;
                    }
                    int n12 = -1;
                    int n13 = n5;
                    while (n13 < n4) {
                        if (blArray[n13 - n6]) {
                            if (n12 != -1) {
                                attributedString.addAttribute(GVT_FONT, gVTFont, n12 - n2, n13 - n2);
                                n12 = -1;
                            }
                        } else if (n12 == -1) {
                            n12 = n13;
                        }
                        blArray[n13 - n6] = true;
                        ++n9;
                        ++n13;
                    }
                    if (n12 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n12 - n2, n4 - n2);
                    }
                    n5 = n4 + 1;
                }
                if (n9 == n7) break;
                ++n11;
            }
            n5 = -1;
            gVTFontFamily = null;
            gVTFont = gVTFont2;
            n4 = 0;
            while (n4 < n7) {
                if (blArray[n4]) {
                    if (n5 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n4 + n);
                        n5 = -1;
                        gVTFont = null;
                        gVTFontFamily = null;
                    }
                } else {
                    char c = attributedCharacterIterator.setIndex(n6 + n4);
                    GVTFontFamily gVTFontFamily3 = FontFamilyResolver.getFamilyThatCanDisplay(c);
                    if (n5 == -1) {
                        n5 = n4;
                        gVTFontFamily = gVTFontFamily3;
                        gVTFont = gVTFontFamily == null ? gVTFont2 : gVTFontFamily3.deriveFont(f, attributedCharacterIterator);
                    } else if (gVTFontFamily != gVTFontFamily3) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n4 + n);
                        n5 = n4;
                        gVTFontFamily = gVTFontFamily3;
                        gVTFont = gVTFontFamily == null ? gVTFont2 : gVTFontFamily3.deriveFont(f, attributedCharacterIterator);
                    }
                }
                ++n4;
            }
            if (n5 != -1) {
                attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n7 + n);
            }
            n += n7;
            if (attributedCharacterIterator.setIndex(n3) == '\uffff') {
                bl = false;
            }
            n6 = n3;
        }
        if (attributedString != null) {
            return attributedString.getIterator();
        }
        return attributedCharacterIterator;
    }

    private TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, int[] nArray, List list, TextChunk textChunk) {
        int n = 0;
        if (textChunk != null) {
            n = textChunk.end;
        }
        int n2 = n;
        int n3 = attributedCharacterIterator.getIndex();
        if (attributedCharacterIterator.current() == '\uffff') {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
        boolean bl = true;
        TextSpanLayout textSpanLayout = null;
        while (true) {
            int n4 = attributedCharacterIterator.getRunStart(extendedAtts);
            int n5 = attributedCharacterIterator.getRunLimit(extendedAtts);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n4, n5);
            int[] nArray2 = new int[n5 - n4];
            int n6 = 0;
            while (n6 < nArray2.length) {
                nArray2[n6] = nArray[n6 + n4 - n3];
                ++n6;
            }
            textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterSpanIterator, nArray2, float_, this.fontRenderContext);
            list.add(new TextRun(textSpanLayout, attributedCharacterSpanIterator, bl));
            Point2D point2D = textSpanLayout.getAdvance2D();
            float_2.x += (float)point2D.getX();
            float_2.y += (float)point2D.getY();
            ++n2;
            if (attributedCharacterIterator.setIndex(n5) == '\uffff') break;
            bl = false;
        }
        return new TextChunk(n, n2, float_2);
    }

    private Point2D adjustChunkOffsets(Point2D point2D, List list, TextChunk textChunk) {
        Object object;
        int n;
        Cloneable cloneable;
        float f;
        Point2D.Float float_;
        TextRun textRun = (TextRun)list.get(textChunk.begin);
        int n2 = textRun.getAnchorType();
        Float f2 = textRun.getLength();
        Integer n3 = textRun.getLengthAdjust();
        boolean bl = true;
        if (f2 == null || f2.isNaN()) {
            bl = false;
        }
        int n4 = 0;
        int n5 = textChunk.begin;
        while (n5 < textChunk.end) {
            textRun = (TextRun)list.get(n5);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            n4 += attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
            ++n5;
        }
        if (n3 == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && n4 == 1) {
            bl = false;
        }
        float f3 = 1.0f;
        float f4 = 1.0f;
        textRun = (TextRun)list.get(textChunk.end - 1);
        TextSpanLayout textSpanLayout = textRun.getLayout();
        GVTGlyphMetrics gVTGlyphMetrics = textSpanLayout.getGlyphMetrics(textSpanLayout.getGlyphCount() - 1);
        Rectangle2D rectangle2D = gVTGlyphMetrics.getBounds2D();
        float f5 = (float)(rectangle2D.getWidth() + rectangle2D.getX());
        float f6 = (float)(rectangle2D.getHeight() + rectangle2D.getY());
        if (!bl) {
            float_ = new Point2D.Float((float)(textChunk.advance.getX() + (double)f5 - (double)gVTGlyphMetrics.getHorizontalAdvance()), (float)(textChunk.advance.getY() + (double)f6 - (double)gVTGlyphMetrics.getVerticalAdvance()));
        } else {
            double d;
            Point2D point2D2 = textChunk.advance;
            f = 0.0f;
            if (textSpanLayout.isVertical()) {
                if (n3 == ADJUST_SPACING) {
                    f4 = (float)((double)(f2.floatValue() - f6) / (point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance()));
                } else {
                    d = point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance() + (double)f6;
                    f4 = (float)((double)f2.floatValue() / d);
                }
                float_ = new Point2D.Float(0.0f, f2.floatValue());
            } else {
                if (n3 == ADJUST_SPACING) {
                    f3 = (float)((double)(f2.floatValue() - f5) / (point2D2.getX() - (double)gVTGlyphMetrics.getHorizontalAdvance()));
                } else {
                    d = point2D2.getX() + (double)f5 - (double)gVTGlyphMetrics.getHorizontalAdvance();
                    f3 = (float)((double)f2.floatValue() / d);
                }
                float_ = new Point2D.Float(f2.floatValue(), 0.0f);
            }
            cloneable = new Point2D.Float(0.0f, 0.0f);
            n = textChunk.begin;
            while (n < textChunk.end) {
                textRun = (TextRun)list.get(n);
                textSpanLayout = textRun.getLayout();
                textSpanLayout.setScale(f3, f4, n3 == ADJUST_SPACING);
                object = textSpanLayout.getAdvance2D();
                ((Point2D.Float)cloneable).x += (float)((Point2D)object).getX();
                ((Point2D.Float)cloneable).y += (float)((Point2D)object).getY();
                ++n;
            }
            textChunk.advance = cloneable;
        }
        float f7 = 0.0f;
        f = 0.0f;
        switch (n2) {
            case 1: {
                f7 = (float)(-((Point2D)float_).getX() / 2.0);
                f = (float)(-((Point2D)float_).getY() / 2.0);
                break;
            }
            case 2: {
                f7 = (float)(-((Point2D)float_).getX());
                f = (float)(-((Point2D)float_).getY());
                break;
            }
        }
        textRun = (TextRun)list.get(textChunk.begin);
        textSpanLayout = textRun.getLayout();
        cloneable = textRun.getACI();
        cloneable.first();
        n = textSpanLayout.isVertical() ? 1 : 0;
        object = (Float)cloneable.getAttribute(XPOS);
        Float f8 = (Float)cloneable.getAttribute(YPOS);
        TextPath textPath = (TextPath)cloneable.getAttribute(TEXTPATH);
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        float f11 = 0.0f;
        float f12 = 0.0f;
        if (object != null && !((Float)object).isNaN()) {
            f11 = f9 = ((Float)object).floatValue();
        }
        if (f8 != null && !f8.isNaN()) {
            f12 = f10 = f8.floatValue();
        }
        if (n != 0) {
            f10 += f;
            f12 += f;
            f11 = 0.0f;
        } else {
            f9 += f7;
            f11 += f7;
            f12 = 0.0f;
        }
        int n6 = textChunk.begin;
        while (n6 < textChunk.end) {
            Point2D point2D3;
            textRun = (TextRun)list.get(n6);
            textSpanLayout = textRun.getLayout();
            cloneable = textRun.getACI();
            cloneable.first();
            textPath = (TextPath)cloneable.getAttribute(TEXTPATH);
            if (textPath == null) {
                textSpanLayout.setOffset(new Point2D.Float(f9, f10));
                point2D3 = textSpanLayout.getAdvance2D();
                f9 = (float)((double)f9 + point2D3.getX());
                f10 = (float)((double)f10 + point2D3.getY());
            } else {
                textSpanLayout.setOffset(new Point2D.Float(f11, f12));
                point2D3 = textSpanLayout.getAdvance2D();
                f11 += (float)point2D3.getX();
                f12 += (float)point2D3.getY();
                point2D3 = textSpanLayout.getTextPathAdvance();
                f9 = (float)point2D3.getX();
                f10 = (float)point2D3.getY();
            }
            ++n6;
        }
        return new Point2D.Float(f9, f10);
    }

    private void paintDecorations(List list, Graphics2D graphics2D, int n) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null) {
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(rectangle2D);
                }
                if (stroke != null && paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(rectangle2D);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangle2D);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangle2D);
            }
        }
    }

    private void paintTextRuns(List list, Graphics2D graphics2D) {
        int n = 0;
        while (n < list.size()) {
            TextRun textRun = (TextRun)list.get(n);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            textRun.getLayout().draw(graphics2D);
            ++n;
        }
    }

    public Shape getOutline(TextNode textNode) {
        Shape shape;
        Object object;
        Object object2;
        Shape shape2 = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            object2 = (TextRun)list.get(n);
            object = ((TextRun)object2).getLayout();
            shape = new GeneralPath(object.getOutline());
            if (shape2 == null) {
                shape2 = shape;
            } else {
                ((Path2D)shape2).setWindingRule(1);
                ((Path2D)shape2).append(shape, false);
            }
            ++n;
        }
        object2 = this.getDecorationOutline(list, 1);
        object = this.getDecorationOutline(list, 2);
        shape = this.getDecorationOutline(list, 4);
        if (object2 != null) {
            if (shape2 == null) {
                shape2 = new GeneralPath((Shape)object2);
            } else {
                ((Path2D)shape2).setWindingRule(1);
                ((Path2D)shape2).append((Shape)object2, false);
            }
        }
        if (object != null) {
            if (shape2 == null) {
                shape2 = new GeneralPath((Shape)object);
            } else {
                ((Path2D)shape2).setWindingRule(1);
                ((Path2D)shape2).append((Shape)object, false);
            }
        }
        if (shape != null) {
            if (shape2 == null) {
                shape2 = new GeneralPath(shape);
            } else {
                ((Path2D)shape2).setWindingRule(1);
                ((Path2D)shape2).append(shape, false);
            }
        }
        return shape2;
    }

    public Rectangle2D getBounds2D(TextNode textNode) {
        Object object;
        Object object2;
        Shape shape;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (n < list.size()) {
            shape = null;
            object2 = (TextRun)list.get(n);
            object = ((TextRun)object2).getACI();
            object.first();
            TextSpanLayout textSpanLayout = ((TextRun)object2).getLayout();
            rectangle2D = rectangle2D == null ? textSpanLayout.getBounds2D() : rectangle2D.createUnion(textSpanLayout.getBounds2D());
            ++n;
        }
        shape = this.getDecorationStrokeOutline(list, 1);
        if (shape != null) {
            rectangle2D = rectangle2D == null ? shape.getBounds2D() : rectangle2D.createUnion(shape.getBounds2D());
        }
        if ((object2 = this.getDecorationStrokeOutline(list, 2)) != null) {
            rectangle2D = rectangle2D == null ? object2.getBounds2D() : rectangle2D.createUnion(object2.getBounds2D());
        }
        if ((object = this.getDecorationStrokeOutline(list, 4)) != null) {
            rectangle2D = rectangle2D == null ? object.getBounds2D() : rectangle2D.createUnion(object.getBounds2D());
        }
        return rectangle2D;
    }

    private Shape getDecorationOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangle2D);
                } else {
                    path2D.append(rectangle2D, false);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangle2D);
            } else {
                path2D.append(rectangle2D, false);
            }
        }
        return path2D;
    }

    private Shape getDecorationStrokeOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null && stroke != null && paint2 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(stroke.createStrokedShape(rectangle2D));
                } else {
                    path2D.append(stroke.createStrokedShape(rectangle2D), false);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null && stroke != null && paint2 != null) {
            if (path2D == null) {
                path2D = new GeneralPath(stroke.createStrokedShape(rectangle2D));
            } else {
                path2D.append(stroke.createStrokedShape(rectangle2D), false);
            }
        }
        return path2D;
    }

    public Mark getMark(TextNode textNode, int n, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (n < attributedCharacterIterator.getBeginIndex() || n > attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        TextHit textHit = new TextHit(n, bl);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    protected Mark hitTest(double d, double d2, TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            TextRun textRun = (TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            TextHit textHit = textSpanLayout.hitTestChar((float)d, (float)d2);
            if (textHit != null && textSpanLayout.getBounds2D().contains(d, d2)) {
                return new BasicTextPainter.BasicMark(textNode, textHit);
            }
            ++n;
        }
        return null;
    }

    public Mark selectFirst(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextHit textHit = new TextHit(attributedCharacterIterator.getBeginIndex(), false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    public Mark selectLast(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextHit textHit = new TextHit(attributedCharacterIterator.getEndIndex(), false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    public int[] getSelected(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Iterator iterator = list.iterator();
        int n = -1;
        int n2 = -1;
        TextSpanLayout textSpanLayout = null;
        TextSpanLayout textSpanLayout2 = null;
        while (iterator.hasNext()) {
            TextRun textRun = (TextRun)iterator.next();
            TextSpanLayout textSpanLayout3 = textRun.getLayout();
            if (n == -1 && (n = textSpanLayout3.getGlyphIndex(nArray[0])) != -1) {
                textSpanLayout = textSpanLayout3;
            }
            if (n2 == -1 && (n2 = textSpanLayout3.getGlyphIndex(nArray[1])) != -1) {
                textSpanLayout2 = textSpanLayout3;
            }
            if (n != -1 && n2 != -1) break;
        }
        if (textSpanLayout == null || textSpanLayout2 == null) {
            return null;
        }
        int n3 = textSpanLayout.getCharacterCount(n, n);
        int n4 = textSpanLayout2.getCharacterCount(n2, n2);
        if (n3 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n3 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n3 - 1);
            }
        }
        if (n4 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n4 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n4 - 1);
            }
        }
        return nArray;
    }

    public Shape getHighlightShape(Mark mark, Mark mark2) {
        Object object;
        int n;
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        if (textNode == null) {
            return null;
        }
        int n2 = basicMark2.getHit().getCharIndex();
        if (n2 > (n = basicMark.getHit().getCharIndex())) {
            object = basicMark2;
            basicMark2 = basicMark;
            basicMark = object;
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        object = this.getTextRuns(textNode, textNode.getAttributedCharacterIterator());
        GeneralPath generalPath = new GeneralPath();
        int n4 = 0;
        while (n4 < object.size()) {
            TextRun textRun = (TextRun)object.get(n4);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Shape shape = textSpanLayout.getHighlightShape(n2, n);
            if (shape != null && !shape.getBounds().isEmpty()) {
                generalPath.append(shape, false);
            }
            ++n4;
        }
        return generalPath;
    }

    static {
        extendedAtts.add(FLOW_PARAGRAPH);
        extendedAtts.add(TEXT_COMPOUND_DELIMITER);
        extendedAtts.add(GVT_FONT);
        extendedAtts.add(BIDI_LEVEL);
        singleton = new StrokingTextPainter();
    }

    public class TextRun {
        private AttributedCharacterIterator aci;
        private TextSpanLayout layout;
        private int anchorType;
        private boolean firstRunInChunk;
        private Float length;
        private Integer lengthAdjust;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl;
            this.anchorType = 0;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
            this.length = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
            this.lengthAdjust = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public Float getLength() {
            return this.length;
        }

        public Integer getLengthAdjust() {
            return this.lengthAdjust;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n, int n2, Point2D point2D) {
            this.begin = n;
            this.end = n2;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

