/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.w3c.dom.Document;

public class InterpreterPool {
    private static final String RHINO = "org.apache.batik.script.rhino.RhinoInterpreterFactory";
    private static final String JPYTHON = "org.apache.batik.script.jpython.JPythonInterpreterFactory";
    private static final String JACL = "org.apache.batik.script.jacl.JaclInterpreterFactory";
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories = new HashMap(7);
    protected Map factories = new HashMap(7);

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String string) {
        Interpreter interpreter;
        block3: {
            InterpreterFactory interpreterFactory = (InterpreterFactory)this.factories.get(string);
            interpreter = null;
            if (interpreterFactory == null) break block3;
            try {
                interpreter = interpreterFactory.createInterpreter(((SVGOMDocument)document).getURLObject());
                if (document != null) {
                    interpreter.bindObject(BIND_NAME_DOCUMENT, document);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return interpreter;
    }

    public void putInterpreterFactory(String string, InterpreterFactory interpreterFactory) {
        this.factories.put(string, interpreterFactory);
    }

    public void removeInterpreterFactory(String string) {
        this.factories.remove(string);
    }

    static {
        InterpreterFactory interpreterFactory = null;
        try {
            interpreterFactory = (InterpreterFactory)Class.forName(RHINO).newInstance();
            defaultFactories.put("text/ecmascript", interpreterFactory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            interpreterFactory = (InterpreterFactory)Class.forName(JPYTHON).newInstance();
            defaultFactories.put("text/python", interpreterFactory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            interpreterFactory = (InterpreterFactory)Class.forName(JACL).newInstance();
            defaultFactories.put("text/tcl", interpreterFactory);
        }
        catch (Throwable throwable) {}
    }
}

