/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    private RhinoInterpreter interpreter;
    private NativeJavaMethod methodadd;
    private NativeJavaMethod methodremove;
    private HashMap listenerMap;
    private static final String ADD_NAME = "addEventListener";
    private static final String REMOVE_NAME = "removeEventListener";
    private static final Class[] ARGS_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$events$EventListener == null ? (class$org$w3c$dom$events$EventListener = EventTargetWrapper.class$("org.w3c.dom.events.EventListener")) : class$org$w3c$dom$events$EventListener, Boolean.TYPE};
    private static final String NAME = "name";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$w3c$dom$events$EventListener;

    EventTargetWrapper(Scriptable scriptable, EventTarget eventTarget, RhinoInterpreter rhinoInterpreter) {
        super(scriptable, (Object)eventTarget, (Class)null);
        this.interpreter = rhinoInterpreter;
        try {
            this.methodadd = new RhinoNativeJavaMethod(eventTarget.getClass().getMethod(ADD_NAME, ARGS_TYPE), ADD_NAME);
            this.methodremove = new RhinoNativeJavaMethod(eventTarget.getClass().getMethod(REMOVE_NAME, ARGS_TYPE), REMOVE_NAME);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        object = string.equals(ADD_NAME) ? this.methodadd : (string.equals(REMOVE_NAME) ? this.methodremove : super.get(string, scriptable));
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RhinoNativeJavaMethod
    extends NativeJavaMethod {
        RhinoNativeJavaMethod(Method method, String string) {
            super(method, string);
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            if (objectArray[1] instanceof Function) {
                if (this.get(EventTargetWrapper.NAME, (Scriptable)this).equals(EventTargetWrapper.ADD_NAME)) {
                    FunctionEventListener functionEventListener = new FunctionEventListener((Function)objectArray[1]);
                    if (EventTargetWrapper.this.listenerMap == null) {
                        EventTargetWrapper.this.listenerMap = new HashMap(2);
                    }
                    EventTargetWrapper.this.listenerMap.put(objectArray[1], functionEventListener);
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                    int n = 0;
                    while (n < objectArray.length) {
                        objectArray[n] = NativeJavaObject.coerceType((Class)classArray[n], (Object)objectArray[n]);
                        ++n;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).addEventListener((String)objectArray[0], functionEventListener, (Boolean)objectArray[2]);
                    return Undefined.instance;
                }
                if (EventTargetWrapper.this.listenerMap != null) {
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                    int n = 0;
                    while (n < objectArray.length) {
                        objectArray[n] = NativeJavaObject.coerceType((Class)classArray[n], (Object)objectArray[n]);
                        ++n;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).removeEventListener((String)objectArray[0], (EventListener)EventTargetWrapper.this.listenerMap.remove(objectArray[1]), (Boolean)objectArray[2]);
                }
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                if (this.get(EventTargetWrapper.NAME, (Scriptable)this).equals(EventTargetWrapper.ADD_NAME)) {
                    HandleEventListener handleEventListener = new HandleEventListener((Scriptable)objectArray[1]);
                    if (EventTargetWrapper.this.listenerMap == null) {
                        EventTargetWrapper.this.listenerMap = new HashMap(2);
                    }
                    EventTargetWrapper.this.listenerMap.put(objectArray[1], handleEventListener);
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                    int n = 0;
                    while (n < objectArray.length) {
                        objectArray[n] = NativeJavaObject.coerceType((Class)classArray[n], (Object)objectArray[n]);
                        ++n;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).addEventListener((String)objectArray[0], handleEventListener, (Boolean)objectArray[2]);
                    return Undefined.instance;
                }
                if (EventTargetWrapper.this.listenerMap != null) {
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                    int n = 0;
                    while (n < objectArray.length) {
                        objectArray[n] = NativeJavaObject.coerceType((Class)classArray[n], (Object)objectArray[n]);
                        ++n;
                    }
                    ((EventTarget)EventTargetWrapper.this.unwrap()).removeEventListener((String)objectArray[0], (EventListener)EventTargetWrapper.this.listenerMap.remove(objectArray[1]), (Boolean)objectArray[2]);
                }
                return Undefined.instance;
            }
            return super.call(context, scriptable, scriptable2, objectArray);
        }
    }

    class HandleEventListener
    implements EventListener {
        private static final String HANDLE_EVENT = "handleEvent";
        private Scriptable scriptable;
        private Object[] array = new Object[1];

        HandleEventListener(Scriptable scriptable) {
            this.scriptable = scriptable;
        }

        public void handleEvent(Event event) {
            try {
                this.array[0] = event;
                ScriptableObject.callMethod((Scriptable)this.scriptable, (String)HANDLE_EVENT, (Object[])this.array);
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }

    class FunctionEventListener
    implements EventListener {
        private Function function;

        FunctionEventListener(Function function) {
            this.function = function;
        }

        public void handleEvent(Event event) {
            try {
                EventTargetWrapper.this.interpreter.callHandler(this.function, event);
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }
}

