/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoadEventDispatcher
extends Thread {
    protected SVGDocument svgDocument;
    protected GraphicsNode root;
    protected BridgeContext bridgeContext;
    protected UpdateManager updateManager;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;

    public SVGLoadEventDispatcher(GraphicsNode graphicsNode, SVGDocument sVGDocument, BridgeContext bridgeContext, UpdateManager updateManager) {
        this.svgDocument = sVGDocument;
        this.root = graphicsNode;
        this.bridgeContext = bridgeContext;
        this.updateManager = updateManager;
    }

    public void run() {
        try {
            this.fireStartedEvent();
            this.updateManager.dispatchSVGLoadEvent();
            this.fireCompletedEvent();
        }
        catch (InterruptedException interruptedException) {
            this.fireCancelledEvent();
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireFailedEvent();
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.listeners.add(sVGLoadEventDispatcherListener);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.listeners.remove(sVGLoadEventDispatcherListener);
    }

    protected void fireStartedEvent() throws InterruptedException {
        block5: {
            final Object[] objectArray = this.listeners.toArray();
            if (objectArray.length <= 0) break block5;
            final SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                    sVGLoadEventDispatcherListener.svgLoadEventDispatchStarted(sVGLoadEventDispatcherEvent);
                    ++n;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int n = 0;
                            while (n < objectArray.length) {
                                SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                                sVGLoadEventDispatcherListener.svgLoadEventDispatchStarted(sVGLoadEventDispatcherEvent);
                                ++n;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
    }

    protected void fireCompletedEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                    sVGLoadEventDispatcherListener.svgLoadEventDispatchCompleted(sVGLoadEventDispatcherEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                            sVGLoadEventDispatcherListener.svgLoadEventDispatchCompleted(sVGLoadEventDispatcherEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                    sVGLoadEventDispatcherListener.svgLoadEventDispatchFailed(sVGLoadEventDispatcherEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                            sVGLoadEventDispatcherListener.svgLoadEventDispatchFailed(sVGLoadEventDispatcherEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireCancelledEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                    sVGLoadEventDispatcherListener.svgLoadEventDispatchCancelled(sVGLoadEventDispatcherEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener = (SVGLoadEventDispatcherListener)objectArray[n];
                            sVGLoadEventDispatcherListener.svgLoadEventDispatchCancelled(sVGLoadEventDispatcherEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }
}

