/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.trans.DynamicError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StandardErrorHandler
implements ErrorHandler,
SourceLocator {
    private ErrorListener errorListener;
    private String systemId;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private Writer errorOutput = new PrintWriter(System.err);

    public StandardErrorHandler(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setErrorOutput(Writer writer) {
        this.errorOutput = writer;
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.errorListener != null) {
            try {
                this.errorListener.warning(new TransformerException(sAXParseException));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, false);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, true);
        throw sAXParseException;
    }

    protected void reportError(SAXParseException sAXParseException, boolean bl) {
        block7: {
            if (this.errorListener != null) {
                try {
                    this.systemId = sAXParseException.getSystemId();
                    this.lineNumber = sAXParseException.getLineNumber();
                    this.columnNumber = sAXParseException.getColumnNumber();
                    DynamicError dynamicError = new DynamicError("Error reported by XML parser", this, sAXParseException);
                    dynamicError.setErrorCode("SXXP0003");
                    if (bl) {
                        this.errorListener.fatalError(dynamicError);
                        break block7;
                    }
                    this.errorListener.error(dynamicError);
                }
                catch (Exception exception) {}
            } else {
                try {
                    String string = bl ? "Fatal error" : "Error";
                    this.errorOutput.write(string + " reported by XML parser: " + sAXParseException.getMessage() + "\n");
                    this.errorOutput.write("  URL:    " + sAXParseException.getSystemId() + "\n");
                    this.errorOutput.write("  Line:   " + sAXParseException.getLineNumber() + "\n");
                    this.errorOutput.write("  Column: " + sAXParseException.getColumnNumber() + "\n");
                    this.errorOutput.flush();
                }
                catch (Exception exception) {
                    System.err.println(sAXParseException);
                    System.err.println(exception);
                    exception.printStackTrace();
                }
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

