/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.IDFilter;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements URIResolver {
    private Configuration config = null;

    public StandardURIResolver() {
        this(null);
    }

    public StandardURIResolver(Configuration configuration) {
        this.config = configuration;
    }

    public Source resolve(String string, String string2) throws XPathException {
        URI uRI;
        String string3 = string;
        String string4 = null;
        int n = string.indexOf(35);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        try {
            uRI = StandardURIResolver.makeAbsolute(string3, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string5 = StandardURIResolver.tryToExpand(string2);
            if (!string5.equals(string2)) {
                return this.resolve(string, string5);
            }
            throw new DynamicError("Invalid URI " + Err.wrap(string3) + " - base " + Err.wrap(string2), uRISyntaxException);
        }
        SAXSource sAXSource = new SAXSource();
        sAXSource.setInputSource(new InputSource(uRI.toString()));
        sAXSource.setSystemId(uRI.toString());
        if (string4 != null) {
            XMLReader xMLReader;
            IDFilter iDFilter = new IDFilter(string4);
            if (this.config == null) {
                try {
                    xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                }
                catch (Exception exception) {
                    throw new DynamicError(exception);
                }
            } else {
                xMLReader = this.config.getSourceParser();
            }
            iDFilter.setParent(xMLReader);
            sAXSource.setXMLReader(iDFilter);
        }
        return sAXSource;
    }

    public static URI makeAbsolute(String string, String string2) throws DynamicError, URISyntaxException {
        URI uRI;
        try {
            if (string2 == null) {
                uRI = new URI(string);
            } else {
                URI uRI2 = new URI(string2);
                uRI = string.length() == 0 ? uRI2 : uRI2.resolve(string);
                String string3 = uRI.toString();
                int n = string3.indexOf("%25");
                if (n >= 0) {
                    while (n >= 0) {
                        string3 = string3.substring(0, n + 1) + string3.substring(n + 3);
                        n = string3.indexOf("%25");
                    }
                    uRI = new URI(string3);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DynamicError("Invalid URI " + Err.wrap(string) + " - base " + Err.wrap(string2));
        }
        return uRI;
    }

    public static String tryToExpand(String string) {
        if (string == null) {
            string = "";
        }
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            try {
                string2 = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                return string;
            }
            if (!string2.endsWith("/") && !string.startsWith("/")) {
                string2 = string2 + '/';
            }
            try {
                URL uRL = new File(string2).toURL();
                URL uRL2 = new URL(uRL, string);
                return uRL2.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }
}

