/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.DocumentInfo;
import org.xml.sax.SAXException;

public class TransformerHandlerImpl
extends ReceivingContentHandler
implements TransformerHandler {
    Controller controller;
    Builder builder;
    Result result;
    String systemId;
    boolean started = false;

    protected TransformerHandlerImpl(Controller controller) {
        this.controller = controller;
        this.setPipelineConfiguration(controller.makePipelineConfiguration());
        this.builder = controller.makeBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        Receiver receiver = controller.makeStripper(this.builder);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            receiver = controller.getConfiguration().getAnnotationStripper(receiver);
        }
        this.setReceiver(receiver);
    }

    public void startDocument() throws SAXException {
        if (this.started) {
            throw new UnsupportedOperationException("The TransformerHandler is not serially reusable. The startDocument() method must be called once only.");
        }
        this.started = true;
        super.startDocument();
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        DocumentInfo documentInfo = (DocumentInfo)this.builder.getCurrentRoot();
        if (documentInfo == null) {
            throw new SAXException("No source document has been built");
        }
        documentInfo.getNamePool().allocateDocumentNumber(documentInfo);
        try {
            this.controller.transformDocument(documentInfo, this.result);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

