/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.trans.XPathException;

public class HTMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameLine = false;
    private boolean isInlineTag = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private static String[] inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del"};
    private static HTMLTagHashSet inlineTable = new HTMLTagHashSet(101);
    private static HTMLTagHashSet formattedTable;

    private static boolean isInline(String string) {
        return inlineTable.contains(string);
    }

    private static boolean isFormatted(String string) {
        return formattedTable.contains(string);
    }

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentSpaces = 3;
            }
        }
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        String string = this.getNamePool().getDisplayName(n);
        this.isInlineTag = HTMLIndenter.isInline(string);
        boolean bl = this.inFormattedTag = this.inFormattedTag || HTMLIndenter.isFormatted(string);
        if (!(this.isInlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        super.startElement(n, n2, n3, n4);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    public void endElement() throws XPathException {
        --this.level;
        String string = (String)((XMLEmitter)this.baseReceiver).elementStack.peek();
        boolean bl = HTMLIndenter.isInline(string);
        boolean bl2 = HTMLIndenter.isFormatted(string);
        if (!(bl || bl2 || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = bl;
            this.afterFormatted = bl2;
        }
        super.endElement();
        this.inFormattedTag = this.inFormattedTag && !bl2;
        this.sameLine = false;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inFormattedTag) {
            super.characters(charSequence, n, n2);
        } else {
            int n3 = 0;
            for (int i = 0; i < charSequence.length(); ++i) {
                if (charSequence.charAt(i) != '\n' && (i - n3 <= 120 || charSequence.charAt(i) != ' ')) continue;
                this.sameLine = false;
                super.characters(charSequence.subSequence(n3, i), n, n2);
                this.indent();
                for (n3 = i + 1; n3 < charSequence.length() && charSequence.charAt(n3) == ' '; ++n3) {
                }
            }
            if (n3 < charSequence.length()) {
                super.characters(charSequence.subSequence(n3, charSequence.length()), n, n2);
            }
        }
        this.afterInline = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        this.indent();
        super.comment(charSequence, n, n2);
    }

    private void indent() throws XPathException {
        int n = this.level * this.indentSpaces;
        while (n > this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        super.characters("\n", 0, 0);
        super.characters(this.indentChars.subSequence(0, n), 0, 0);
        this.sameLine = false;
    }

    static {
        for (int i = 0; i < inlineTags.length; ++i) {
            inlineTable.add(inlineTags[i]);
        }
        formattedTable = new HTMLTagHashSet(23);
        formattedTable.add("pre");
        formattedTable.add("script");
        formattedTable.add("style");
        formattedTable.add("textarea");
        formattedTable.add("xmp");
    }
}

