/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class NamespaceReducer
extends ProxyReceiver
implements NamespaceResolver {
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;
    private boolean[] disinheritStack = new boolean[50];
    private int[] pendingUndeclarations = null;

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        super.startElement(n, n2, n3, n4);
        if (this.depth > 0 && this.disinheritStack[this.depth - 1]) {
            this.pendingUndeclarations = new int[this.namespacesSize];
            System.arraycopy(this.namespaces, 0, this.pendingUndeclarations, 0, this.namespacesSize);
        } else {
            this.pendingUndeclarations = null;
        }
        this.countStack[this.depth] = 0;
        boolean bl = this.disinheritStack[this.depth] = (n4 & 0x80) != 0;
        if (++this.depth >= this.countStack.length) {
            int[] nArray = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.depth);
            boolean[] blArray = new boolean[this.depth * 2];
            System.arraycopy(this.disinheritStack, 0, blArray, 0, this.depth);
            this.countStack = nArray;
            this.disinheritStack = blArray;
        }
        if ((n4 & 0x40) == 0) {
            this.namespace(this.getNamePool().allocateNamespaceCode(n), 0);
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.isNeeded(n)) {
            this.addToStack(n);
            int n3 = this.depth - 1;
            this.countStack[n3] = this.countStack[n3] + 1;
            super.namespace(n, n2);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (n2 != -1 && (n4 & 0x200) != 0) {
            SimpleType simpleType = (SimpleType)this.getConfiguration().getSchemaType(n2);
            ValidationException validationException = simpleType.validateContent(charSequence, this, this.getConfiguration());
            if (validationException != null) {
                throw validationException;
            }
            n4 &= 0xFFFFFDFF;
        }
        super.attribute(n, n2, charSequence, n3, n4);
    }

    private boolean isNeeded(int n) {
        int n2;
        if (n == 65537) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            for (n2 = 0; n2 < this.pendingUndeclarations.length; ++n2) {
                if (n >> 16 != this.pendingUndeclarations[n2] >> 16) continue;
                this.pendingUndeclarations[n2] = -1;
            }
        }
        for (n2 = this.namespacesSize - 1; n2 >= 0; --n2) {
            if (this.namespaces[n2] == n) {
                return false;
            }
            if (this.namespaces[n2] >> 16 != n >> 16) continue;
            return true;
        }
        return n != 0;
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void startContent() throws XPathException {
        if (this.pendingUndeclarations != null) {
            for (int i = 0; i < this.pendingUndeclarations.length; ++i) {
                int n = this.pendingUndeclarations[i];
                if (n == -1) continue;
                this.namespace(n & 0xFFFF0000, 0);
            }
        }
        this.pendingUndeclarations = null;
        super.startContent();
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int n = this.countStack[this.depth];
        this.namespacesSize -= n;
        super.endElement();
    }

    protected short getURICode(short s) {
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] >> 16 != s) continue;
            return (short)(this.namespaces[i] & 0xFFFF);
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if ("".equals(string) && !bl) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s = namePool.getCodeForPrefix(string);
        short s2 = this.getURICode(s);
        if (s2 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s2);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.namespacesSize);
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String string = namePool.getPrefixFromNamespaceCode(this.namespaces[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }
}

