/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TEXTEmitter;
import net.sf.saxon.event.UncommittedEmitter;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class ResultWrapper {
    private ResultWrapper() {
    }

    public static Receiver getReceiver(Result result, PipelineConfiguration pipelineConfiguration, Properties properties) throws XPathException {
        if (result instanceof Emitter) {
            ((Emitter)result).setOutputProperties(properties);
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            Receiver receiver = (Receiver)result;
            receiver.setSystemId(result.getSystemId());
            receiver.setPipelineConfiguration(pipelineConfiguration);
            receiver.open();
            receiver.startDocument(0);
            return receiver;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            contentHandlerProxy.setPipelineConfiguration(pipelineConfiguration);
            return contentHandlerProxy;
        }
        if (result instanceof StreamResult) {
            Object object;
            Emitter emitter;
            Object object2;
            CharacterMapExpander characterMapExpander = null;
            String string = properties.getProperty("use-character-maps");
            if (string != null) {
                object2 = pipelineConfiguration.getController();
                if (object2 == null) {
                    throw new DynamicError("Cannot use character maps in an environment with no Controller");
                }
                characterMapExpander = ((Controller)object2).makeCharacterMapExpander(string);
            }
            if ((object2 = properties.getProperty("method")) == null) {
                emitter = new UncommittedEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                object = emitter;
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
            } else if ("html".equals(object2)) {
                emitter = new HTMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                object = emitter;
                if (!"no".equals(properties.getProperty("indent"))) {
                    HTMLIndenter hTMLIndenter = new HTMLIndenter();
                    hTMLIndenter.setUnderlyingReceiver((Receiver)object);
                    hTMLIndenter.setPipelineConfiguration(pipelineConfiguration);
                    hTMLIndenter.setOutputProperties(properties);
                    object = hTMLIndenter;
                }
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
            } else if ("xml".equals(object2)) {
                Object object3;
                emitter = new XMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                object = emitter;
                if ("yes".equals(properties.getProperty("indent"))) {
                    object3 = new XMLIndenter();
                    ((ProxyReceiver)object3).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object3).setPipelineConfiguration(pipelineConfiguration);
                    ((XMLIndenter)object3).setOutputProperties(properties);
                    object = object3;
                }
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
                if ((object3 = properties.getProperty("cdata-section-elements")) != null && ((String)object3).length() > 0) {
                    CDATAFilter cDATAFilter = new CDATAFilter();
                    cDATAFilter.setUnderlyingReceiver((Receiver)object);
                    cDATAFilter.setPipelineConfiguration(pipelineConfiguration);
                    cDATAFilter.setOutputProperties(properties);
                    object = cDATAFilter;
                }
            } else if ("xhtml".equals(object2)) {
                Object object4;
                emitter = new XHTMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                object = emitter;
                if ("yes".equals(properties.getProperty("indent"))) {
                    object4 = new HTMLIndenter();
                    ((ProxyReceiver)object4).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object4).setPipelineConfiguration(pipelineConfiguration);
                    ((HTMLIndenter)object4).setOutputProperties(properties);
                    object = object4;
                }
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
                if ((object4 = properties.getProperty("cdata-section-elements")) != null && ((String)object4).length() > 0) {
                    CDATAFilter cDATAFilter = new CDATAFilter();
                    cDATAFilter.setUnderlyingReceiver((Receiver)object);
                    cDATAFilter.setPipelineConfiguration(pipelineConfiguration);
                    cDATAFilter.setOutputProperties(properties);
                    object = cDATAFilter;
                }
            } else if ("text".equals(object2)) {
                emitter = new TEXTEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                object = emitter;
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    characterMapExpander.setUseNullMarkers(false);
                    object = characterMapExpander;
                }
            } else {
                int n = ((String)object2).indexOf(125);
                String string2 = ((String)object2).substring(n + 1);
                int n2 = string2.indexOf(58);
                string2 = string2.substring(n2 + 1);
                Receiver receiver = Emitter.makeEmitter(string2, pipelineConfiguration.getController());
                receiver.setPipelineConfiguration(pipelineConfiguration);
                object = receiver;
                if (receiver instanceof Emitter) {
                    emitter = (Emitter)receiver;
                } else {
                    return receiver;
                }
            }
            emitter.setOutputProperties(properties);
            StreamResult streamResult = (StreamResult)result;
            emitter.setStreamResult(streamResult);
            return object;
        }
        List list = pipelineConfiguration.getConfiguration().getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            Receiver receiver = externalObjectModel.getDocumentBuilder(result);
            if (receiver == null) continue;
            receiver.setSystemId(result.getSystemId());
            receiver.setPipelineConfiguration(pipelineConfiguration);
            return receiver;
        }
        throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
    }
}

