/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    PipelineConfiguration pipe;

    public Sender(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public void send(Source source, Receiver receiver) throws XPathException {
        this.send(source, receiver, false);
    }

    public void send(Source source, Receiver receiver, boolean bl) throws XPathException {
        int n;
        Configuration configuration = this.pipe.getConfiguration();
        receiver.setPipelineConfiguration(this.pipe);
        receiver.setSystemId(source.getSystemId());
        int n2 = configuration.getSchemaValidationMode();
        if (bl) {
            n2 |= 0x10000;
        }
        XMLReader xMLReader = null;
        if (source instanceof AugmentedSource) {
            n = ((AugmentedSource)source).getSchemaValidation();
            if (n != 0) {
                n2 = n;
            }
            xMLReader = ((AugmentedSource)source).getXMLReader();
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (source instanceof NodeInfo) {
            NodeInfo nodeInfo;
            int n3;
            n = n2 & 0xFF;
            if (n != 3) {
                receiver = configuration.getDocumentValidator(receiver, source.getSystemId(), configuration.getNamePool(), n);
            }
            if ((n3 = (nodeInfo = (NodeInfo)source).getNodeKind()) != 9 && n3 != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            this.sendDocumentInfo(nodeInfo, receiver, this.pipe.getConfiguration().getNamePool());
            return;
        }
        if (source instanceof PullSource) {
            this.sendPullSource((PullSource)source, receiver, n2);
            return;
        }
        if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, receiver, n2);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            String string = source.getSystemId();
            InputSource inputSource = new InputSource(string);
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setByteStream(streamSource.getInputStream());
            if (xMLReader == null) {
                xMLReader = this.pipe.getConfiguration().getSourceParser();
            }
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            sAXSource.setSystemId(source.getSystemId());
            this.sendSAXSource(sAXSource, receiver, n2);
            return;
        }
        if ((n2 & 0xFF) != 3) {
            receiver = configuration.getDocumentValidator(receiver, source.getSystemId(), configuration.getNamePool(), n2);
        }
        List list = this.pipe.getConfiguration().getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            boolean bl2 = externalObjectModel.sendSource(source, receiver, this.pipe);
            if (!bl2) continue;
            return;
        }
        if (source instanceof DOMSource) {
            throw new DynamicError("DOMSource cannot be processed: check that saxon8-dom.jar is on the classpath");
        }
        throw new DynamicError("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private void sendDocumentInfo(NodeInfo nodeInfo, Receiver object, NamePool namePool) throws XPathException {
        Object object2;
        if (nodeInfo.getNamePool() != namePool) {
            object2 = new NamePoolConverter(nodeInfo.getNamePool(), namePool);
            ((NamePoolConverter)object2).setUnderlyingReceiver((Receiver)object);
            object = object2;
        }
        object2 = new DocumentSender(nodeInfo);
        ((DocumentSender)object2).send((Receiver)object);
    }

    private void sendSAXSource(SAXSource sAXSource, Receiver receiver, int n) throws XPathException {
        Object object;
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            object = new SAXSource();
            ((SAXSource)object).setInputSource(sAXSource.getInputSource());
            ((SAXSource)object).setSystemId(sAXSource.getSystemId());
            xMLReader = this.pipe.getConfiguration().getSourceParser();
            ((SAXSource)object).setXMLReader(xMLReader);
            sAXSource = object;
        }
        if (xMLReader.getErrorHandler() == null) {
            xMLReader.setErrorHandler(new StandardErrorHandler(this.pipe.getErrorListener()));
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespaces' feature to true");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespace-prefixes' feature to false");
        }
        if ((n & 0xFF) != 3) {
            object = this.pipe.getConfiguration();
            receiver = ((Configuration)object).getDocumentValidator(receiver, sAXSource.getSystemId(), ((Configuration)object).getNamePool(), n);
        }
        object = new ReceivingContentHandler();
        ((ReceivingContentHandler)object).setReceiver(receiver);
        ((ReceivingContentHandler)object).setPipelineConfiguration(this.pipe);
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof XPathException) {
                throw (XPathException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new DynamicError(sAXException);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    private void sendPullSource(PullSource pullSource, Receiver receiver, int n) throws XPathException {
        if (n != 3 && n != 4) {
            throw new DynamicError("Validation is not currently supported with a PullSource");
        }
        receiver.open();
        PullProvider pullProvider = pullSource.getPullProvider();
        pullProvider.setPipelineConfiguration(this.pipe);
        receiver.setPipelineConfiguration(this.pipe);
        PullPushCopier pullPushCopier = new PullPushCopier(pullProvider, receiver);
        pullPushCopier.copy();
        receiver.close();
    }
}

