/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;

public class Stripper
extends ProxyReceiver {
    private boolean preserveAll;
    private boolean stripAll;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private Mode stripperMode;
    private Orphan element;
    private Controller controller;
    private XPathContext context;
    private NamePool namePool;
    private int xmlSpaceCode;
    public static final byte ALWAYS_PRESERVE = 1;
    public static final byte ALWAYS_STRIP = 2;
    public static final byte STRIP_DEFAULT = 0;
    public static final byte PRESERVE_PARENT = 4;
    public static final byte CANNOT_STRIP = 8;

    protected Stripper() {
    }

    public Stripper(Mode mode) {
        this.stripperMode = mode;
        this.preserveAll = mode == null;
        this.stripAll = false;
    }

    public Stripper getAnother() {
        Stripper stripper = new Stripper(this.stripperMode);
        stripper.setController(this.controller);
        stripper.stripAll = this.stripAll;
        stripper.preserveAll = this.preserveAll;
        return stripper;
    }

    public void setStripAll() {
        this.preserveAll = false;
        this.stripAll = true;
    }

    public boolean getStripAll() {
        return this.stripAll;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.context = controller.newXPathContext();
        this.namePool = controller.getNamePool();
        this.xmlSpaceCode = this.namePool.allocate("xml", "http://www.w3.org/XML/1998/namespace", "space");
        this.element = new Orphan(controller.getConfiguration());
        this.element.setNodeKind((short)1);
    }

    public byte isSpacePreserving(int n) {
        try {
            if (this.preserveAll) {
                return 1;
            }
            if (this.stripAll) {
                return 0;
            }
            this.element.setNameCode(n);
            Object object = this.stripperMode.getRule(this.element, this.context);
            if (object == null) {
                return 1;
            }
            return (Boolean)object != false ? (byte)1 : 0;
        }
        catch (XPathException xPathException) {
            return 1;
        }
    }

    public byte isSpacePreserving(NodeInfo nodeInfo) {
        try {
            if (this.preserveAll) {
                return 1;
            }
            if (this.stripAll) {
                return 0;
            }
            Object object = this.stripperMode.getRule(nodeInfo, this.context);
            if (object == null) {
                return 1;
            }
            return (Boolean)object != false ? (byte)1 : 0;
        }
        catch (XPathException xPathException) {
            return 1;
        }
    }

    public void open() throws XPathException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.open();
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        Object object;
        super.startElement(n, n2, n3, n4);
        byte by = this.stripStack[this.top];
        byte by2 = (byte)(by & 4);
        if (this.isSpacePreserving(n) == 1) {
            by2 = (byte)(by2 | 1);
        }
        if (by2 == 0 && n2 != -1 && ((object = this.controller.getConfiguration().getSchemaType(n2)).isSimpleType() || ((ComplexType)object).isSimpleContent())) {
            by2 = (byte)(by2 | 8);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            object = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, object, 0, this.top);
            this.stripStack = (byte[])object;
        }
        this.stripStack[this.top] = by2;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (n == this.xmlSpaceCode) {
            if (((Object)charSequence).toString().equals("preserve")) {
                int n5 = this.top;
                this.stripStack[n5] = (byte)(this.stripStack[n5] | 4);
            } else {
                int n6 = this.top;
                this.stripStack[n6] = (byte)(this.stripStack[n6] & 0xFFFFFFFB);
            }
        }
        super.attribute(n, n2, charSequence, n3, n4);
    }

    public void endElement() throws XPathException {
        super.endElement();
        --this.top;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (!(charSequence.length() <= 0 || this.stripStack[this.top] == 0 && Navigator.isWhite(charSequence) || (this.stripStack[this.top] & 0xA) != 0)) {
            super.characters(charSequence, n, n2);
        }
    }
}

