/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class AppendIterator
implements SequenceIterator {
    private SequenceIterator first;
    private Expression second;
    private XPathContext context;
    private SequenceIterator currentIterator;
    private int position = 0;

    public AppendIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) {
        this.first = sequenceIterator;
        this.second = expression;
        this.context = xPathContext;
        this.currentIterator = sequenceIterator;
    }

    public Item next() throws XPathException {
        Item item = this.currentIterator.next();
        if (item == null && this.currentIterator == this.first) {
            this.currentIterator = this.second.iterate(this.context);
            item = this.currentIterator.next();
        }
        this.position = item == null ? -1 : ++this.position;
        return item;
    }

    public Item current() {
        return this.currentIterator.current();
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new AppendIterator(this.first.getAnother(), this.second, this.context);
    }
}

