/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class AtomicSequenceConverter
extends UnaryExpression
implements MappingFunction {
    private AtomicType reqItemType;
    private int requiredPrimitiveType;

    public AtomicSequenceConverter(Expression expression, AtomicType atomicType) {
        super(expression);
        this.reqItemType = atomicType;
        this.requiredPrimitiveType = atomicType.getPrimitiveType();
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof Value) {
            return new SequenceExtent(this.iterate(null));
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        if (Type.isSubType(this.operand.getItemType(), this.reqItemType)) {
            return this.operand;
        }
        if (!Cardinality.allowsMany(this.operand.getCardinality())) {
            CastExpression castExpression = new CastExpression(this.operand, this.reqItemType, (this.operand.getCardinality() & 0x2000) != 0);
            ExpressionTool.copyLocationInfo(this, castExpression);
            castExpression.setParentExpression(this.getParentExpression());
            return castExpression;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        return ((AtomicValue)item).convert(this.requiredPrimitiveType, xPathContext);
    }

    public Object map(Item item, XPathContext xPathContext) throws XPathException {
        return ((AtomicValue)item).convert(this.requiredPrimitiveType, xPathContext);
    }

    public ItemType getItemType() {
        return this.reqItemType;
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredPrimitiveType == ((AtomicSequenceConverter)object).requiredPrimitiveType;
    }

    protected String displayOperator(NamePool namePool) {
        return "convert items to " + this.reqItemType.toString(namePool);
    }
}

