/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AppendIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.ObjectValue;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private RoleLocator role;

    public CardinalityChecker(Expression expression, int n, RoleLocator roleLocator) {
        super(expression);
        this.requiredCardinality = n;
        this.role = roleLocator;
        this.computeStaticProperties();
        this.adoptChildExpression(expression);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        if (this.requiredCardinality == 57344) {
            return this.operand;
        }
        if (Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    public void setErrorCode(String string) {
        this.role.setErrorCode(string);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        if (!Cardinality.allowsZero(this.requiredCardinality)) {
            ObjectValue objectValue = new ObjectValue(this);
            sequenceIterator = new AppendIterator(sequenceIterator, objectValue, xPathContext);
        }
        CardinalityCheckingFunction cardinalityCheckingFunction = new CardinalityCheckingFunction();
        cardinalityCheckingFunction.iterator = sequenceIterator;
        return new MappingIterator(sequenceIterator, cardinalityCheckingFunction, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        Item item2 = null;
        while ((item = sequenceIterator.next()) != null) {
            if (item2 != null) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
                return null;
            }
            item2 = item;
        }
        if (item2 == null && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            return null;
        }
        return item2;
    }

    public ItemType getItemType() {
        return this.operand.getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredCardinality == ((CardinalityChecker)object).requiredCardinality;
    }

    public String displayOperator(NamePool namePool) {
        return "checkCardinality (" + Cardinality.toString(this.requiredCardinality) + ')';
    }

    private class CardinalityCheckingFunction
    implements MappingFunction {
        public SequenceIterator iterator;

        private CardinalityCheckingFunction() {
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            int n = this.iterator.position();
            if (item instanceof ObjectValue && ((ObjectValue)item).getObject() == CardinalityChecker.this) {
                if (n == 1) {
                    CardinalityChecker.this.typeError("An empty sequence is not allowed as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), xPathContext);
                }
                return null;
            }
            if (n == 2 && !Cardinality.allowsMany(CardinalityChecker.this.requiredCardinality)) {
                CardinalityChecker.this.typeError("A sequence of more than one item is not allowed as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), xPathContext);
                return null;
            }
            return item;
        }
    }
}

