/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class ErrorExpression
extends ComputedExpression {
    private XPathException exception;

    public ErrorExpression(XPathException xPathException) {
        this.exception = xPathException;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        DynamicError dynamicError = new DynamicError(this.exception.getMessage());
        dynamicError.setLocator(ExpressionTool.getLocator(this));
        dynamicError.setErrorCode(this.exception.getErrorCodeLocalPart());
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        this.evaluateItem(xPathContext);
        return null;
    }

    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int computeCardinality() {
        return 57344;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "**ERROR** (" + this.exception.getMessage() + ')');
    }
}

