/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Err;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.AnyChildNodePattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.IDPattern;
import net.sf.saxon.pattern.KeyPattern;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.sort.Reverser;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ExpressionParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected Stack rangeVariables = null;
    protected boolean scanOnly = false;
    protected int language = 0;
    protected static final int XPATH = 0;
    protected static final int XSLT_PATTERN = 1;
    protected static final int SEQUENCE_TYPE = 2;
    protected static final int XQUERY = 3;

    public Tokenizer getTokenizer() {
        return this.t;
    }

    protected void nextToken() throws StaticError {
        try {
            this.t.next();
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
    }

    protected void expect(int n) throws StaticError {
        if (this.t.currentToken != n) {
            this.grumble("expected \"" + Token.tokens[n] + "\", found " + this.currentTokenDisplay());
        }
    }

    protected void grumble(String string) throws StaticError {
        this.grumble(string, this.language == 1 ? "XTSE0340" : "XPST0003");
    }

    protected void grumble(String string, String string2) throws StaticError {
        if (string2 == null) {
            string2 = "XPST0003";
        }
        String string3 = this.t.recentText();
        int n = this.t.getLineNumber();
        int n2 = this.t.getColumnNumber();
        String string4 = n == 1 ? "" : "on line " + n + ' ';
        String string5 = "at char " + n2 + ' ';
        String string6 = this.getLanguage() + " syntax error " + string5 + string4 + (string.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(string3) + ":\n    ";
        StaticError staticError = new StaticError(string6 + string);
        staticError.setErrorCode(string2);
        throw staticError;
    }

    protected void warning(String string) throws StaticError {
        String string2 = this.t.recentText();
        int n = this.t.getLineNumber();
        String string3 = n == 1 ? "" : "on line " + n + ' ';
        String string4 = "Warning " + string3 + (string.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(string2) + ":\n    ";
        this.env.issueWarning(string4 + string, null);
    }

    protected String getLanguage() {
        switch (this.language) {
            case 0: {
                return "XPath";
            }
            case 1: {
                return "XSLT Pattern";
            }
            case 2: {
                return "SequenceType";
            }
            case 3: {
                return "XQuery";
            }
        }
        return "XPath";
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 101) {
            return "name \"" + this.t.currentTokenValue + '\"';
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return '\"' + Token.tokens[this.t.currentToken] + '\"';
    }

    public Expression parse(String string, int n, int n2, int n3, StaticContext staticContext) throws StaticError {
        this.env = staticContext;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, n, -1, n3);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        Expression expression = this.parseExpression();
        if (this.t.currentToken != n2) {
            if (this.t.currentToken == 0 && n2 == 115) {
                this.grumble("Missing curly brace after expression in attribute value template", "XTSE0350");
            } else {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
            }
        }
        return expression;
    }

    public Pattern parsePattern(String string, StaticContext staticContext) throws StaticError {
        this.env = staticContext;
        this.language = 1;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, 0, -1, 1);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        Pattern pattern = this.parseUnionPattern();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of pattern");
        }
        return pattern;
    }

    public SequenceType parseSequenceType(String string, StaticContext staticContext) throws StaticError {
        this.env = staticContext;
        this.language = 2;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, 0, -1, 1);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        SequenceType sequenceType = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return sequenceType;
    }

    protected Expression parseExpression() throws StaticError {
        Expression expression = this.parseExprSingle();
        while (this.t.currentToken == 7) {
            this.nextToken();
            expression = Block.makeBlock(expression, this.parseExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseExprSingle() throws StaticError {
        switch (this.t.currentToken) {
            case 111: 
            case 116: {
                return this.parseForExpression();
            }
            case 31: 
            case 32: {
                return this.parseQuantifiedExpression();
            }
            case 36: {
                return this.parseIfExpression();
            }
            case 58: {
                return this.parseTypeswitchExpression();
            }
            case 81: 
            case 82: 
            case 83: {
                return this.parseValidateExpression();
            }
            case 118: {
                return this.parseExtensionExpression();
            }
        }
        return this.parseOrExpression();
    }

    protected Expression parseTypeswitchExpression() throws StaticError {
        this.grumble("typeswitch is not allowed in XPath");
        return null;
    }

    protected Expression parseValidateExpression() throws StaticError {
        this.grumble("validate{} expressions are not allowed in XPath");
        return null;
    }

    protected Expression parseExtensionExpression() throws StaticError {
        this.grumble("extension expressions (#...#) are not allowed in XPath");
        return null;
    }

    private Expression parseOrExpression() throws StaticError {
        Expression expression = this.parseAndExpression();
        while (this.t.currentToken == 9) {
            this.nextToken();
            expression = new BooleanExpression(expression, 9, this.parseAndExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseAndExpression() throws StaticError {
        Expression expression = this.parseComparisonExpression();
        while (this.t.currentToken == 10) {
            this.nextToken();
            expression = new BooleanExpression(expression, 10, this.parseComparisonExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseForExpression() throws StaticError {
        if (this.t.currentToken == 116) {
            this.grumble("'let' is not supported in XPath");
        }
        return this.parseMappingExpression();
    }

    private Expression parseQuantifiedExpression() throws StaticError {
        return this.parseMappingExpression();
    }

    protected Expression parseMappingExpression() throws StaticError {
        int n;
        Serializable serializable;
        Object object;
        Object object2;
        int n2 = this.t.currentTokenStartOffset;
        int n3 = this.t.currentToken;
        ArrayList<ForClause> arrayList = new ArrayList<ForClause>(3);
        do {
            object2 = new ForClause();
            ((ForClause)object2).offset = n2;
            ((ForClause)object2).requiredType = SequenceType.SINGLE_ITEM;
            arrayList.add((ForClause)object2);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            object = new RangeVariableDeclaration();
            ((RangeVariableDeclaration)object).setNameCode(this.makeNameCode(string, false));
            ((RangeVariableDeclaration)object).setRequiredType(SequenceType.SINGLE_ITEM);
            ((RangeVariableDeclaration)object).setVariableName(string);
            ((ForClause)object2).rangeVariable = object;
            this.nextToken();
            if (this.isKeyword("as") && "XQuery".equals(this.getLanguage())) {
                this.nextToken();
                serializable = this.parseSequenceType();
                ((ForClause)object2).requiredType = serializable;
                ((RangeVariableDeclaration)object).setRequiredType((SequenceType)serializable);
                if (((SequenceType)serializable).getCardinality() != 16384) {
                    this.grumble("Cardinality of range variable must be exactly one");
                }
            }
            ((ForClause)object2).positionVariable = null;
            this.expect(30);
            this.nextToken();
            ((ForClause)object2).sequence = this.parseExprSingle();
            this.declareRangeVariable(((ForClause)object2).rangeVariable);
        } while (this.t.currentToken == 7);
        if (n3 == 111) {
            this.expect(25);
        } else {
            this.expect(33);
        }
        this.nextToken();
        object2 = this.parseExprSingle();
        for (n = arrayList.size() - 1; n >= 0; --n) {
            object = (ForClause)arrayList.get(n);
            if (n3 == 111) {
                serializable = new ForExpression();
            } else {
                serializable = new QuantifiedExpression();
                ((QuantifiedExpression)serializable).setOperator(n3);
            }
            this.setLocation((Expression)((Object)serializable), n2);
            ((Assignation)serializable).setVariableDeclaration(((ForClause)object).rangeVariable);
            ((Assignation)serializable).setSequence(((ForClause)object).sequence);
            if (((ForClause)object).requiredType == SequenceType.SINGLE_ITEM) {
                SequenceType sequenceType = SequenceType.makeSequenceType(((ForClause)object).sequence.getItemType(), 16384);
                ((ForClause)object).rangeVariable.setRequiredType(sequenceType);
            } else {
                ((ForClause)object).rangeVariable.setRequiredType(((ForClause)object).requiredType);
            }
            ((Assignation)serializable).setAction((Expression)object2);
            object2 = serializable;
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            object = arrayList.get(n);
            this.undeclareRangeVariable();
        }
        return object2;
    }

    private Expression parseIfExpression() throws StaticError {
        int n = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression expression = this.parseExpression();
        this.expect(104);
        this.nextToken();
        int n2 = this.t.currentTokenStartOffset;
        this.expect(26);
        this.nextToken();
        Expression expression2 = this.makeTracer(n2, this.parseExpression(), 2016, -1);
        int n3 = this.t.currentTokenStartOffset;
        this.expect(27);
        this.nextToken();
        Expression expression3 = this.makeTracer(n3, this.parseExprSingle(), 2017, -1);
        IfExpression ifExpression = new IfExpression(expression, expression2, expression3);
        this.setLocation(ifExpression, n);
        return this.makeTracer(n, ifExpression, 2015, -1);
    }

    private Expression parseInstanceOfExpression() throws StaticError {
        Expression expression = this.parseTreatExpression();
        if (this.t.currentToken == 41) {
            this.nextToken();
            expression = new InstanceOfExpression(expression, this.parseSequenceType());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseTreatExpression() throws StaticError {
        Expression expression = this.parseCastableExpression();
        if (this.t.currentToken == 43) {
            this.nextToken();
            SequenceType sequenceType = this.parseSequenceType();
            expression = TreatExpression.make(expression, sequenceType);
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseCastableExpression() throws StaticError {
        Expression expression = this.parseCastExpression();
        if (this.t.currentToken == 51) {
            boolean bl;
            this.nextToken();
            this.expect(101);
            AtomicType atomicType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
            boolean bl2 = bl = this.t.currentToken == 113;
            if (bl) {
                this.nextToken();
            }
            expression = new CastableExpression(expression, atomicType, bl);
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseCastExpression() throws StaticError {
        Expression expression = this.parseUnaryExpression();
        if (this.t.currentToken == 42) {
            boolean bl;
            this.nextToken();
            this.expect(101);
            AtomicType atomicType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
            boolean bl2 = bl = this.t.currentToken == 113;
            if (bl) {
                this.nextToken();
            }
            if (((AtomicType)(expression = new CastExpression(expression, atomicType, bl)).getItemType()).isNamespaceSensitive()) {
                try {
                    return ((CastExpression)expression).doQNameCast(this.env);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                }
            }
            this.setLocation(expression);
        }
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AtomicType getAtomicType(String string) throws StaticError {
        if (this.scanOnly) {
            return Type.ANY_ATOMIC_TYPE;
        }
        try {
            block21: {
                String string2;
                short s;
                String[] stringArray = Name.getQNameParts(string);
                if ("".equals(stringArray[0])) {
                    s = this.env.getDefaultElementNamespace();
                    string2 = this.env.getNamePool().getURIFromURICode(s);
                } else {
                    try {
                        string2 = this.env.getURIForPrefix(stringArray[0]);
                    }
                    catch (XPathException xPathException) {
                        this.grumble(xPathException.getMessage());
                        string2 = "";
                    }
                }
                s = (short)(string2.equals("http://www.w3.org/2001/XMLSchema") ? 1 : 0);
                if (s == 0 && NamespaceConstant.isXDTNamespace(string2)) {
                    string2 = "http://www.w3.org/2005/04/xpath-datatypes";
                    s = 1;
                }
                if (s != 0) {
                    ItemType itemType = Type.getBuiltInItemType(string2, stringArray[1]);
                    if (itemType == null) {
                        this.grumble("Unknown atomic type " + string, "XPST0051");
                    }
                    if (itemType instanceof BuiltInAtomicType) {
                        if (this.env.isAllowedBuiltInType((BuiltInAtomicType)itemType)) return (AtomicType)itemType;
                        this.warning("The type " + string + " is not recognized by a Basic XSLT Processor. " + "Saxon permits it for the time being.");
                        return (AtomicType)itemType;
                    }
                    this.grumble("The type " + string + " is not atomic");
                } else {
                    if (string2.equals("http://saxon.sf.net/java-type")) {
                        Class clazz = null;
                        try {
                            String string3 = stringArray[1].replace('-', '$');
                            clazz = this.env.getConfiguration().getClass(string3, false, null);
                            return new ExternalObjectType(clazz);
                        }
                        catch (XPathException xPathException) {
                            this.grumble("Unknown Java class " + stringArray[1]);
                        }
                        return new ExternalObjectType(clazz);
                    }
                    if (this.env.isImportedSchema(string2)) {
                        int n = this.env.getNamePool().allocate(stringArray[0], string2, stringArray[1]);
                        SchemaType schemaType = this.env.getConfiguration().getSchemaType(n & 0xFFFFF);
                        if (schemaType == null) {
                            this.grumble("Unknown atomic type " + string);
                            break block21;
                        } else {
                            if (schemaType instanceof AtomicType) {
                                return (AtomicType)schemaType;
                            }
                            if (schemaType.isComplexType()) {
                                this.grumble("Type (" + string + ") is a complex type");
                                return null;
                            }
                            this.grumble("Type (" + string + ") is a list or union type");
                            return null;
                        }
                    }
                    if ("".equals(string2)) {
                        this.grumble("There is no imported schema for the null namespace");
                        return null;
                    }
                    this.grumble("There is no imported schema for namespace " + string2);
                    return null;
                }
            }
            this.grumble("Unknown atomic type " + string);
            return null;
        }
        catch (QNameException qNameException) {
            this.grumble(qNameException.getMessage());
        }
        return null;
    }

    private Expression parseComparisonExpression() throws StaticError {
        Expression expression = this.parseRangeExpression();
        switch (this.t.currentToken) {
            case 20: 
            case 37: 
            case 38: {
                int n = this.t.currentToken;
                this.nextToken();
                expression = new IdentityComparison(expression, n, this.parseRangeExpression());
                this.setLocation(expression);
                return expression;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                int n = this.t.currentToken;
                this.nextToken();
                expression = this.env.getConfiguration().getOptimizer().makeGeneralComparison(expression, n, this.parseRangeExpression(), this.env.isInBackwardsCompatibleMode());
                this.setLocation(expression);
                return expression;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                int n = this.t.currentToken;
                this.nextToken();
                expression = new ValueComparison(expression, n, this.parseRangeExpression());
                this.setLocation(expression);
                return expression;
            }
        }
        return expression;
    }

    private Expression parseRangeExpression() throws StaticError {
        Expression expression = this.parseAdditiveExpression();
        if (this.t.currentToken == 29) {
            this.nextToken();
            expression = new RangeExpression(expression, 29, this.parseAdditiveExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    protected SequenceType parseSequenceType() throws StaticError {
        int n;
        ItemType itemType;
        if (this.t.currentToken == 101) {
            itemType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
        } else if (this.t.currentToken == 110) {
            if (this.t.currentTokenValue == "item") {
                this.nextToken();
                this.expect(104);
                this.nextToken();
                itemType = AnyItemType.getInstance();
            } else {
                if (this.t.currentTokenValue == "void") {
                    this.nextToken();
                    this.expect(104);
                    this.nextToken();
                    return SequenceType.makeSequenceType(NoNodeTest.getInstance(), 8192);
                }
                itemType = this.parseKindTest();
            }
        } else {
            if (this.t.currentToken == 34 && "empty".equals(this.t.currentTokenValue)) {
                this.nextToken();
                this.expect(104);
                this.nextToken();
                return SequenceType.makeSequenceType(NoNodeTest.getInstance(), 8192);
            }
            this.grumble("Expected type name in SequenceType, found " + Token.tokens[this.t.currentToken]);
            return null;
        }
        switch (this.t.currentToken) {
            case 17: 
            case 107: {
                n = 57344;
                this.nextToken();
                break;
            }
            case 15: {
                n = 49152;
                this.nextToken();
                break;
            }
            case 113: {
                n = 24576;
                this.nextToken();
                break;
            }
            default: {
                n = 16384;
            }
        }
        return SequenceType.makeSequenceType(itemType, n);
    }

    private Expression parseAdditiveExpression() throws StaticError {
        Expression expression = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 15 || this.t.currentToken == 16) {
            int n = this.t.currentToken;
            this.nextToken();
            expression = new ArithmeticExpression(expression, n, this.parseMultiplicativeExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseMultiplicativeExpression() throws StaticError {
        Expression expression = this.parseUnionExpression();
        while (this.t.currentToken == 17 || this.t.currentToken == 18 || this.t.currentToken == 50 || this.t.currentToken == 19) {
            int n = this.t.currentToken;
            this.nextToken();
            expression = new ArithmeticExpression(expression, n, this.parseUnionExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseUnaryExpression() throws StaticError {
        Expression expression;
        switch (this.t.currentToken) {
            case 16: {
                this.nextToken();
                expression = new ArithmeticExpression(new IntegerValue(0L), 199, this.parseUnaryExpression());
                break;
            }
            case 15: {
                this.nextToken();
                expression = new ArithmeticExpression(new IntegerValue(0L), 15, this.parseUnaryExpression());
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                expression = this.parseValidateExpression();
                break;
            }
            case 118: {
                expression = this.parseExtensionExpression();
                break;
            }
            default: {
                expression = this.parsePathExpression();
            }
        }
        this.setLocation(expression);
        return expression;
    }

    private Expression parseUnionExpression() throws StaticError {
        Expression expression = this.parseIntersectExpression();
        while (this.t.currentToken == 1) {
            this.nextToken();
            expression = new VennExpression(expression, 1, this.parseIntersectExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseIntersectExpression() throws StaticError {
        Expression expression = this.parseInstanceOfExpression();
        while (this.t.currentToken == 23 || this.t.currentToken == 24) {
            int n = this.t.currentToken;
            this.nextToken();
            expression = new VennExpression(expression, n, this.parseInstanceOfExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 34: 
            case 35: 
            case 101: 
            case 102: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    private Expression parsePathExpression() throws StaticError {
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                RootExpression rootExpression = new RootExpression();
                this.setLocation(rootExpression);
                if (this.atStartOfRelativePath()) {
                    Expression expression = this.parseRemainingPath(rootExpression);
                    this.setLocation(expression);
                    return expression;
                }
                return rootExpression;
            }
            case 8: {
                this.nextToken();
                RootExpression rootExpression = new RootExpression();
                this.setLocation(rootExpression);
                AxisExpression axisExpression = new AxisExpression(5, null);
                this.setLocation(axisExpression);
                Expression expression = this.parseRemainingPath(new PathExpression(rootExpression, axisExpression));
                this.setLocation(expression);
                return expression;
            }
        }
        return this.parseRelativePath();
    }

    protected Expression parseRelativePath() throws StaticError {
        Expression expression = this.parseStepExpression();
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int n = this.t.currentToken;
            this.nextToken();
            Expression expression2 = this.parseStepExpression();
            expression = n == 2 ? new PathExpression(expression, expression2) : new PathExpression(expression, new PathExpression(new AxisExpression(5, null), expression2));
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseRemainingPath(Expression expression) throws StaticError {
        Expression expression2 = expression;
        int n = 2;
        while (true) {
            Expression expression3 = this.parseStepExpression();
            expression2 = n == 2 ? new PathExpression(expression2, expression3) : new PathExpression(expression2, new PathExpression(new AxisExpression(5, null), expression3));
            this.setLocation(expression2);
            n = this.t.currentToken;
            if (n != 2 && n != 8) break;
            this.nextToken();
        }
        return expression2;
    }

    protected Expression parseStepExpression() throws StaticError {
        boolean bl;
        Expression expression = this.parseBasicStep();
        boolean bl2 = bl = expression instanceof AxisExpression && Axis.isReverse[((AxisExpression)expression).getAxis()];
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression expression2 = this.parseExpression();
            this.expect(103);
            this.nextToken();
            expression = new FilterExpression(expression, expression2, this.env);
            this.setLocation(expression);
        }
        if (bl) {
            return new Reverser(expression);
        }
        return expression;
    }

    private Expression parseBasicStep() throws StaticError {
        switch (this.t.currentToken) {
            case 21: {
                VariableReference variableReference;
                this.nextToken();
                this.expect(101);
                String string = this.t.currentTokenValue;
                this.nextToken();
                if (this.scanOnly) {
                    return new ContextItemExpression();
                }
                int n = this.makeNameCode(string, false) & 0xFFFFF;
                VariableDeclaration variableDeclaration = this.findRangeVariable(n);
                if (variableDeclaration != null) {
                    variableReference = new VariableReference(variableDeclaration);
                } else {
                    try {
                        variableReference = new VariableReference(this.env.bindVariable(n));
                    }
                    catch (XPathException xPathException) {
                        this.grumble("Variable $" + string + " has not been declared");
                        variableReference = null;
                    }
                }
                this.setLocation(variableReference);
                return variableReference;
            }
            case 5: {
                this.nextToken();
                if (this.t.currentToken == 104) {
                    this.nextToken();
                    return EmptySequence.getInstance();
                }
                Expression expression = this.parseExpression();
                this.expect(104);
                this.nextToken();
                return expression;
            }
            case 102: {
                StringValue stringValue = this.makeStringLiteral(this.t.currentTokenValue);
                this.nextToken();
                return stringValue;
            }
            case 109: {
                NumericValue numericValue = NumericValue.parseNumber(this.t.currentTokenValue);
                if (numericValue.isNaN()) {
                    this.grumble("Invalid numeric literal " + Err.wrap(this.t.currentTokenValue, 4));
                }
                this.nextToken();
                return numericValue;
            }
            case 34: {
                return this.parseFunctionCall();
            }
            case 105: {
                this.nextToken();
                ContextItemExpression contextItemExpression = new ContextItemExpression();
                this.setLocation(contextItemExpression);
                return contextItemExpression;
            }
            case 106: {
                this.nextToken();
                ParentNodeExpression parentNodeExpression = new ParentNodeExpression();
                this.setLocation(parentNodeExpression);
                return parentNodeExpression;
            }
            case 101: 
            case 107: 
            case 108: 
            case 110: 
            case 112: {
                byte by = 3;
                if (this.t.currentToken == 110 && this.t.currentTokenValue == "attribute") {
                    by = 2;
                }
                AxisExpression axisExpression = new AxisExpression(by, this.parseNodeTest((short)1));
                this.setLocation(axisExpression);
                return axisExpression;
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 101: 
                    case 107: 
                    case 108: 
                    case 110: 
                    case 112: {
                        AxisExpression axisExpression = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation(axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 35: {
                byte by;
                try {
                    by = Axis.getAxisNumber(this.t.currentTokenValue);
                }
                catch (StaticError staticError) {
                    this.grumble(staticError.getMessage());
                    by = 3;
                }
                if (by == 8 && this.language == 3) {
                    this.grumble("The namespace axis is not available in XQuery");
                }
                short s = Axis.principalNodeType[by];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 101: 
                    case 107: 
                    case 108: 
                    case 110: 
                    case 112: {
                        AxisExpression axisExpression = new AxisExpression(by, this.parseNodeTest(s));
                        this.setLocation(axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 117: {
                return this.parseConstructor();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
            }
        }
        return null;
    }

    protected StringValue makeStringLiteral(String string) throws StaticError {
        return new StringValue(string);
    }

    protected Expression parseConstructor() throws StaticError {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return null;
    }

    protected NodeTest parseNodeTest(short s) throws StaticError {
        int n = this.t.currentToken;
        String string = this.t.currentTokenValue;
        switch (n) {
            case 101: {
                this.nextToken();
                return this.makeNameTest(s, string, s == 1);
            }
            case 108: {
                this.nextToken();
                return this.makeNamespaceTest(s, string);
            }
            case 112: {
                this.nextToken();
                string = this.t.currentTokenValue;
                this.expect(101);
                this.nextToken();
                return this.makeLocalNameTest(s, string);
            }
            case 107: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest(s);
            }
            case 110: {
                return this.parseKindTest();
            }
        }
        this.grumble("Unrecognized node test");
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private NodeTest parseKindTest() throws StaticError {
        var1_1 = this.t.currentTokenValue;
        var2_2 = var1_1.startsWith("schema-");
        var3_3 = ExpressionParser.getSystemType(var1_1);
        var4_4 = -1;
        var6_5 = false;
        this.nextToken();
        if (this.t.currentToken == 104) {
            if (var2_2) {
                this.grumble("schema-element() and schema-attribute() require a name to be supplied");
                return null;
            }
            var6_5 = true;
            this.nextToken();
        }
        switch (var3_3) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (var6_5) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("No arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (var6_5) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("No arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (var6_5) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("No arguments are allowed in comment()");
                return null;
            }
            case 13: {
                this.grumble("No node test is defined for namespace nodes");
                return null;
            }
            case 9: {
                if (var6_5) {
                    return NodeKindTest.DOCUMENT;
                }
                try {
                    var7_6 = ExpressionParser.getSystemType(this.t.currentTokenValue);
                }
                catch (XPathException var8_12) {
                    var7_6 = 15;
                }
                if (var7_6 != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                var8_13 = this.parseKindTest();
                this.expect(104);
                this.nextToken();
                return new DocumentNodeTest(var8_13);
            }
            case 7: {
                if (var6_5) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 102) ** GOTO lbl66
                try {
                    var7_7 = Name.getQNameParts(this.t.currentTokenValue);
                    if (!"".equals(var7_7[0])) ** GOTO lbl59
                    var4_4 = this.makeNameCode(var7_7[1], false);
                    ** GOTO lbl78
lbl59:
                    // 1 sources

                    this.warning("No processing instruction name will ever contain a colon");
                    var4_4 = this.env.getNamePool().allocate("prefix", "http://saxon.sf.net/ nonexistent namespace", "___invalid-name");
                }
                catch (QNameException var7_8) {
                    this.warning("No processing instruction will ever be named '" + this.t.currentTokenValue + "'. " + var7_8.getMessage());
                    var4_4 = this.env.getNamePool().allocate("prefix", "http://saxon.sf.net/ nonexistent namespace", "___invalid-name");
                }
                ** GOTO lbl78
lbl66:
                // 1 sources

                if (this.t.currentToken != 101) ** GOTO lbl77
                try {
                    var7_9 = Name.getQNameParts(this.t.currentTokenValue);
                    if (!"".equals(var7_9[0])) ** GOTO lbl72
                    var4_4 = this.makeNameCode(var7_9[1], false);
                    ** GOTO lbl78
lbl72:
                    // 1 sources

                    this.grumble("Processing instruction name must not contain a colon");
                }
                catch (QNameException var7_10) {
                    this.grumble("Invalid processing instruction name. " + var7_10.getMessage());
                }
                ** GOTO lbl78
lbl77:
                // 1 sources

                this.grumble("Processing instruction name must be a QName or a string literal");
lbl78:
                // 7 sources

                this.nextToken();
                this.expect(104);
                this.nextToken();
                return new NameTest(7, var4_4, this.env.getNamePool());
            }
            case 1: 
            case 2: {
                var7_11 = "";
                if (var6_5) {
                    return NodeKindTest.makeNodeKindTest(var3_3);
                }
                if (this.t.currentToken == 107 || this.t.currentToken == 17) {
                    if (var2_2) {
                        this.grumble("schema-element() and schema-attribute() must specify an actual name, not '*'");
                        return null;
                    }
                    var4_4 = -1;
                } else if (this.t.currentToken == 101) {
                    var7_11 = this.t.currentTokenValue;
                    var4_4 = this.makeNameCode(this.t.currentTokenValue, true);
                } else {
                    this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                var8_14 = null;
                if (var4_4 != -1) {
                    var8_14 = this.env.getNamePool().getURI(var4_4);
                }
                this.nextToken();
                if (this.t.currentToken != 2) ** GOTO lbl104
                this.grumble("Schema context paths have been dropped from the language specification");
                ** GOTO lbl183
lbl104:
                // 1 sources

                if (this.t.currentToken != 104) ** GOTO lbl141
                this.nextToken();
                if (var4_4 == -1) {
                    return NodeKindTest.makeNodeKindTest(var3_3);
                }
                var9_15 /* !! */  = null;
                var10_17 = null;
                if (var3_3 != 2) ** GOTO lbl123
                if (var2_2) {
                    var11_19 = this.env.getConfiguration().getAttributeDeclaration(var4_4 & 1048575);
                    if (!this.env.isImportedSchema(var8_14)) {
                        this.grumble("No schema has been imported for namespace '" + var8_14 + '\'');
                    }
                    if (var11_19 == null) {
                        this.grumble("There is no declaration for attribute @" + var7_11 + " in an imported schema");
                    } else {
                        var10_17 = var11_19.getType();
                        var9_15 /* !! */  = new NameTest(2, var4_4, this.env.getNamePool());
                    }
                } else {
                    var9_15 /* !! */  = new NameTest(2, var4_4, this.env.getNamePool());
                    return var9_15 /* !! */ ;
lbl123:
                    // 1 sources

                    if (var2_2) {
                        var11_19 = this.env.getConfiguration().getElementDeclaration(var4_4 & 1048575);
                        if (!this.env.isImportedSchema(var8_14)) {
                            this.grumble("No schema has been imported for namespace '" + var8_14 + '\'');
                        }
                        if (var11_19 == null) {
                            this.grumble("There is no declaration for element <" + var7_11 + "> in an imported schema");
                        } else {
                            var10_17 = var11_19.getType();
                            var9_15 /* !! */  = this.env.getConfiguration().makeSubstitutionGroupTest((SchemaDeclaration)var11_19);
                        }
                    } else {
                        var9_15 /* !! */  = new NameTest(1, var4_4, this.env.getNamePool());
                        return var9_15 /* !! */ ;
                    }
                }
                var11_19 = null;
                if (var10_17 != null) {
                    var11_19 = new ContentTypeTest(var3_3, var10_17, this.env.getConfiguration());
                }
                if (var11_19 == null) {
                    return var9_15 /* !! */ ;
                }
                return new CombinedNodeTest(var9_15 /* !! */ , 23, (NodeTest)var11_19);
lbl141:
                // 1 sources

                if (this.t.currentToken == 7) {
                    if (var2_2) {
                        this.grumble("schema-element() and schema-attribute() must have one argument only");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 107) {
                        this.grumble("'*' is no longer permitted as the second argument of element() and attribute()");
                        return null;
                    }
                    if (this.t.currentToken == 101) {
                        var5_21 = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                        var11_20 = this.env.getNamePool().getURI(var5_21);
                        var12_22 = this.env.getNamePool().getLocalName(var5_21);
                        if (var11_20.equals("http://www.w3.org/2001/XMLSchema") || NamespaceConstant.isXDTNamespace(var11_20)) {
                            var10_18 = this.env.getConfiguration().getSchemaType(var5_21);
                        } else {
                            if (!this.env.isImportedSchema(var11_20)) {
                                this.grumble("No schema has been imported for namespace '" + var11_20 + '\'');
                            }
                            var10_18 = this.env.getConfiguration().getSchemaType(var5_21);
                        }
                        if (var10_18 == null) {
                            this.grumble("Unknown type name " + var12_22);
                        }
                        if (var3_3 == 2 && var10_18.isComplexType()) {
                            this.grumble("An attribute cannot have a complex type");
                        }
                        var13_23 = new ContentTypeTest(var3_3, var10_18, this.env.getConfiguration());
                        if (var4_4 == -1) {
                            var9_16 /* !! */  = var13_23;
                        } else if (var3_3 == 2) {
                            var14_24 = new NameTest(2, var4_4, this.env.getNamePool());
                            var9_16 /* !! */  = new CombinedNodeTest(var14_24, 23, var13_23);
                        } else {
                            var14_25 = new NameTest(1, var4_4, this.env.getNamePool());
                            var9_16 /* !! */  = new CombinedNodeTest(var14_25, 23, var13_23);
                        }
                    } else {
                        this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after ',' in SequenceType");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 113) {
                        this.grumble("'?' (meaning nillable) in a sequence type is not yet supported");
                        return null;
                    }
                    this.nextToken();
                    return var9_16 /* !! */ ;
                }
                this.grumble("Expected ')' or ',' in SequenceType");
lbl183:
                // 2 sources

                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    private static int getSystemType(String string) throws StaticError {
        if ("item".equals(string)) {
            return 88;
        }
        if ("document-node".equals(string)) {
            return 9;
        }
        if ("element".equals(string)) {
            return 1;
        }
        if ("schema-element".equals(string)) {
            return 1;
        }
        if ("attribute".equals(string)) {
            return 2;
        }
        if ("schema-attribute".equals(string)) {
            return 2;
        }
        if ("text".equals(string)) {
            return 3;
        }
        if ("comment".equals(string)) {
            return 8;
        }
        if ("processing-instruction".equals(string)) {
            return 7;
        }
        if ("namespace".equals(string)) {
            return 13;
        }
        if ("node".equals(string)) {
            return 0;
        }
        if ("empty".equals(string)) {
            return 15;
        }
        throw new StaticError("Unknown type " + string);
    }

    private Expression parseFunctionCall() throws StaticError {
        Expression expression;
        String string;
        String[] stringArray;
        Expression[] expressionArray;
        String string2 = this.t.currentTokenValue;
        int n = this.t.currentTokenStartOffset;
        ArrayList<Expression[]> arrayList = new ArrayList<Expression[]>(10);
        this.nextToken();
        if (this.t.currentToken != 104) {
            expressionArray = this.parseExprSingle();
            arrayList.add(expressionArray);
            while (this.t.currentToken == 7) {
                this.nextToken();
                expressionArray = this.parseExprSingle();
                arrayList.add(expressionArray);
            }
            this.expect(104);
        }
        this.nextToken();
        expressionArray = new Expression[arrayList.size()];
        arrayList.toArray(expressionArray);
        try {
            stringArray = Name.getQNameParts(string2);
        }
        catch (QNameException qNameException) {
            this.grumble("Unknown prefix in function name " + string2 + "()");
            return null;
        }
        if ("".equals(stringArray[0])) {
            string = this.env.getDefaultFunctionNamespace();
        } else {
            try {
                string = this.env.getURIForPrefix(stringArray[0]);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
                return null;
            }
        }
        int n2 = this.env.getNamePool().allocate(stringArray[0], string, stringArray[1]);
        try {
            expression = this.env.getFunctionLibrary().bind(n2, string, stringArray[1], expressionArray);
        }
        catch (XPathException xPathException) {
            if (xPathException.getErrorCodeLocalPart() == null) {
                xPathException.setErrorCode("XPST0017");
            }
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
            return null;
        }
        if (expression == null) {
            String string3 = "Cannot find a matching " + expressionArray.length + "-argument function named " + this.env.getNamePool().getClarkName(n2) + "()";
            if (this.env.isInBackwardsCompatibleMode()) {
                DynamicError dynamicError = new DynamicError(string3);
                ErrorExpression errorExpression = new ErrorExpression(dynamicError);
                this.setLocation(errorExpression);
                return errorExpression;
            }
            this.grumble(string3);
        }
        if (expression instanceof CastExpression && ((AtomicType)expression.getItemType()).isNamespaceSensitive()) {
            try {
                return ((CastExpression)expression).doQNameCast(this.env);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
            }
        }
        this.setLocation(expression, n);
        for (int i = 0; i < expressionArray.length; ++i) {
            ((ComputedExpression)expression).adoptChildExpression(expressionArray[i]);
        }
        return this.makeTracer(n, expression, 2009, n2);
    }

    protected void declareRangeVariable(VariableDeclaration variableDeclaration) throws StaticError {
        if (this.rangeVariables == null) {
            this.rangeVariables = new Stack();
        }
        this.rangeVariables.push(variableDeclaration);
    }

    protected void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    private VariableDeclaration findRangeVariable(int n) {
        if (this.rangeVariables == null) {
            return null;
        }
        for (int i = this.rangeVariables.size() - 1; i >= 0; --i) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)this.rangeVariables.elementAt(i);
            if ((variableDeclaration.getNameCode() & 0xFFFFF) != n) continue;
            return variableDeclaration;
        }
        return null;
    }

    public Stack getRangeVariableStack() {
        return this.rangeVariables;
    }

    public void setRangeVariableStack(Stack stack) {
        this.rangeVariables = stack;
    }

    private Pattern parseUnionPattern() throws StaticError {
        Pattern pattern = this.parsePathPattern();
        while (this.t.currentToken == 1) {
            if (this.t.currentTokenValue == "union") {
                this.grumble("Union operator in a pattern must be written as '|'");
            }
            this.nextToken();
            Pattern pattern2 = this.parsePathPattern();
            pattern = new UnionPattern(pattern, pattern2);
        }
        return pattern;
    }

    private Pattern parsePathPattern() throws StaticError {
        Pattern pattern;
        Pattern pattern2 = null;
        int n = -1;
        boolean bl = false;
        switch (this.t.currentToken) {
            case 2: {
                n = this.t.currentToken;
                this.nextToken();
                pattern2 = new NodeTestPattern(NodeKindTest.makeNodeKindTest(9));
                bl = true;
                break;
            }
            case 8: {
                n = this.t.currentToken;
                this.nextToken();
                pattern2 = new NodeTestPattern(NodeKindTest.makeNodeKindTest(9));
                bl = false;
                break;
            }
        }
        while (true) {
            pattern = null;
            switch (this.t.currentToken) {
                case 35: {
                    if ("child".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        pattern = this.parsePatternStep((short)1);
                        break;
                    }
                    if ("attribute".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        pattern = this.parsePatternStep((short)2);
                        break;
                    }
                    this.grumble("Axis in pattern must be child or attribute");
                    break;
                }
                case 101: 
                case 107: 
                case 108: 
                case 112: {
                    pattern = this.parsePatternStep((short)1);
                    break;
                }
                case 110: {
                    pattern = this.parsePatternStep(this.t.currentTokenValue == "attribute" ? (short)2 : 1);
                    break;
                }
                case 3: {
                    this.nextToken();
                    pattern = this.parsePatternStep((short)2);
                    break;
                }
                case 34: {
                    Object object;
                    if (pattern2 != null) {
                        this.grumble("Function call may appear only at the start of a pattern");
                    }
                    if ("id".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        object = null;
                        if (this.t.currentToken == 102) {
                            object = new StringValue(this.t.currentTokenValue);
                        } else if (this.t.currentToken == 21) {
                            this.nextToken();
                            this.expect(101);
                            int n2 = this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF;
                            object = new VariableReference(this.env.bindVariable(n2));
                        } else {
                            this.grumble("id value in pattern must be either a literal or a variable reference");
                        }
                        pattern = new IDPattern((Expression)object);
                        this.nextToken();
                        this.expect(104);
                        this.nextToken();
                        break;
                    }
                    if ("key".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        this.expect(102);
                        object = this.t.currentTokenValue;
                        this.nextToken();
                        this.expect(7);
                        this.nextToken();
                        Expression expression = null;
                        if (this.t.currentToken == 102) {
                            expression = new StringValue(this.t.currentTokenValue);
                        } else if (this.t.currentToken == 21) {
                            this.nextToken();
                            this.expect(101);
                            int n3 = this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF;
                            expression = new VariableReference(this.env.bindVariable(n3));
                        } else {
                            this.grumble("key value must be either a literal or a variable reference");
                        }
                        pattern = new KeyPattern(this.makeNameCode((String)object, false), expression);
                        this.nextToken();
                        this.expect(104);
                        this.nextToken();
                        break;
                    }
                    this.grumble("The only functions allowed in a pattern are id() and key()");
                    break;
                }
                default: {
                    if (bl) {
                        return pattern2;
                    }
                    this.grumble("Unexpected token in pattern, found " + this.currentTokenDisplay());
                }
            }
            if (pattern2 != null) {
                if (n == 2) {
                    ((LocationPathPattern)pattern).parentPattern = pattern2;
                } else {
                    ((LocationPathPattern)pattern).ancestorPattern = pattern2;
                }
            }
            n = this.t.currentToken;
            bl = false;
            if (n != 2 && n != 8) break;
            pattern2 = pattern;
            this.nextToken();
        }
        return pattern;
    }

    private Pattern parsePatternStep(short s) throws StaticError {
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        NodeTest nodeTest = this.parseNodeTest(s);
        if (nodeTest instanceof AnyNodeTest) {
            nodeTest = s == 1 ? new AnyChildNodePattern() : NodeKindTest.makeNodeKindTest(s);
        }
        int n = nodeTest.getPrimitiveType();
        if (s == 1 && (n == 2 || n == 13)) {
            nodeTest = new NoNodeTest();
        } else if (s == 2 && (n == 8 || n == 3 || n == 7 || n == 1 || n == 9)) {
            nodeTest = new NoNodeTest();
        }
        locationPathPattern.nodeTest = nodeTest;
        this.parseFilters(locationPathPattern);
        return locationPathPattern;
    }

    private void parseFilters(LocationPathPattern locationPathPattern) throws StaticError {
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression expression = this.parseExpression();
            this.expect(103);
            this.nextToken();
            locationPathPattern.addFilter(expression);
        }
    }

    public final int makeNameCode(String string, boolean bl) throws StaticError {
        if (this.scanOnly) {
            return -1;
        }
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = stringArray[0];
            if ("".equals(string2)) {
                short s = 0;
                if (bl) {
                    s = this.env.getDefaultElementNamespace();
                }
                return this.env.getNamePool().allocate(string2, s, string);
            }
            try {
                String string3 = this.env.getURIForPrefix(string2);
                if (string3 == null) {
                    this.grumble("Undeclared namespace prefix " + Err.wrap(string2));
                    return -1;
                }
                return this.env.getNamePool().allocate(string2, string3, stringArray[1]);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
                return -1;
            }
        }
        catch (QNameException qNameException) {
            this.grumble(qNameException.getMessage());
            return -1;
        }
    }

    public NameTest makeNameTest(short s, String string, boolean bl) throws StaticError {
        int n = this.makeNameCode(string, bl);
        NameTest nameTest = new NameTest(s, n, this.env.getNamePool());
        return nameTest;
    }

    public NamespaceTest makeNamespaceTest(short s, String string) throws StaticError {
        if (this.scanOnly) {
            return new NamespaceTest(this.env.getNamePool(), s, "http://saxon.sf.net/");
        }
        try {
            NamespaceTest namespaceTest = new NamespaceTest(this.env.getNamePool(), s, this.env.getURIForPrefix(string));
            return namespaceTest;
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
            return null;
        }
    }

    public LocalNameTest makeLocalNameTest(short s, String string) throws StaticError {
        if (!XMLChar.isValidNCName(string)) {
            this.grumble("Local name [" + string + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getNamePool(), s, string);
    }

    protected void setLocation(Expression expression) {
        if (expression instanceof ComputedExpression) {
            this.setLocation(expression, this.t.currentTokenStartOffset);
        }
    }

    protected void setLocation(Expression expression, int n) {
        int n2 = this.t.getLineNumber(n);
        if (expression instanceof ComputedExpression && ((ComputedExpression)expression).getLocationId() == -1) {
            int n3 = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), n2);
            ComputedExpression computedExpression = (ComputedExpression)expression;
            computedExpression.setLocationId(n3);
            if (computedExpression.getParentExpression() == null) {
                TemporaryContainer temporaryContainer = new TemporaryContainer(this.env.getLocationMap(), n3);
                computedExpression.setParentExpression(temporaryContainer);
            }
        }
    }

    protected Expression makeTracer(int n, Expression expression, int n2, int n3) {
        if (this.env.getConfiguration().getTraceListener() != null) {
            TraceExpression traceExpression = new TraceExpression(expression);
            long l = this.t.getLineAndColumn(n);
            traceExpression.setLineNumber((int)(l >> 32));
            traceExpression.setColumnNumber((int)(l & Integer.MAX_VALUE));
            traceExpression.setSystemId(this.env.getSystemId());
            traceExpression.setNamespaceResolver(this.env.getNamespaceResolver());
            traceExpression.setConstructType(n2);
            traceExpression.setObjectNameCode(n3);
            return traceExpression;
        }
        return expression;
    }

    protected boolean isKeyword(String string) {
        return this.t.currentToken == 101 && this.t.currentTokenValue.equals(string);
    }

    public void setScanOnly(boolean bl) {
        this.scanOnly = bl;
    }

    private static class TemporaryContainer
    implements Container,
    LocationProvider {
        private LocationMap map;
        private int locationId;

        public TemporaryContainer(LocationMap locationMap, int n) {
            this.map = locationMap;
            this.locationId = n;
        }

        public Executable getExecutable() {
            return null;
        }

        public LocationProvider getLocationProvider() {
            return this.map;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.map.getSystemId(this.locationId);
        }

        public int getLineNumber() {
            return this.map.getLineNumber(this.locationId);
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId(int n) {
            return this.getSystemId();
        }

        public int getLineNumber(int n) {
            return this.getLineNumber();
        }
    }

    public static class ForClause {
        public RangeVariableDeclaration rangeVariable;
        public RangeVariableDeclaration positionVariable;
        public Expression sequence;
        public SequenceType requiredType;
        public int offset;
    }
}

