/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeVariableDeclaration
implements VariableDeclaration {
    private int nameCode;
    private SequenceType requiredType;
    private String variableName;
    private List references = new ArrayList(5);

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public void setReferenceList(List list) {
        this.references = list;
    }

    public List getReferenceList() {
        return this.references;
    }

    public int getReferenceCount(Binding binding) {
        return RangeVariableDeclaration.getReferenceCount(this.references, binding);
    }

    public static int getReferenceCount(List list, Binding binding) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (((VariableReference)list.get(i)).getBinding() != null) continue;
            list.remove(i);
        }
        if (list.size() != 1) {
            return list.size();
        }
        VariableReference variableReference = (VariableReference)list.get(0);
        ComputedExpression computedExpression = variableReference;
        Container container = variableReference.getParentExpression();
        int n = 0;
        while (container != null) {
            if (container instanceof ComputedExpression) {
                if (container == binding) {
                    return 1;
                }
                if (ExpressionTool.isRepeatedSubexpression((ComputedExpression)container, computedExpression)) {
                    return 10;
                }
                computedExpression = (ComputedExpression)container;
                container = computedExpression.getParentExpression();
                if (n++ <= 10000) continue;
                throw new IllegalStateException("The expression tree appears to contain a cycle");
            }
            if (container instanceof UserFunction) {
                UserFunctionParameter[] userFunctionParameterArray = ((UserFunction)container).getParameterDefinitions();
                for (int i = 0; i < userFunctionParameterArray.length; ++i) {
                    if (userFunctionParameterArray[i] != binding) continue;
                    int n2 = userFunctionParameterArray[i].getReferenceCount();
                    return n2;
                }
                return 10;
            }
            return 10;
        }
        return 10;
    }

    public void fixupReferences(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            BindingReference bindingReference = (BindingReference)iterator.next();
            bindingReference.setStaticType(this.requiredType, null, 0);
            bindingReference.fixup(binding);
        }
    }

    public void refineTypeInformation(ItemType itemType, int n, Value value, int n2) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            int n3;
            ItemType itemType2;
            BindingReference bindingReference = (BindingReference)iterator.next();
            if (!(bindingReference instanceof VariableReference)) continue;
            ItemType itemType3 = itemType2 = ((VariableReference)bindingReference).getItemType();
            if (Type.isSubType(itemType, itemType2)) {
                itemType3 = itemType;
            }
            if ((n3 = n & ((VariableReference)bindingReference).getCardinality()) == 0) {
                n3 = ((VariableReference)bindingReference).getCardinality();
            }
            SequenceType sequenceType = SequenceType.makeSequenceType(itemType3, n3);
            bindingReference.setStaticType(sequenceType, value, n2);
        }
    }
}

