/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class UserFunctionCall
extends FunctionCall
implements InstructionInfoProvider {
    private SequenceType staticType;
    private UserFunction function;
    private boolean tailRecursive = false;
    private boolean confirmed = false;

    public void setStaticType(SequenceType sequenceType) {
        this.staticType = sequenceType;
    }

    public void setFunction(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        this.function = userFunction;
        this.confirmed = true;
    }

    public void checkFunctionCall(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        int n = userFunction.getNumberOfArguments();
        for (int i = 0; i < n; ++i) {
            RoleLocator roleLocator = new RoleLocator(0, new Integer(userFunction.getFunctionNameCode()), i, staticContext.getNamePool());
            roleLocator.setSourceLocator(this);
            this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], userFunction.getArgumentType(i), false, roleLocator, staticContext);
        }
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public void setConfirmed(boolean bl) {
        this.confirmed = bl;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int getIntrinsicDependencies() {
        return 256;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i] = this.argument[i].simplify(staticContext);
        }
        return this;
    }

    public boolean markTailFunctionCalls() {
        this.tailRecursive = true;
        return true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.callFunction(xPathContext);
        if (valueRepresentation instanceof Item) {
            return (Item)valueRepresentation;
        }
        return Value.getIterator(valueRepresentation).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.callFunction(xPathContext);
        if (valueRepresentation instanceof FunctionCallPackage) {
            return SingletonIterator.makeIterator((FunctionCallPackage)valueRepresentation);
        }
        return Value.getIterator(valueRepresentation);
    }

    private ValueRepresentation callFunction(XPathContext xPathContext) throws XPathException {
        int n = this.argument.length;
        ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.function.getParameterDefinitions()[i].getReferenceCount();
            if (this.argument[i] instanceof Value) {
                valueRepresentationArray[i] = (Value)this.argument[i];
            } else if (n2 == 0) {
                valueRepresentationArray[i] = EmptySequence.getInstance();
            } else if ((this.argument[i].getDependencies() & 0x100) != 0) {
                valueRepresentationArray[i] = ExpressionTool.eagerEvaluate(this.argument[i], xPathContext);
            } else {
                boolean bl = n2 > 1;
                valueRepresentationArray[i] = ExpressionTool.lazyEvaluate(this.argument[i], xPathContext, bl);
            }
            if (n2 <= 1 || !(valueRepresentationArray[i] instanceof Closure) || valueRepresentationArray[i] instanceof MemoClosure) continue;
            valueRepresentationArray[i] = ((Closure)valueRepresentationArray[i]).reduce();
        }
        if (this.tailRecursive) {
            return new FunctionCallPackage(this.function, valueRepresentationArray, xPathContext);
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        try {
            return this.function.call(valueRepresentationArray, xPathContextMajor, true);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new DynamicError("Too many nested function calls. May be due to infinite recursion.", this);
        }
    }

    public ValueRepresentation dynamicCall(ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray2 = new ValueRepresentation[valueRepresentationArray.length];
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.openStackFrame(valueRepresentationArray.length);
        for (int i = 0; i < valueRepresentationArray.length; ++i) {
            xPathContextMajor.setLocalVariable(i, valueRepresentationArray[i]);
            valueRepresentationArray2[i] = ExpressionTool.lazyEvaluate(this.argument[i], xPathContextMajor, true);
        }
        XPathContextMajor xPathContextMajor2 = xPathContextMajor.newCleanContext();
        xPathContextMajor2.setOrigin(this);
        return this.function.call(valueRepresentationArray2, xPathContextMajor2, true);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "function " + this.getDisplayName(namePool) + (this.tailRecursive ? " (tail call)" : ""));
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i].display(n + 1, namePool, printStream);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2009);
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setObjectNameCode(this.getFunctionNameCode());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setProperty("target", this.function);
        return instructionDetails;
    }

    public static class Flattener
    implements MappingFunction {
        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            if (item instanceof FunctionCallPackage) {
                return ((FunctionCallPackage)item).iterateResults(xPathContext);
            }
            return item;
        }
    }

    public class FunctionCallPackage
    extends ObjectValue {
        private UserFunction function;
        private ValueRepresentation[] actualArgs;
        private XPathContext evaluationContext;

        public FunctionCallPackage(UserFunction userFunction, ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) {
            super(userFunction);
            this.function = userFunction;
            this.actualArgs = valueRepresentationArray;
            this.evaluationContext = xPathContext;
        }

        public ItemType getItemType() {
            return UserFunctionCall.this.getItemType();
        }

        public ValueRepresentation call() throws XPathException {
            XPathContextMajor xPathContextMajor = this.evaluationContext.newCleanContext();
            xPathContextMajor.setOrigin(UserFunctionCall.this);
            return this.function.call(this.actualArgs, xPathContextMajor, false);
        }

        public SequenceIterator iterateResults(XPathContext xPathContext) throws XPathException {
            ValueRepresentation valueRepresentation = this.call();
            return new MappingIterator(Value.getIterator(valueRepresentation), new Flattener(), xPathContext);
        }

        public ValueRepresentation appendTo(SequenceReceiver sequenceReceiver) throws XPathException {
            ValueRepresentation valueRepresentation = this.call();
            SequenceIterator sequenceIterator = Value.getIterator(valueRepresentation);
            Item item;
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof FunctionCallPackage) {
                    return (Value)((Object)item);
                }
                sequenceReceiver.append(item, UserFunctionCall.this.locationId, 2);
            }
            return null;
        }

        public Value reduce() throws XPathException {
            return new SequenceExtent(this.iterateResults(null)).reduce();
        }

        public AtomicValue getPrimitiveValue() {
            try {
                return ((AtomicValue)this.reduce()).getPrimitiveValue();
            }
            catch (XPathException xPathException) {
                throw new RuntimeException(xPathException);
            }
        }
    }
}

