/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public final ItemType getItemType() {
        ItemType itemType = this.operand0.getItemType();
        ItemType itemType2 = this.operand1.getItemType();
        return Type.getCommonSuperType(itemType, itemType2);
    }

    public final int computeCardinality() {
        int n = this.operand0.getCardinality();
        int n2 = this.operand1.getCardinality();
        switch (this.operator) {
            case 1: {
                if (this.operand0 instanceof EmptySequence) {
                    return n2;
                }
                if (this.operand1 instanceof EmptySequence) {
                    return n;
                }
                return n | n2 | 0x4000 | 0x8000;
            }
            case 23: {
                if (this.operand0 instanceof EmptySequence) {
                    return 8192;
                }
                if (this.operand1 instanceof EmptySequence) {
                    return 8192;
                }
                return n & n2 | 0x2000 | 0x4000;
            }
            case 24: {
                if (this.operand0 instanceof EmptySequence) {
                    return 8192;
                }
                if (this.operand1 instanceof EmptySequence) {
                    return n;
                }
                return n | 0x2000 | 0x4000;
            }
        }
        return 57344;
    }

    public int computeSpecialProperties() {
        int n = this.operand0.getSpecialProperties();
        int n2 = this.operand1.getSpecialProperties();
        int n3 = 131072;
        if (this.testContextDocumentNodeSet(n, n2)) {
            n3 |= 0x10000;
        }
        if (this.testSubTree(n, n2)) {
            n3 |= 0x100000;
        }
        if (!this.testCreative(n, n2)) {
            n3 |= 0x400000;
        }
        return n3;
    }

    private boolean testContextDocumentNodeSet(int n, int n2) {
        switch (this.operator) {
            case 1: {
                return (n & n2 & 0x10000) != 0;
            }
            case 23: {
                return ((n | n2) & 0x10000) != 0;
            }
            case 24: {
                return (n & 0x10000) != 0;
            }
        }
        return false;
    }

    private boolean testSubTree(int n, int n2) {
        switch (this.operator) {
            case 1: {
                return (n & n2 & 0x100000) != 0;
            }
            case 23: {
                return ((n | n2) & 0x100000) != 0;
            }
            case 24: {
                return (n & 0x100000) != 0;
            }
        }
        return false;
    }

    private boolean testCreative(int n, int n2) {
        return (n & 0x400000) != 1 || (n2 & 0x400000) != 1;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        ComputedExpression computedExpression;
        ComputedExpression computedExpression2;
        this.operand0 = this.operand0.simplify(staticContext);
        this.operand1 = this.operand1.simplify(staticContext);
        switch (this.operator) {
            case 1: {
                if (this.operand0 instanceof EmptySequence && (this.operand1.getSpecialProperties() & 0x20000) != 0) {
                    return this.operand1;
                }
                if (!(this.operand1 instanceof EmptySequence) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
            case 23: {
                if (this.operand0 instanceof EmptySequence) {
                    return this.operand0;
                }
                if (!(this.operand1 instanceof EmptySequence)) break;
                return this.operand1;
            }
            case 24: {
                if (this.operand0 instanceof EmptySequence) {
                    return this.operand0;
                }
                if (!(this.operand1 instanceof EmptySequence) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
        }
        if (this.operand0 instanceof AxisExpression && this.operand1 instanceof AxisExpression) {
            computedExpression2 = (AxisExpression)this.operand0;
            computedExpression = (AxisExpression)this.operand1;
            if (((AxisExpression)computedExpression2).getAxis() == ((AxisExpression)computedExpression).getAxis()) {
                return new AxisExpression(((AxisExpression)computedExpression2).getAxis(), new CombinedNodeTest(((AxisExpression)computedExpression2).getNodeTest(), this.operator, ((AxisExpression)computedExpression).getNodeTest()));
            }
        }
        if (this.operand0 instanceof PathExpression && this.operand1 instanceof PathExpression && this.operator == 1) {
            computedExpression2 = (PathExpression)this.operand0;
            computedExpression = (PathExpression)this.operand1;
            if (((PathExpression)computedExpression2).getFirstStep().equals(((PathExpression)computedExpression).getFirstStep())) {
                Expression expression = new PathExpression(((PathExpression)computedExpression2).getFirstStep(), new VennExpression(((PathExpression)computedExpression2).getRemainingSteps(), this.operator, ((PathExpression)computedExpression).getRemainingSteps())).simplify(staticContext);
                ExpressionTool.copyLocationInfo(this, expression);
                return expression;
            }
        }
        if (this.operand0 instanceof FilterExpression && this.operand1 instanceof FilterExpression) {
            computedExpression2 = (FilterExpression)this.operand0;
            computedExpression = (FilterExpression)this.operand1;
            if (!((FilterExpression)computedExpression2).isPositional() && !((FilterExpression)computedExpression).isPositional() && ((FilterExpression)computedExpression2).getBaseExpression().equals(((FilterExpression)computedExpression).getBaseExpression())) {
                Expression expression;
                BooleanExpression booleanExpression;
                switch (this.operator) {
                    case 1: {
                        booleanExpression = new BooleanExpression(((FilterExpression)computedExpression2).getFilter(), 9, ((FilterExpression)computedExpression).getFilter());
                        break;
                    }
                    case 23: {
                        booleanExpression = new BooleanExpression(((FilterExpression)computedExpression2).getFilter(), 10, ((FilterExpression)computedExpression).getFilter());
                        break;
                    }
                    case 24: {
                        expression = SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
                        Expression[] expressionArray = new Expression[]{((FilterExpression)computedExpression).getFilter()};
                        expression.setArguments(expressionArray);
                        booleanExpression = new BooleanExpression(((FilterExpression)computedExpression2).getFilter(), 10, expression);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                expression = new FilterExpression(((FilterExpression)computedExpression2).getBaseExpression(), booleanExpression, staticContext).simplify(staticContext);
                ExpressionTool.copyLocationInfo(this, booleanExpression);
                ExpressionTool.copyLocationInfo(this, expression);
                return expression;
            }
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.analyze(staticContext, itemType);
        this.operand1 = this.operand1.analyze(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.NODE_SEQUENCE, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.NODE_SEQUENCE, false, roleLocator2, staticContext);
        return this;
    }

    public int hashCode() {
        return this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand0.iterate(xPathContext);
        if ((this.operand0.getSpecialProperties() & 0x20000) == 0) {
            sequenceIterator = new DocumentOrderIterator(sequenceIterator, GlobalOrderComparer.getInstance());
        }
        SequenceIterator sequenceIterator2 = this.operand1.iterate(xPathContext);
        if ((this.operand1.getSpecialProperties() & 0x20000) == 0) {
            sequenceIterator2 = new DocumentOrderIterator(sequenceIterator2, GlobalOrderComparer.getInstance());
        }
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(sequenceIterator, sequenceIterator2, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Set Expression");
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        if (this.operator == 1) {
            return this.operand0.effectiveBooleanValue(xPathContext) || this.operand1.effectiveBooleanValue(xPathContext);
        }
        return super.effectiveBooleanValue(xPathContext);
    }
}

