/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    SequenceIterator currentIterator;
    int last = -1;
    SequenceReceiver currentReceiver;
    boolean isTemporaryDestination = false;
    XPathContext caller = null;
    Object origin = null;

    protected XPathContextMinor() {
    }

    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext(this);
    }

    public XPathContextMinor newMinorContext() {
        XPathContextMinor xPathContextMinor = new XPathContextMinor();
        xPathContextMinor.controller = this.controller;
        xPathContextMinor.caller = this;
        xPathContextMinor.currentIterator = this.currentIterator;
        xPathContextMinor.currentReceiver = this.currentReceiver;
        xPathContextMinor.last = this.last;
        xPathContextMinor.isTemporaryDestination = this.isTemporaryDestination;
        return xPathContextMinor;
    }

    public void setCaller(XPathContext xPathContext) {
        this.caller = xPathContext;
    }

    public XPathContextMajor newCleanContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.getController());
        xPathContextMajor.setCaller(this);
        return xPathContextMajor;
    }

    public XPathContextMajor.XSLTContext getXSLTContext() {
        return this.getCaller().getXSLTContext();
    }

    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    public void setOrigin(InstructionInfoProvider instructionInfoProvider) {
        this.origin = instructionInfoProvider;
    }

    public void setOriginatingConstructType(int n) {
        this.origin = new Integer(n);
    }

    public int getOriginatingConstructType() {
        if (this.origin instanceof InstructionInfoProvider) {
            return ((InstructionInfoProvider)this.origin).getInstructionInfo().getConstructType();
        }
        return (Integer)this.origin;
    }

    public InstructionInfoProvider getOrigin() {
        if (this.origin instanceof InstructionInfoProvider) {
            return (InstructionInfoProvider)this.origin;
        }
        return null;
    }

    public Controller getController() {
        return this.controller;
    }

    public XPathContext getCaller() {
        return this.caller;
    }

    public void setCurrentIterator(SequenceIterator sequenceIterator) {
        this.currentIterator = sequenceIterator;
        this.last = 0;
    }

    public SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public int getContextPosition() throws DynamicError {
        if (this.currentIterator == null) {
            DynamicError dynamicError = new DynamicError("The context position is currently undefined");
            dynamicError.setXPathContext(this);
            dynamicError.setErrorCode("XPDY0002");
            throw dynamicError;
        }
        return this.currentIterator.position();
    }

    public Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public int getLast() throws XPathException {
        if (this.last > 0) {
            return this.last;
        }
        if (this.currentIterator == null) {
            DynamicError dynamicError = new DynamicError("The context size is currently undefined");
            dynamicError.setXPathContext(this);
            dynamicError.setErrorCode("XPDY0002");
            throw dynamicError;
        }
        if (this.currentIterator instanceof LastPositionFinder) {
            this.last = ((LastPositionFinder)this.currentIterator).getLastPosition();
            return this.last;
        }
        SequenceIterator sequenceIterator = this.currentIterator.getAnother();
        this.last = 0;
        while (sequenceIterator.next() != null) {
            ++this.last;
        }
        return this.last;
    }

    public boolean isAtLast() throws XPathException {
        if (this.currentIterator instanceof LookaheadIterator) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.getContextPosition() == this.getLast();
    }

    public Comparator getCollation(String string) throws XPathException {
        if (string.equals("http://www.w3.org/2005/04/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        Comparator comparator = null;
        if (this.controller != null) {
            comparator = this.controller.getExecutable().getNamedCollation(string);
        }
        if (comparator == null && (comparator = CollationFactory.makeCollationFromURI(string, this.getController().getConfiguration())) == null) {
            DynamicError dynamicError = new DynamicError("Unknown collation " + string);
            dynamicError.setXPathContext(this);
            throw dynamicError;
        }
        return comparator;
    }

    public Comparator getDefaultCollation() {
        if (this.controller != null) {
            return this.controller.getExecutable().getDefaultCollation();
        }
        return CodepointCollator.getInstance();
    }

    public StackFrame getStackFrame() {
        return this.getCaller().getStackFrame();
    }

    public ValueRepresentation evaluateLocalVariable(int n) {
        return this.getCaller().evaluateLocalVariable(n);
    }

    public void setLocalVariable(int n, ValueRepresentation valueRepresentation) {
        this.getCaller().setLocalVariable(n, valueRepresentation);
    }

    public void changeOutputDestination(Properties properties, Result result, boolean bl, int n, SchemaType schemaType) throws XPathException {
        if (bl && this.isTemporaryDestination) {
            DynamicError dynamicError = new DynamicError("Cannot switch to a final result destination while writing a temporary tree");
            dynamicError.setErrorCode("XTDE1480");
            throw dynamicError;
        }
        if (bl) {
            n |= 0x10000;
        } else {
            this.isTemporaryDestination = true;
        }
        PipelineConfiguration pipelineConfiguration = this.controller.makePipelineConfiguration();
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setPipelineConfiguration(pipelineConfiguration);
        if (properties == null) {
            properties = new Properties();
        }
        Receiver receiver = ResultWrapper.getReceiver(result, pipelineConfiguration, properties);
        if (schemaType != null) {
            try {
                this.getController().getErrorListener().warning(new DynamicError("Type attribute for result document is currently ignored"));
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        receiver = this.controller.getConfiguration().getDocumentValidator(receiver, receiver.getSystemId(), this.controller.getNamePool(), n);
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
        complexContentOutputter.setReceiver(namespaceReducer);
        complexContentOutputter.open();
        this.currentReceiver = complexContentOutputter;
    }

    public void setTemporaryReceiver(SequenceReceiver sequenceReceiver) {
        this.isTemporaryDestination = true;
        this.currentReceiver = sequenceReceiver;
    }

    public void setReceiver(SequenceReceiver sequenceReceiver) {
        this.currentReceiver = sequenceReceiver;
    }

    public SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    public boolean useLocalParameter(int n, LocalParam localParam, boolean bl) throws XPathException {
        return this.getCaller().useLocalParameter(n, localParam, bl);
    }

    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    public Template getCurrentTemplate() {
        return this.getCaller().getCurrentTemplate();
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    public int getImplicitTimezone() {
        return this.getController().getConfiguration().getImplicitTimezone();
    }
}

