/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class BooleanFn
extends SystemFunction {
    public static final int BOOLEAN = 0;
    public static final int NOT = 1;
    public static final int TRUE = 2;
    public static final int FALSE = 3;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (this.operation == 0 || this.operation == 1) {
            this.argument[0] = ExpressionTool.unsortedIfHomogeneous(this.argument[0], false);
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 0: {
                return this.argument[0].effectiveBooleanValue(xPathContext);
            }
            case 1: {
                return !this.argument[0].effectiveBooleanValue(xPathContext);
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation");
    }
}

