/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.TimeValue;

public class CurrentDateTime
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        DateTimeValue dateTimeValue = DateTimeValue.getCurrentDateTime(xPathContext);
        int n = this.getItemType().getPrimitiveType();
        switch (n) {
            case 519: {
                return dateTimeValue;
            }
            case 521: {
                return (DateValue)dateTimeValue.convert(521, xPathContext);
            }
            case 520: {
                return (TimeValue)dateTimeValue.convert(520, xPathContext);
            }
            case 518: 
            case 645: {
                return dateTimeValue.getComponent(7);
            }
        }
        throw new IllegalArgumentException("Wrong target type for current date/time");
    }

    public static SecondsDurationValue getImplicitTimezone(XPathContext xPathContext) throws XPathException {
        DateTimeValue dateTimeValue = DateTimeValue.getCurrentDateTime(xPathContext);
        return (SecondsDurationValue)dateTimeValue.getComponent(7);
    }
}

