/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class Doc
extends SystemFunction {
    public static final int DOC = 0;
    public static final int DOC_AVAILABLE = 1;
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.operation == 0) {
            return this.doc(xPathContext);
        }
        try {
            Controller controller = xPathContext.getController();
            ErrorListener errorListener = controller.getErrorListener();
            controller.setErrorListener(new ErrorListener(){

                public void warning(TransformerException transformerException) {
                }

                public void error(TransformerException transformerException) {
                }

                public void fatalError(TransformerException transformerException) {
                }
            });
            Item item = this.doc(xPathContext);
            controller.setErrorListener(errorListener);
            return BooleanValue.get(item != null);
        }
        catch (XPathException xPathException) {
            return BooleanValue.FALSE;
        }
    }

    private Item doc(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        String string = atomicValue.getStringValue();
        NodeInfo nodeInfo = Document.makeDoc(string, this.expressionBaseURI, xPathContext, this);
        if (nodeInfo == null) {
            this.dynamicError("Failed to load document " + string, "FODC0005", xPathContext);
            return null;
        }
        return nodeInfo;
    }
}

