/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

public class Document
extends SystemFunction
implements XSLTFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
            this.argument[0] = ExpressionTool.unsorted(this.argument[0], false);
        }
    }

    public int computeCardinality() {
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return 57344;
        }
        return 24576;
    }

    public int computeSpecialProperties() {
        return 0x4A0000;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        int n = this.argument.length;
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        String string = null;
        if (n == 2) {
            object = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
            string = object.getBaseURI();
        }
        object = new DocumentMappingFunction();
        ((DocumentMappingFunction)object).baseURI = string;
        ((DocumentMappingFunction)object).stylesheetURI = this.expressionBaseURI;
        ((DocumentMappingFunction)object).locator = this;
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, (MappingFunction)object, xPathContext);
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return new DocumentOrderIterator(mappingIterator, GlobalOrderComparer.getInstance());
        }
        return mappingIterator;
    }

    public static NodeInfo makeDoc(String string, String string2, XPathContext xPathContext, SourceLocator sourceLocator) throws XPathException {
        Object object;
        String string3;
        int n = string.indexOf(35);
        String string4 = null;
        if (n >= 0) {
            if (n == string.length() - 1) {
                string = string.substring(0, n);
            } else {
                string4 = string.substring(n + 1);
                string = string.substring(0, n);
            }
        }
        if (string2 == null) {
            try {
                string3 = new URI(string).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = '/' + string;
                string2 = "";
            }
        } else if (string.equals("")) {
            string3 = string2;
        } else {
            try {
                object = new URI(string2).resolve(string);
                string3 = ((URI)object).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = string2 + "/../" + string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string3 = string2 + "/../" + string;
            }
        }
        object = xPathContext.getController();
        DocumentInfo documentInfo = ((Controller)object).getDocumentPool().find(string3);
        if (documentInfo != null) {
            return Document.getFragment(documentInfo, string4, xPathContext);
        }
        try {
            DocumentInfo documentInfo2;
            URIResolver uRIResolver = ((Controller)object).getURIResolver();
            Source source = uRIResolver.resolve(string, string2);
            if (source == null) {
                uRIResolver = ((Controller)object).getStandardURIResolver();
                source = uRIResolver.resolve(string, string2);
            }
            if (source instanceof NodeInfo || source instanceof DOMSource) {
                NodeInfo nodeInfo = ((Controller)object).prepareInputTree(source);
                documentInfo2 = nodeInfo.getDocumentRoot();
            } else {
                Builder builder = ((Controller)object).makeBuilder();
                Receiver receiver = ((Controller)object).makeStripper(builder);
                if (((Controller)object).getExecutable().stripsInputTypeAnnotations()) {
                    receiver = ((Controller)object).getConfiguration().getAnnotationStripper(receiver);
                }
                new Sender(((Controller)object).makePipelineConfiguration()).send(source, receiver);
                documentInfo2 = (DocumentInfo)builder.getCurrentRoot();
            }
            ((Controller)object).registerDocument(documentInfo2, string3);
            return Document.getFragment(documentInfo2, string4, xPathContext);
        }
        catch (TransformerException transformerException) {
            DynamicError dynamicError = DynamicError.makeDynamicError(transformerException);
            dynamicError.setLocator(sourceLocator);
            dynamicError.setErrorCode("FODC0005");
            try {
                ((Controller)object).recoverableError(dynamicError);
            }
            catch (XPathException xPathException) {
                throw new DynamicError(transformerException);
            }
            return null;
        }
    }

    private static NodeInfo getFragment(DocumentInfo documentInfo, String string, XPathContext xPathContext) throws XPathException {
        if (string == null) {
            return documentInfo;
        }
        if (!XMLChar.isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Invalid fragment identifier in URI");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTRE1160");
            try {
                xPathContext.getController().recoverableError(dynamicError);
            }
            catch (DynamicError dynamicError2) {
                throw dynamicError;
            }
            return documentInfo;
        }
        return documentInfo.selectID(string);
    }

    private static class DocumentMappingFunction
    implements MappingFunction {
        public String baseURI;
        public String stylesheetURI;
        public SourceLocator locator;

        private DocumentMappingFunction() {
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            if (this.baseURI == null) {
                this.baseURI = item instanceof NodeInfo ? ((NodeInfo)item).getBaseURI() : this.stylesheetURI;
            }
            NodeInfo nodeInfo = Document.makeDoc(item.getStringValue(), this.baseURI, xPathContext, this.locator);
            return nodeInfo;
        }
    }
}

