/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class ExtensionFunctionCall
extends FunctionCall {
    private transient AccessibleObject theMethod;
    private MethodRepresentation persistentMethod;
    private Class theClass;
    private Configuration config;
    static /* synthetic */ Class class$net$sf$saxon$expr$XPathContext;
    static /* synthetic */ Class class$net$sf$saxon$value$Value;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$net$sf$saxon$value$BooleanValue;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$net$sf$saxon$value$FloatValue;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$net$sf$saxon$value$BigIntegerValue;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$net$sf$saxon$value$Closure;

    public void init(int n, Class clazz, AccessibleObject accessibleObject, Configuration configuration) {
        this.setFunctionNameCode(n);
        this.theClass = clazz;
        this.theMethod = accessibleObject;
        this.config = configuration;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public int getIntrinsicDependencies() {
        Class<?>[] classArray;
        if (this.theMethod instanceof Method && (classArray = ((Method)this.theMethod).getParameterTypes()).length > 0 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? (class$net$sf$saxon$expr$XPathContext = ExtensionFunctionCall.class$("net.sf.saxon.expr.XPathContext")) : class$net$sf$saxon$expr$XPathContext)) {
            return 14;
        }
        return 0;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[this.argument.length];
        for (int i = 0; i < valueRepresentationArray.length; ++i) {
            valueRepresentationArray[i] = ExpressionTool.lazyEvaluate(this.argument[i], xPathContext, false);
        }
        try {
            return this.call(valueRepresentationArray, xPathContext);
        }
        catch (XPathException xPathException) {
            String string = xPathException.getMessage();
            string = "Error in call to extension function {" + this.theMethod.toString() + "}: " + string;
            DynamicError dynamicError = new DynamicError(string, xPathException.getException());
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            throw dynamicError;
        }
    }

    public Class getTargetClass() {
        return this.theClass;
    }

    public AccessibleObject getTargetMethod() {
        return this.theMethod;
    }

    private SequenceIterator call(ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) throws XPathException {
        if (this.theMethod instanceof Constructor) {
            Constructor constructor = (Constructor)this.theMethod;
            Class[] classArray = constructor.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            this.setupParams(valueRepresentationArray, objectArray, classArray, 0, 0, xPathContext);
            try {
                Object object = this.invokeConstructor(constructor, objectArray);
                return this.asIterator(object, xPathContext);
            }
            catch (InstantiationException instantiationException) {
                DynamicError dynamicError = new DynamicError("Cannot instantiate class", instantiationException);
                throw dynamicError;
            }
            catch (IllegalAccessException illegalAccessException) {
                DynamicError dynamicError = new DynamicError("Constructor access is illegal", illegalAccessException);
                throw dynamicError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DynamicError dynamicError = new DynamicError("Argument is of wrong type", illegalArgumentException);
                throw dynamicError;
            }
            catch (NullPointerException nullPointerException) {
                DynamicError dynamicError = new DynamicError("Object is null");
                throw dynamicError;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (xPathContext.getController().isTracing() || xPathContext.getController().getConfiguration().isTraceExternalFunctions()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                DynamicError dynamicError = new DynamicError("Exception in extension function: " + invocationTargetException.getTargetException().toString(), throwable);
                throw dynamicError;
            }
        }
        if (this.theMethod instanceof Method) {
            Object object;
            Object object2;
            boolean bl;
            Method method = (Method)this.theMethod;
            boolean bl2 = Modifier.isStatic(method.getModifiers());
            Class[] classArray = method.getParameterTypes();
            boolean bl3 = classArray.length > 0 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? (class$net$sf$saxon$expr$XPathContext = ExtensionFunctionCall.class$("net.sf.saxon.expr.XPathContext")) : class$net$sf$saxon$expr$XPathContext) ? true : (bl = false);
            if (bl2) {
                object2 = null;
            } else {
                if (valueRepresentationArray.length == 0) {
                    DynamicError dynamicError = new DynamicError("Must supply an argument for an instance-level extension function");
                    throw dynamicError;
                }
                object = Value.asValue(valueRepresentationArray[0]);
                object2 = ((Value)object).convertToJava(this.theClass, xPathContext);
            }
            object = new Object[classArray.length];
            if (bl) {
                object[0] = xPathContext;
            }
            this.setupParams(valueRepresentationArray, (Object[])object, classArray, bl ? 1 : 0, bl2 ? 0 : 1, xPathContext);
            try {
                Object object3 = this.invokeMethod(method, object2, (Object[])object);
                if (method.getReturnType().toString().equals("void")) {
                    return EmptyIterator.getInstance();
                }
                return this.asIterator(object3, xPathContext);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DynamicError("Method access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DynamicError("Argument is of wrong type", illegalArgumentException);
            }
            catch (NullPointerException nullPointerException) {
                throw new DynamicError("Object is null", nullPointerException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (xPathContext.getController().isTracing() || xPathContext.getController().getConfiguration().isTraceExternalFunctions()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                throw new DynamicError("Exception in extension function " + invocationTargetException.getTargetException().toString(), throwable);
            }
        }
        if (this.theMethod instanceof Field) {
            Object object;
            Object object4;
            Field field = (Field)this.theMethod;
            boolean bl = Modifier.isStatic(field.getModifiers());
            if (bl) {
                object4 = null;
            } else {
                if (valueRepresentationArray.length == 0) {
                    DynamicError dynamicError = new DynamicError("Must supply an argument for an instance-level extension function");
                    throw dynamicError;
                }
                object = Value.asValue(valueRepresentationArray[0]);
                object4 = ((Value)object).convertToJava(this.theClass, xPathContext);
            }
            try {
                object = this.getField(field, object4);
                return this.asIterator(object, xPathContext);
            }
            catch (IllegalAccessException illegalAccessException) {
                DynamicError dynamicError = new DynamicError("Field access is illegal", illegalAccessException);
                throw dynamicError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DynamicError dynamicError = new DynamicError("Argument is of wrong type", illegalArgumentException);
                throw dynamicError;
            }
        }
        throw new AssertionError((Object)("property " + this.theMethod + " is neither constructor, method, nor field"));
    }

    private SequenceIterator asIterator(Object object, XPathContext xPathContext) throws XPathException {
        if (object == null) {
            return EmptyIterator.getInstance();
        }
        if (object instanceof SequenceIterator) {
            return (SequenceIterator)object;
        }
        if (object instanceof Value) {
            return ((Value)object).iterate(null);
        }
        if (object instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)object);
        }
        Value value = Value.convertJavaObjectToXPath(object, SequenceType.ANY_SEQUENCE, xPathContext.getController().getConfiguration());
        return value.iterate(xPathContext);
    }

    private void setupParams(ValueRepresentation[] valueRepresentationArray, Object[] objectArray, Class[] classArray, int n, int n2, XPathContext xPathContext) throws XPathException {
        int n3 = n;
        for (int i = n2; i < valueRepresentationArray.length; ++i) {
            valueRepresentationArray[i] = Value.asValue(valueRepresentationArray[i]);
            objectArray[n3] = ((Value)valueRepresentationArray[i]).convertToJava(classArray[n3], xPathContext);
            ++n3;
        }
    }

    public ItemType getItemType() {
        return this.convertClassToType(this.getReturnClass());
    }

    private ItemType convertClassToType(Class clazz) {
        if (clazz == null || clazz == (class$net$sf$saxon$value$Value == null ? (class$net$sf$saxon$value$Value = ExtensionFunctionCall.class$("net.sf.saxon.value.Value")) : class$net$sf$saxon$value$Value)) {
            return AnyItemType.getInstance();
        }
        if (clazz.toString().equals("void")) {
            return AnyItemType.getInstance();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = ExtensionFunctionCall.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = ExtensionFunctionCall.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return Type.STRING_TYPE;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExtensionFunctionCall.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == Boolean.TYPE || clazz == (class$net$sf$saxon$value$BooleanValue == null ? (class$net$sf$saxon$value$BooleanValue = ExtensionFunctionCall.class$("net.sf.saxon.value.BooleanValue")) : class$net$sf$saxon$value$BooleanValue)) {
            return Type.BOOLEAN_TYPE;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ExtensionFunctionCall.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE || clazz == (class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = ExtensionFunctionCall.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return Type.DOUBLE_TYPE;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ExtensionFunctionCall.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE || clazz == (class$net$sf$saxon$value$FloatValue == null ? (class$net$sf$saxon$value$FloatValue = ExtensionFunctionCall.class$("net.sf.saxon.value.FloatValue")) : class$net$sf$saxon$value$FloatValue)) {
            return Type.FLOAT_TYPE;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ExtensionFunctionCall.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE || clazz == (class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = ExtensionFunctionCall.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue) || clazz == (class$net$sf$saxon$value$BigIntegerValue == null ? (class$net$sf$saxon$value$BigIntegerValue = ExtensionFunctionCall.class$("net.sf.saxon.value.BigIntegerValue")) : class$net$sf$saxon$value$BigIntegerValue) || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ExtensionFunctionCall.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ExtensionFunctionCall.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ExtensionFunctionCall.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE) {
            return Type.INTEGER_TYPE;
        }
        if ((class$net$sf$saxon$value$Value == null ? (class$net$sf$saxon$value$Value = ExtensionFunctionCall.class$("net.sf.saxon.value.Value")) : class$net$sf$saxon$value$Value).isAssignableFrom(clazz) || (class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = ExtensionFunctionCall.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator).isAssignableFrom(clazz)) {
            return AnyItemType.getInstance();
        }
        Object object = this.config.getExternalObjectModels();
        for (int i = 0; i < object.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)object.get(i);
            if (!externalObjectModel.isRecognizedNodeClass(clazz)) continue;
            return AnyNodeTest.getInstance();
        }
        if ((class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = ExtensionFunctionCall.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo).isAssignableFrom(clazz) || (class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = ExtensionFunctionCall.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).isAssignableFrom(clazz)) {
            return AnyNodeTest.getInstance();
        }
        if ((class$java$util$List == null ? (class$java$util$List = ExtensionFunctionCall.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            return AnyItemType.getInstance();
        }
        if (clazz.isArray()) {
            object = clazz.getComponentType();
            return this.convertClassToType((Class)object);
        }
        return new ExternalObjectType(clazz);
    }

    public int computeCardinality() {
        Class clazz = this.getReturnClass();
        if (clazz == null) {
            return 57344;
        }
        if ((class$net$sf$saxon$value$Value == null ? (class$net$sf$saxon$value$Value = ExtensionFunctionCall.class$("net.sf.saxon.value.Value")) : class$net$sf$saxon$value$Value).isAssignableFrom(clazz) || (class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = ExtensionFunctionCall.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator).isAssignableFrom(clazz) || (class$java$util$List == null ? (class$java$util$List = ExtensionFunctionCall.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz) || (class$net$sf$saxon$value$Closure == null ? (class$net$sf$saxon$value$Closure = ExtensionFunctionCall.class$("net.sf.saxon.value.Closure")) : class$net$sf$saxon$value$Closure).isAssignableFrom(clazz) || (class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = ExtensionFunctionCall.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).isAssignableFrom(clazz) || clazz.isArray()) {
            return 57344;
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Void.TYPE)) {
                return 24576;
            }
            return 16384;
        }
        return 24576;
    }

    private Class getReturnClass() {
        if (this.theMethod instanceof Method) {
            return ((Method)this.theMethod).getReturnType();
        }
        if (this.theMethod instanceof Field) {
            return ((Field)this.theMethod).getType();
        }
        if (this.theMethod instanceof Constructor) {
            return this.theClass;
        }
        return null;
    }

    public boolean usesFocus() {
        if (this.theMethod instanceof Method) {
            Class<?>[] classArray = ((Method)this.theMethod).getParameterTypes();
            return classArray.length > 0 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? (class$net$sf$saxon$expr$XPathContext = ExtensionFunctionCall.class$("net.sf.saxon.expr.XPathContext")) : class$net$sf$saxon$expr$XPathContext);
        }
        return false;
    }

    protected Object invokeConstructor(Constructor constructor, Object[] objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(objectArray);
    }

    protected Object invokeMethod(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(object, objectArray);
    }

    protected Object getField(Field field, Object object) throws IllegalAccessException {
        return field.get(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.persistentMethod = new MethodRepresentation(this.theClass, this.theMethod);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.theMethod = this.persistentMethod.recoverAccessibleObject();
        }
        catch (Exception exception) {
            throw new IOException("Failed to read compiled representation of extension function call to " + this.theClass.getClass());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MethodRepresentation
    implements Serializable {
        private Class theClass;
        private byte category;
        private String name;
        private Class[] params;

        public MethodRepresentation(Class clazz, AccessibleObject accessibleObject) {
            this.theClass = clazz;
            if (accessibleObject instanceof Method) {
                this.category = 0;
                this.name = ((Method)accessibleObject).getName();
                this.params = ((Method)accessibleObject).getParameterTypes();
            } else if (accessibleObject instanceof Constructor) {
                this.category = 1;
                this.params = ((Constructor)accessibleObject).getParameterTypes();
            } else {
                this.category = (byte)2;
                this.name = ((Field)accessibleObject).getName();
            }
        }

        public AccessibleObject recoverAccessibleObject() throws NoSuchMethodException, NoSuchFieldException {
            switch (this.category) {
                case 0: {
                    return this.theClass.getMethod(this.name, this.params);
                }
                case 1: {
                    return this.theClass.getConstructor(this.params);
                }
                case 2: {
                    return this.theClass.getField(this.name);
                }
            }
            return null;
        }
    }
}

