/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Err;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.ProcInstParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class Extensions {
    private Extensions() {
    }

    public static void pauseTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(false);
    }

    public static String systemId(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:systemId() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSystemId();
        }
        return "";
    }

    public static int lineNumber(XPathContext xPathContext) {
        Item item = xPathContext.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getLineNumber();
        }
        return -1;
    }

    public static int lineNumber(NodeInfo nodeInfo) {
        return nodeInfo.getLineNumber();
    }

    public static DocumentInfo discardDocument(XPathContext xPathContext, DocumentInfo documentInfo) {
        return xPathContext.getController().getDocumentPool().discard(documentInfo);
    }

    public static boolean hasSameNodes(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        NodeInfo nodeInfo;
        NodeInfo nodeInfo2;
        SequenceIterator sequenceIterator3 = sequenceIterator;
        SequenceIterator sequenceIterator4 = sequenceIterator2;
        do {
            nodeInfo2 = (NodeInfo)sequenceIterator3.next();
            nodeInfo = (NodeInfo)sequenceIterator4.next();
            if (nodeInfo2 != null && nodeInfo != null) continue;
            return nodeInfo2 == nodeInfo;
        } while (nodeInfo2.isSameNodeInfo(nodeInfo));
        return false;
    }

    public static double sum(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = 0.0;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item2 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item2 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item2).convert(517, xPathContext);
                d += ((DoubleValue)serializable).getDoubleValue();
                continue;
            }
            serializable = new DynamicError("expression in saxon:sum() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContextMinor);
            throw serializable;
        }
        return d;
    }

    public static double max(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.NEGATIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item2 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item2 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item2).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() > d)) continue;
                d = ((DoubleValue)serializable).getDoubleValue();
                continue;
            }
            serializable = new DynamicError("expression in saxon:max() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContextMinor);
            throw serializable;
        }
        return d;
    }

    public static double min(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.POSITIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item2 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item2 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item2).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() < d)) continue;
                d = ((DoubleValue)serializable).getDoubleValue();
                continue;
            }
            serializable = new DynamicError("expression in saxon:min() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return d;
    }

    public static Value highest(SequenceIterator sequenceIterator) throws XPathException {
        return Math.highest(sequenceIterator);
    }

    public static SequenceIterator highest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.NEGATIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        Item item2 = null;
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item3 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item3 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item3).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() > d)) continue;
                d = ((DoubleValue)serializable).getDoubleValue();
                item2 = sequenceIterator.current();
                continue;
            }
            serializable = new DynamicError("expression in saxon:highest() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static Value lowest(SequenceIterator sequenceIterator) throws XPathException {
        return Math.lowest(sequenceIterator);
    }

    public static SequenceIterator lowest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.POSITIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        Item item2 = null;
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item3 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item3 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item3).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() < d)) continue;
                d = ((DoubleValue)serializable).getDoubleValue();
                item2 = sequenceIterator.current();
                continue;
            }
            serializable = new DynamicError("expression in saxon:lowest() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static SequenceIterator leading(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        return new FilterIterator.Leading(sequenceIterator, preparedExpression.expression, xPathContextMinor);
    }

    public static SequenceIterator after(XPathContext xPathContext, SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        Object object;
        Object object2;
        block4: {
            Object object3;
            object2 = null;
            GlobalOrderComparer globalOrderComparer = GlobalOrderComparer.getInstance();
            while (true) {
                if ((object = sequenceIterator2.next()) == null) {
                    if (object2 == null) {
                        return sequenceIterator;
                    }
                    break block4;
                }
                if (!(object instanceof NodeInfo)) break;
                object3 = (NodeInfo)object;
                if (object2 == null) {
                    object2 = object3;
                    continue;
                }
                if (globalOrderComparer.compare((NodeInfo)object3, (NodeInfo)object2) >= 0) continue;
                object2 = object3;
            }
            object3 = new DynamicError("Operand of after() contains an item that is not a node");
            ((DynamicError)object3).setXPathContext(xPathContext);
            throw object3;
        }
        object = new IdentityComparison(new ContextItemExpression(), 38, new SingletonNode((NodeInfo)object2));
        return new FilterIterator(sequenceIterator, (Expression)object, xPathContext);
    }

    public static SequenceIterator tokenize(String string) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        return new StringTokenIterator(string);
    }

    public static SequenceIterator tokenize(String string, String string2) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        return new StringTokenIterator(string, string2);
    }

    public static String path(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:path() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (item instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)item);
        }
        return "";
    }

    public static String typeAnnotation(XPathContext xPathContext, NodeInfo nodeInfo) {
        int n = nodeInfo.getTypeAnnotation();
        if (n == -1) {
            int n2 = nodeInfo.getNodeKind();
            if (n2 == 1 || n2 == 9) {
                return "untyped";
            }
            return "untypedAtomic";
        }
        SchemaType schemaType = xPathContext.getController().getConfiguration().getSchemaType(n & 0xFFFFF);
        if (schemaType == null) {
            return xPathContext.getController().getNamePool().getDisplayName(n);
        }
        return "type " + schemaType.getDescription();
    }

    public static XPathContext getContext(XPathContext xPathContext) {
        return xPathContext;
    }

    public static String getPseudoAttribute(XPathContext xPathContext, String string) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:getPseudoAttribute() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string2 = ProcInstParser.getPseudoAttribute(item.getStringValue(), string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static SecondsDurationValue dayTimeDurationFromSeconds(double d) throws XPathException {
        return SecondsDurationValue.fromSeconds(d);
    }

    public static MonthDurationValue yearMonthDurationFromMonths(double d) {
        return MonthDurationValue.fromMonths((int)d);
    }

    public static BigDecimal decimalDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        return bigDecimal.divide(bigDecimal2, n, 1);
    }

    public static List stringToUtf8(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(string.length() * 2);
        byte[] byArray = new byte[4];
        for (int i = 0; i < string.length(); ++i) {
            int n = UnicodeCharacterSet.getUTF8Encoding(string.charAt(i), i + 1 < string.length() ? string.charAt(i + 1) : (char)'\u0000', byArray);
            for (int j = 0; j < n; ++j) {
                arrayList.add(new Integer(0xFF & byArray[j]));
            }
        }
        return arrayList;
    }

    public static Base64BinaryValue octetsToBase64Binary(byte[] byArray) {
        return new Base64BinaryValue(byArray);
    }

    public static HexBinaryValue octetsToHexBinary(byte[] byArray) {
        return new HexBinaryValue(byArray);
    }

    public static byte[] base64BinaryToOctets(Base64BinaryValue base64BinaryValue) {
        return base64BinaryValue.getBinaryValue();
    }

    public static byte[] hexBinaryToOctets(HexBinaryValue hexBinaryValue) {
        return hexBinaryValue.getBinaryValue();
    }

    public static String base64BinaryToString(Base64BinaryValue base64BinaryValue, String string) throws Exception {
        byte[] byArray = base64BinaryValue.getBinaryValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        char[] cArray = new char[byArray.length];
        int n = inputStreamReader.read(cArray, 0, cArray.length);
        return new String(cArray, 0, n);
    }

    public static String hexBinaryToString(HexBinaryValue hexBinaryValue, String string) throws Exception {
        byte[] byArray = hexBinaryValue.getBinaryValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        char[] cArray = new char[byArray.length];
        int n = inputStreamReader.read(cArray, 0, cArray.length);
        return new String(cArray, 0, n);
    }

    public static NodeInfo namespaceNode(XPathContext xPathContext, String string, String string2) throws XPathException {
        if (string == null) {
            string = "";
        }
        if (!"".equals(string) && !XMLChar.isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Namespace prefix " + Err.wrap(string) + " is not a valid NCName");
            throw dynamicError;
        }
        if (string2 == null || "".equals(string2)) {
            DynamicError dynamicError = new DynamicError("URI of namespace node must not be empty");
            throw dynamicError;
        }
        NamePool namePool = xPathContext.getController().getNamePool();
        Orphan orphan = new Orphan(xPathContext.getController().getConfiguration());
        orphan.setNodeKind((short)13);
        orphan.setNameCode(namePool.allocate("", "", string));
        orphan.setStringValue(string2);
        return orphan;
    }
}

