/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FormatNumber
extends SystemFunction
implements XSLTFunction {
    private DecimalFormat decimalFormat = new DecimalFormat();
    private String previousFormat = "[null]";
    private DecimalFormatSymbols previousDFS = null;
    private NamespaceResolver nsContext = null;
    private String dfURI = null;
    private String dfLocalName = null;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (this.argument.length == 3 && this.argument[2] instanceof StringValue) {
            String string = ((StringValue)this.argument[2]).getStringValue();
            if (!Name.isQName(string)) {
                throw new StaticError("Decimal format name '" + string + "' is not a valid QName");
            }
            try {
                String[] stringArray = Name.getQNameParts(string);
                this.dfLocalName = stringArray[1];
                this.dfURI = staticContext.getURIForPrefix(stringArray[0]);
            }
            catch (QNameException qNameException) {
                throw new StaticError(qNameException.getMessage());
            }
        } else {
            this.nsContext = staticContext.getNamespaceResolver();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        DecimalFormatSymbols decimalFormatSymbols;
        int n = this.argument.length;
        Controller controller = xPathContext.getController();
        DecimalFormatManager decimalFormatManager = controller.getDecimalFormatManager();
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        String string = this.argument[1].evaluateItem(xPathContext).getStringValue();
        if (n == 2) {
            decimalFormatSymbols = decimalFormatManager.getDefaultDecimalFormat();
        } else {
            Object object;
            String string2 = this.dfURI;
            String string3 = this.dfLocalName;
            if (string3 == null) {
                object = this.argument[2].evaluateItem(xPathContext).getStringValue();
                if (!Name.isQName((String)object)) {
                    DynamicError dynamicError = new DynamicError("Decimal format name '" + (String)object + "' is not a valid QName");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("XTDE1280");
                    throw dynamicError;
                }
                try {
                    String[] stringArray = Name.getQNameParts((CharSequence)object);
                    string3 = stringArray[1];
                    string2 = this.nsContext.getURIForPrefix(stringArray[0], false);
                    if (string2 == null) {
                        DynamicError dynamicError = new DynamicError("Namespace prefix '" + stringArray[0] + "' has not been defined");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setErrorCode("XTDE1280");
                        throw dynamicError;
                    }
                }
                catch (QNameException qNameException) {
                    this.dynamicError("Invalid decimal format name. " + qNameException.getMessage(), "XTDE1280", xPathContext);
                }
            }
            if ((decimalFormatSymbols = decimalFormatManager.getNamedDecimalFormat(string2, string3)) == null) {
                object = new DynamicError("format-number function: decimal-format '" + string3 + "' is not defined");
                ((DynamicError)object).setXPathContext(xPathContext);
                ((XPathException)object).setErrorCode("XTDE1280");
                throw object;
            }
        }
        return this.formatNumber(numericValue.getDoubleValue(), string, decimalFormatSymbols, xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return new StringValue(this.evaluateAsString(xPathContext));
    }

    public synchronized String formatNumber(double d, String string, DecimalFormatSymbols decimalFormatSymbols, XPathContext xPathContext) throws XPathException {
        try {
            DecimalFormat decimalFormat = this.decimalFormat;
            if (decimalFormatSymbols != this.previousDFS || !string.equals(this.previousFormat)) {
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                decimalFormat.applyLocalizedPattern(string);
                this.previousDFS = decimalFormatSymbols;
                this.previousFormat = string;
            }
            return decimalFormat.format(d);
        }
        catch (Exception exception) {
            DynamicError dynamicError = new DynamicError("Unable to interpret format pattern " + string + "(" + exception + ")");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE1310");
            throw dynamicError;
        }
    }
}

