/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FormatNumber2
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext = null;
    private DecimalFormatSymbols decimalFormatSymbols = null;
    private transient String picture = null;
    private SubPicture[] subPictures = null;
    private boolean requireFixup = false;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (this.argument[1] instanceof StringValue) {
            this.picture = ((StringValue)this.argument[1]).getStringValue();
        }
        if (this.argument.length == 3) {
            if (this.argument[2] instanceof StringValue) {
                String string;
                String string2;
                Object object;
                String string3 = ((StringValue)this.argument[2]).getStringValue();
                try {
                    object = Name.getQNameParts(string3);
                    string2 = object[1];
                    string = staticContext.getURIForPrefix(object[0]);
                }
                catch (QNameException qNameException) {
                    throw new StaticError("Invalid decimal format name. " + qNameException.getMessage());
                }
                object = ((ExpressionContext)staticContext).getXSLStylesheet().getDecimalFormatManager();
                this.requireFixup = true;
                ((DecimalFormatManager)object).registerUsage(string, string2, this);
            } else {
                this.nsContext = staticContext.getNamespaceResolver();
            }
        } else if (staticContext instanceof ExpressionContext) {
            DecimalFormatManager decimalFormatManager = ((ExpressionContext)staticContext).getXSLStylesheet().getDecimalFormatManager();
            decimalFormatManager.registerUsage("", "", this);
        }
    }

    public void fixup(DecimalFormatSymbols decimalFormatSymbols) {
        this.requireFixup = false;
        this.decimalFormatSymbols = decimalFormatSymbols;
        if (this.picture != null) {
            try {
                this.subPictures = this.getSubPictures(this.picture, decimalFormatSymbols);
            }
            catch (XPathException xPathException) {
                this.subPictures = null;
            }
        }
    }

    private SubPicture[] getSubPictures(String string, DecimalFormatSymbols decimalFormatSymbols) throws XPathException {
        SubPicture[] subPictureArray = new SubPicture[2];
        if (string.length() == 0) {
            DynamicError dynamicError = new DynamicError("format-number() picture is zero-length");
            dynamicError.setErrorCode("XTDE1310");
            throw dynamicError;
        }
        int n = string.indexOf(decimalFormatSymbols.getPatternSeparator());
        if (n < 0) {
            subPictureArray[0] = new SubPicture(string, decimalFormatSymbols);
            subPictureArray[1] = null;
        } else {
            if (n == string.length() - 1) {
                this.grumble("second subpicture is zero-length");
            }
            if (string.indexOf(decimalFormatSymbols.getPatternSeparator(), n + 1) >= 0) {
                this.grumble("more than one pattern separator");
            }
            if (n == 0) {
                this.grumble("first subpicture is zero-length");
            }
            subPictureArray[0] = new SubPicture(string.substring(0, n), decimalFormatSymbols);
            subPictureArray[1] = new SubPicture(string.substring(n + 1), decimalFormatSymbols);
        }
        return subPictureArray;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        return this;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        String string;
        SubPicture[] subPictureArray;
        int n = this.argument.length;
        Controller controller = xPathContext.getController();
        DecimalFormatSymbols decimalFormatSymbols = this.decimalFormatSymbols;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            atomicValue = DoubleValue.NaN;
        }
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        if (decimalFormatSymbols == null) {
            if (this.requireFixup) {
                this.dynamicError("Unknown decimal format name", "XTDE1280", xPathContext);
                return null;
            }
            subPictureArray = controller.getDecimalFormatManager();
            if (n == 2) {
                decimalFormatSymbols = subPictureArray.getDefaultDecimalFormat();
            } else {
                string = this.argument[2].evaluateItem(xPathContext).getStringValue();
                try {
                    String[] stringArray = Name.getQNameParts(string);
                    String string2 = stringArray[1];
                    String string3 = this.nsContext.getURIForPrefix(stringArray[0], false);
                    if (string3 == null) {
                        this.dynamicError("Namespace prefix '" + stringArray[0] + "' has not been defined", "XTDE1280", xPathContext);
                        return null;
                    }
                    decimalFormatSymbols = subPictureArray.getNamedDecimalFormat(string3, string2);
                    if (decimalFormatSymbols == null) {
                        this.dynamicError("format-number function: decimal-format '" + string2 + "' is not defined", "XTDE1280", xPathContext);
                        return null;
                    }
                }
                catch (QNameException qNameException) {
                    this.dynamicError("Invalid decimal format name. " + qNameException.getMessage(), "XTDE1280", xPathContext);
                }
            }
        }
        if ((subPictureArray = this.subPictures) == null) {
            string = this.argument[1].evaluateItem(xPathContext).getStringValue();
            subPictureArray = this.getSubPictures(string, decimalFormatSymbols);
        }
        return ((Object)this.formatNumber(numericValue, subPictureArray, decimalFormatSymbols)).toString();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return new StringValue(this.evaluateAsString(xPathContext));
    }

    private CharSequence formatNumber(NumericValue numericValue, SubPicture[] subPictureArray, DecimalFormatSymbols decimalFormatSymbols) {
        SubPicture subPicture;
        NumericValue numericValue2 = numericValue;
        String string = "";
        if (numericValue.signum() < 0.0) {
            numericValue2 = numericValue.negate();
            if (subPictureArray[1] == null) {
                subPicture = subPictureArray[0];
                string = "" + decimalFormatSymbols.getMinusSign();
            } else {
                subPicture = subPictureArray[1];
            }
        } else {
            subPicture = subPictureArray[0];
        }
        return subPicture.format(numericValue2, decimalFormatSymbols, string);
    }

    private void grumble(String string) throws XPathException {
        this.dynamicError("format-number picture: " + string, "XTDE1310", null);
    }

    private class SubPicture
    implements Serializable {
        int minWholePartSize = 0;
        int maxWholePartSize = 0;
        int minFractionPartSize = 0;
        int maxFractionPartSize = 0;
        boolean isPercent = false;
        boolean isPerMille = false;
        String prefix = "";
        String suffix = "";
        int[] wholePartGroupingPositions = null;
        int[] fractionalPartGroupingPositions = null;

        public SubPicture(String string, DecimalFormatSymbols decimalFormatSymbols) throws XPathException {
            char c;
            int n;
            int n2;
            char c2 = decimalFormatSymbols.getPercent();
            char c3 = decimalFormatSymbols.getPerMill();
            char c4 = decimalFormatSymbols.getDecimalSeparator();
            char c5 = decimalFormatSymbols.getGroupingSeparator();
            char c6 = decimalFormatSymbols.getDigit();
            char c7 = decimalFormatSymbols.getZeroDigit();
            ArrayList<Integer> arrayList = null;
            ArrayList<Integer> arrayList2 = null;
            boolean bl = false;
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) != c6 && string.charAt(n2) != c7) continue;
                bl = true;
                break;
            }
            if (!bl) {
                FormatNumber2.this.grumble("subpicture contains no digit or zero-digit sign");
            }
            n2 = 0;
            block30: for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c == c2 || c == c3) {
                    if (this.isPercent || this.isPerMille) {
                        FormatNumber2.this.grumble("Cannot have more than one percent or per-mille character in a sub-picture");
                    }
                    this.isPercent = c == c2;
                    this.isPerMille = c == c3;
                    switch (n2) {
                        case 0: {
                            this.prefix = this.prefix + c;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            n2 = 5;
                            this.suffix = this.suffix + c;
                        }
                    }
                    continue;
                }
                if (c == c6) {
                    switch (n2) {
                        case 0: 
                        case 1: {
                            n2 = 1;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 2: {
                            FormatNumber2.this.grumble("Digit sign must not appear after a zero-digit sign in the integer part of a sub-picture");
                            break;
                        }
                        case 3: 
                        case 4: {
                            n2 = 4;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (c == c7) {
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n2 = 2;
                            ++this.minWholePartSize;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 3: {
                            ++this.minFractionPartSize;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 4: {
                            FormatNumber2.this.grumble("Zero digit sign must not appear after a digit sign in the fractional part of a sub-picture");
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (c == c4) {
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            FormatNumber2.this.grumble("There must only be one decimal separator in a sub-picture");
                        }
                    }
                    continue;
                }
                if (c == c5) {
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Integer>(3);
                            }
                            arrayList.add(new Integer(this.maxWholePartSize));
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (this.maxFractionPartSize == 0) {
                                FormatNumber2.this.grumble("Grouping separator cannot be adjacent to decimal separator");
                            }
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<Integer>(3);
                            }
                            arrayList2.add(new Integer(this.maxFractionPartSize));
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Grouping separator found in suffix of sub-picture");
                        }
                    }
                    continue;
                }
                switch (n2) {
                    case 0: {
                        this.prefix = this.prefix + c;
                        continue block30;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 5;
                        this.suffix = this.suffix + c;
                    }
                }
            }
            if (arrayList != null) {
                n = arrayList.size();
                this.wholePartGroupingPositions = new int[n];
                for (c = '\u0000'; c < n; ++c) {
                    this.wholePartGroupingPositions[c] = this.maxWholePartSize - (Integer)arrayList.get(n - c - 1);
                }
                if (n > 1) {
                    c = '\u0001';
                    int n3 = this.wholePartGroupingPositions[0];
                    for (int i = 1; i < n; ++i) {
                        if (this.wholePartGroupingPositions[i] == i * n3) continue;
                        c = '\u0000';
                        break;
                    }
                    if (c != '\u0000') {
                        this.wholePartGroupingPositions = new int[1];
                        this.wholePartGroupingPositions[0] = n3;
                    }
                }
                if (this.wholePartGroupingPositions[0] == 0) {
                    FormatNumber2.this.grumble("Cannot have a grouping separator adjacent to the decimal separator");
                }
            }
            if (arrayList2 != null) {
                n = arrayList2.size();
                this.fractionalPartGroupingPositions = new int[n];
                for (c = '\u0000'; c < n; ++c) {
                    this.fractionalPartGroupingPositions[c] = (Integer)arrayList2.get(c);
                }
            }
        }

        public CharSequence format(NumericValue numericValue, DecimalFormatSymbols decimalFormatSymbols, String string) {
            int n;
            int n2;
            if (numericValue.isNaN()) {
                return this.prefix + decimalFormatSymbols.getNaN() + this.suffix;
            }
            if (numericValue instanceof DoubleValue && Double.isInfinite(numericValue.getDoubleValue())) {
                return this.prefix + string + decimalFormatSymbols.getInfinity() + this.suffix;
            }
            if (numericValue instanceof FloatValue && Double.isInfinite(numericValue.getDoubleValue())) {
                return this.prefix + string + decimalFormatSymbols.getInfinity() + this.suffix;
            }
            int n3 = 1;
            if (this.isPercent) {
                n3 = 100;
            } else if (this.isPerMille) {
                n3 = 1000;
            }
            if (n3 != 1) {
                try {
                    numericValue = numericValue.arithmetic(17, new IntegerValue(n3), null);
                }
                catch (XPathException xPathException) {
                    numericValue = new DoubleValue(numericValue.getDoubleValue() * (double)n3);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(20);
            if (numericValue instanceof DoubleValue || numericValue instanceof FloatValue) {
                this.formatDouble(numericValue.getDoubleValue(), stringBuffer);
            } else if (numericValue instanceof IntegerValue || numericValue instanceof BigIntegerValue) {
                this.formatInteger(numericValue, stringBuffer);
            } else if (numericValue instanceof DecimalValue) {
                this.formatDecimal((DecimalValue)numericValue, stringBuffer);
            }
            int n4 = stringBuffer.indexOf(".");
            if (n4 == -1) {
                n4 = stringBuffer.length();
            } else {
                if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                    stringBuffer.setCharAt(n4, decimalFormatSymbols.getDecimalSeparator());
                }
                if (this.maxFractionPartSize == 0) {
                    stringBuffer.deleteCharAt(n4);
                }
            }
            if (decimalFormatSymbols.getZeroDigit() != '0') {
                n2 = decimalFormatSymbols.getZeroDigit();
                for (n = 0; n < stringBuffer.length(); ++n) {
                    char c = stringBuffer.charAt(n);
                    if (c < '0' || c > '9') continue;
                    stringBuffer.setCharAt(n, (char)(c - 48 + n2));
                }
            }
            if (this.wholePartGroupingPositions != null) {
                if (this.wholePartGroupingPositions.length == 1) {
                    n2 = this.wholePartGroupingPositions[0];
                    for (n = n4 - n2; n > 0; n -= n2) {
                        stringBuffer.insert(n, decimalFormatSymbols.getGroupingSeparator());
                    }
                } else {
                    for (n2 = 0; n2 < this.wholePartGroupingPositions.length; ++n2) {
                        n = n4 - this.wholePartGroupingPositions[n2];
                        if (n <= 0) continue;
                        stringBuffer.insert(n, decimalFormatSymbols.getGroupingSeparator());
                    }
                }
            }
            if (this.fractionalPartGroupingPositions != null) {
                for (n2 = 0; n2 < this.fractionalPartGroupingPositions.length && (n = n4 + 1 + this.fractionalPartGroupingPositions[n2] + n2) < stringBuffer.length() - 1; ++n2) {
                    stringBuffer.insert(n, decimalFormatSymbols.getGroupingSeparator());
                }
            }
            stringBuffer.insert(0, this.prefix);
            stringBuffer.insert(0, string);
            stringBuffer.append(this.suffix);
            return stringBuffer;
        }

        private void formatDecimal(DecimalValue decimalValue, StringBuffer stringBuffer) {
            int n;
            int n2;
            BigDecimal bigDecimal = decimalValue.getValue();
            bigDecimal = bigDecimal.setScale(this.maxFractionPartSize, 6);
            stringBuffer.append(bigDecimal.toString());
            int n3 = stringBuffer.indexOf(".");
            if (n3 >= 0) {
                for (n2 = this.maxFractionPartSize - this.minFractionPartSize; n2 > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '0'; --n2) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                n = n3;
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            } else {
                n = stringBuffer.length();
            }
            for (n2 = 0; n2 < this.minWholePartSize - n; ++n2) {
                stringBuffer.insert(0, '0');
            }
        }

        private void formatInteger(NumericValue numericValue, StringBuffer stringBuffer) {
            int n;
            stringBuffer.append(numericValue.toString());
            for (n = 0; n < this.minWholePartSize - stringBuffer.length(); ++n) {
                stringBuffer.insert(0, '0');
            }
            stringBuffer.append('.');
            for (n = 0; n < this.minFractionPartSize; ++n) {
                stringBuffer.append('0');
            }
        }

        private void formatDouble(double d, StringBuffer stringBuffer) {
            double d2 = d;
            if (this.maxFractionPartSize != 0) {
                d2 *= Math.pow(10.0, this.maxFractionPartSize);
            }
            if (Math.abs(d2) > 9.223372036854776E18) {
                long l = Double.doubleToLongBits(d);
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                int n = (int)((l & 0x7FF0000000000000L) >> 52) - 1023 - 52;
                long l2 = l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                BigInteger bigInteger = BigInteger.valueOf(l2);
                bigInteger = bigInteger.multiply(BigInteger.valueOf(2L).pow(n));
                if (bl) {
                    stringBuffer.append('-');
                }
                stringBuffer.append(bigInteger.toString());
                stringBuffer.append('.');
            } else {
                long l = (long)d2;
                double d3 = d2 - (double)l;
                if (d3 > 0.5) {
                    ++l;
                } else if (d3 == 0.5 && (l & 1L) == 1L) {
                    ++l;
                }
                String string = "" + l;
                int n = string.length() - this.maxFractionPartSize;
                if (n > 0) {
                    stringBuffer.append(string.substring(0, n));
                }
                int n2 = stringBuffer.length();
                stringBuffer.append('.');
                while (n < 0) {
                    stringBuffer.append('0');
                    ++n;
                }
                stringBuffer.append(string.substring(n));
                while (n2 < this.minWholePartSize) {
                    stringBuffer.insert(0, '0');
                    ++n2;
                }
                while (n2 > this.maxWholePartSize && stringBuffer.charAt(0) == '0') {
                    stringBuffer.deleteCharAt(0);
                    --n2;
                }
                for (int i = stringBuffer.length() - n2 - 1; i > this.minFractionPartSize && stringBuffer.charAt(stringBuffer.length() - 1) == '0'; --i) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
            }
        }
    }
}

