/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class Lang
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo;
        if (this.argument.length > 1) {
            nodeInfo = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        } else {
            Item item = xPathContext.getContextItem();
            if (item == null) {
                DynamicError dynamicError = new DynamicError("The context item is undefined");
                dynamicError.setErrorCode("FONC0001");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            if (!(item instanceof NodeInfo)) {
                DynamicError dynamicError = new DynamicError("The context item is not a node");
                dynamicError.setErrorCode("FOTY0011");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            nodeInfo = (NodeInfo)item;
        }
        boolean bl = this.isLang(this.argument[0].evaluateItem(xPathContext).getStringValue(), nodeInfo);
        return BooleanValue.get(bl);
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    private boolean isLang(String string, NodeInfo nodeInfo) {
        String string2 = null;
        NodeInfo nodeInfo2 = nodeInfo;
        while (nodeInfo2 != null && (string2 = nodeInfo2.getAttributeValue(387)) == null) {
            if ((nodeInfo2 = nodeInfo2.getParent()) != null) continue;
            return false;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n = string2.indexOf("-");
        if (n < 0) {
            return false;
        }
        return string.equalsIgnoreCase(string2 = string2.substring(0, n));
    }
}

