/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class StringJoin
extends SystemFunction {
    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.analyze(staticContext, itemType);
        if (expression instanceof StringJoin) {
            return ((StringJoin)expression).simplifySingleton(staticContext);
        }
        return expression;
    }

    private Expression simplifySingleton(StaticContext staticContext) {
        int n = this.argument[0].getCardinality();
        if (!Cardinality.allowsMany(n)) {
            if (Cardinality.allowsZero(n)) {
                FunctionCall functionCall = SystemFunction.makeSystemFunction("string", 1, staticContext.getNamePool());
                Expression[] expressionArray = new Expression[]{this.argument[0]};
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
            return this.argument[0];
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        String string = item.getStringValue();
        item = sequenceIterator.next();
        if (item == null) {
            return new StringValue(string);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(1024);
        fastStringBuffer.append(string);
        CharSequence charSequence = this.argument[1].evaluateItem(xPathContext).getStringValueCS();
        fastStringBuffer.append(charSequence);
        fastStringBuffer.append(item.getStringValueCS());
        while ((item = sequenceIterator.next()) != null) {
            fastStringBuffer.append(charSequence);
            fastStringBuffer.append(item.getStringValueCS());
        }
        return new StringValue(fastStringBuffer.condense());
    }
}

