/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.PositionIterator;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class Subsequence
extends SystemFunction {
    public ItemType getItemType() {
        return this.argument[0].getItemType();
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        if (this.argument.length == 2) {
            long l;
            if (numericValue instanceof IntegerValue) {
                l = ((IntegerValue)numericValue).longValue();
                if (l <= 1L) {
                    return sequenceIterator;
                }
            } else {
                if ((numericValue = numericValue.round()).compareTo(IntegerValue.PLUS_ONE) <= 0) {
                    return sequenceIterator;
                }
                if (numericValue.compareTo(IntegerValue.MAX_LONG) > 0) {
                    return EmptyIterator.getInstance();
                }
                if (numericValue.isNaN()) {
                    return EmptyIterator.getInstance();
                }
                l = numericValue.longValue();
            }
            if (l > Integer.MAX_VALUE) {
                return EmptyIterator.getInstance();
            }
            return new TailExpression.TailIterator(sequenceIterator, (int)l);
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        NumericValue numericValue2 = (NumericValue)atomicValue2.getPrimitiveValue();
        if (numericValue instanceof IntegerValue && numericValue2 instanceof IntegerValue) {
            long l = ((IntegerValue)numericValue).longValue();
            if (l > Integer.MAX_VALUE) {
                return EmptyIterator.getInstance();
            }
            long l2 = ((IntegerValue)numericValue2).longValue();
            if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            if (l2 < 1L) {
                return EmptyIterator.getInstance();
            }
            long l3 = l + l2 - 1L;
            if (l3 < 1L) {
                return EmptyIterator.getInstance();
            }
            int n = l < 1L ? 1 : (int)l;
            return PositionIterator.make(sequenceIterator, n, (int)l3);
        }
        if (numericValue.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if (numericValue.compareTo(IntegerValue.MAX_LONG) > 0) {
            return EmptyIterator.getInstance();
        }
        numericValue = numericValue.round();
        if (numericValue2.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if ((numericValue2 = numericValue2.round()).compareTo(IntegerValue.ZERO) <= 0) {
            return EmptyIterator.getInstance();
        }
        NumericValue numericValue3 = numericValue.arithmetic(15, numericValue2, xPathContext).arithmetic(16, IntegerValue.PLUS_ONE, xPathContext);
        if (numericValue3.compareTo(IntegerValue.ZERO) <= 0) {
            return EmptyIterator.getInstance();
        }
        long l = numericValue.compareTo(IntegerValue.PLUS_ONE) <= 0 ? 1L : numericValue.longValue();
        if (l > Integer.MAX_VALUE) {
            return EmptyIterator.getInstance();
        }
        long l4 = numericValue3.compareTo(IntegerValue.MAX_LONG) >= 0 ? Integer.MAX_VALUE : numericValue3.longValue();
        return PositionIterator.make(sequenceIterator, (int)l, (int)l4);
    }
}

