/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class SystemFunctionLibrary
implements FunctionLibrary {
    private int functionSet;
    public static final int XPATH_ONLY = 0;
    public static final int FULL_XSLT = 1;
    public static final int USE_WHEN = 2;

    public SystemFunctionLibrary(int n) {
        this.functionSet = n;
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (string.equals("http://www.w3.org/2005/04/xpath-functions")) {
            StandardFunction.Entry entry = StandardFunction.getFunction(string2, n2);
            if (entry == null) {
                return false;
            }
            return n2 == -1 || n2 >= entry.minArguments && n2 <= entry.maxArguments;
        }
        return false;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        if (string.equals("http://www.w3.org/2005/04/xpath-functions")) {
            SystemFunction systemFunction;
            StandardFunction.Entry entry = StandardFunction.getFunction(string2, expressionArray.length);
            if (entry == null) {
                StaticError staticError = new StaticError("Unknown system function " + string2 + "()");
                staticError.setErrorCode("XPST0017");
                throw staticError;
            }
            Class clazz = entry.implementationClass;
            try {
                systemFunction = (SystemFunction)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Failed to load system function: " + exception.getMessage()));
            }
            systemFunction.setDetails(entry);
            systemFunction.setFunctionNameCode(n);
            if (this.functionSet != 1 && (systemFunction instanceof XSLTFunction || systemFunction instanceof NamePart && entry.opcode == 3)) {
                if (this.functionSet == 0) {
                    StaticError staticError = new StaticError("Cannot use the " + string2 + "() function in a non-XSLT context");
                    staticError.setErrorCode("XPST0017");
                    throw staticError;
                }
                if (this.functionSet == 2 && !(systemFunction instanceof Available) && !(systemFunction instanceof SystemProperty)) {
                    StaticError staticError = new StaticError("Cannot use the " + string2 + "() function in a use-when expression");
                    staticError.setErrorCode("XPST0017");
                    throw staticError;
                }
            }
            systemFunction.setArguments(expressionArray);
            this.checkArgumentCount(expressionArray.length, entry.minArguments, entry.maxArguments, string2);
            return systemFunction;
        }
        return null;
    }

    private int checkArgumentCount(int n, int n2, int n3, String string) throws XPathException {
        if (n2 == n3 && n != n2) {
            throw new StaticError("Function " + Err.wrap(string, 3) + " must have " + n2 + SystemFunctionLibrary.pluralArguments(n2));
        }
        if (n < n2) {
            throw new StaticError("Function " + Err.wrap(string, 3) + " must have at least " + n2 + SystemFunctionLibrary.pluralArguments(n2));
        }
        if (n > n3) {
            throw new StaticError("Function " + Err.wrap(string, 3) + " must have no more than " + n3 + SystemFunctionLibrary.pluralArguments(n3));
        }
        return n;
    }

    private static String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }
}

