/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Tokenize
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = this.simplifyArguments(staticContext);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 2);
            if (this.regexp != null && this.regexp.matcher("").matches()) {
                StaticError staticError = new StaticError("The regular expression must not be one that matches a zero-length string");
                staticError.setErrorCode("FORX0003");
                throw staticError;
            }
        }
        return expression;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return EmptyIterator.getInstance();
        }
        CharSequence charSequence = atomicValue.getStringValueCS();
        if (charSequence.length() == 0) {
            return EmptyIterator.getInstance();
        }
        Pattern pattern = this.regexp;
        if (pattern == null) {
            CharSequence charSequence2;
            atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            CharSequence charSequence3 = atomicValue.getStringValueCS();
            if (this.argument.length == 2) {
                charSequence2 = "";
            } else {
                atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
                charSequence2 = atomicValue.getStringValueCS();
            }
            try {
                String string = RegexTranslator.translate(charSequence3, true);
                pattern = Pattern.compile(string, Matches.setFlags(charSequence2));
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                throw new DynamicError(regexSyntaxException);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new DynamicError(patternSyntaxException);
            }
            if (pattern.matcher("").matches()) {
                throw new StaticError("The regular expression must not be one that matches a zero-length string");
            }
        }
        return new TokenIterator(charSequence, pattern);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String[] stringArray2 = Pattern.compile(stringArray[1]).split(string, 0);
        System.out.println("results");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println('[' + stringArray2[i] + ']');
        }
        System.out.println("end results");
    }

    public static class TokenIterator
    implements SequenceIterator {
        private CharSequence input;
        private Pattern pattern;
        private Matcher matcher;
        private CharSequence current;
        private int position = 0;
        private int prevEnd = 0;

        public TokenIterator(CharSequence charSequence, Pattern pattern) {
            this.input = charSequence;
            this.pattern = pattern;
            this.matcher = pattern.matcher(charSequence);
            this.prevEnd = 0;
        }

        public Item next() {
            if (this.prevEnd < 0) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (this.matcher.find()) {
                this.current = this.input.subSequence(this.prevEnd, this.matcher.start());
                this.prevEnd = this.matcher.end();
            } else {
                this.current = this.input.subSequence(this.prevEnd, this.input.length());
                this.prevEnd = -1;
            }
            ++this.position;
            return new StringValue(this.current);
        }

        public Item current() {
            return this.current == null ? null : new StringValue(this.current);
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() {
            return new TokenIterator(this.input, this.pattern);
        }
    }
}

