/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class Block
extends Instruction {
    private Expression[] children;

    public static Block makeBlock(Expression expression, Expression expression2) {
        if (expression instanceof Block || expression2 instanceof Block) {
            Iterator iterator = expression instanceof Block ? expression.iterateSubExpressions() : new MonoIterator(expression);
            Iterator iterator2 = expression2 instanceof Block ? expression2.iterateSubExpressions() : new MonoIterator(expression2);
            ArrayList arrayList = new ArrayList(10);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
            Expression[] expressionArray = new Expression[arrayList.size()];
            expressionArray = arrayList.toArray(expressionArray);
            Block block = new Block();
            block.setChildren(expressionArray);
            return block;
        }
        Expression[] expressionArray = new Expression[]{expression, expression2};
        Block block = new Block();
        block.setChildren(expressionArray);
        return block;
    }

    public void setChildren(Expression[] expressionArray) {
        if (expressionArray == null || expressionArray.length == 0) {
            this.children = null;
        } else {
            this.children = expressionArray;
            for (int i = 0; i < expressionArray.length; ++i) {
                this.adoptChildExpression(expressionArray[i]);
            }
        }
    }

    public Expression[] getChildren() {
        return this.children;
    }

    public Iterator iterateSubExpressions() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Arrays.asList(this.children).iterator();
    }

    public final ItemType getItemType() {
        if (this.children == null || this.children.length == 0) {
            return NoNodeTest.getInstance();
        }
        ItemType itemType = this.children[0].getItemType();
        for (int i = 1; i < this.children.length; ++i) {
            if (!((itemType = Type.getCommonSuperType(itemType, this.children[i].getItemType())) instanceof AnyItemType)) continue;
            return itemType;
        }
        return itemType;
    }

    public final int getCardinality() {
        if (this.children == null || this.children.length == 0) {
            return 8192;
        }
        int n = this.children[0].getCardinality();
        for (int i = 1; i < this.children.length && (n = Cardinality.add(n, this.children[i].getCardinality())) != 57344; ++i) {
        }
        return n;
    }

    public final boolean createsNewNodes() {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            int n = this.children[i].getSpecialProperties();
            if ((n & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        boolean bl = true;
        boolean bl2 = false;
        if (this.children != null) {
            int n;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = this.children[i].simplify(staticContext);
                if (!(this.children[i] instanceof Item)) {
                    bl = false;
                }
                if (this.children[i] instanceof Block) {
                    bl2 = true;
                    continue;
                }
                if (!(this.children[i] instanceof EmptySequence)) continue;
                bl2 = true;
            }
            if (this.children.length == 1) {
                return this.getChildren()[0];
            }
            if (this.children.length == 0) {
                return EmptySequence.getInstance();
            }
            if (bl2) {
                ArrayList arrayList = new ArrayList(this.children.length * 2);
                this.flatten(arrayList);
                this.children = new Expression[arrayList.size()];
                for (n = 0; n < this.children.length; ++n) {
                    this.children[n] = (Expression)arrayList.get(n);
                    this.adoptChildExpression(this.children[n]);
                }
            }
            if (bl) {
                Item[] itemArray = new Item[this.children.length];
                for (n = 0; n < this.children.length; ++n) {
                    itemArray[n] = (Item)((Object)this.children[n]);
                }
                return new SequenceExtent(itemArray);
            }
        } else {
            return EmptySequence.getInstance();
        }
        return this;
    }

    private void flatten(List list) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] instanceof Block) {
                ((Block)this.children[i]).flatten(list);
                continue;
            }
            if (this.children[i] instanceof EmptySequence) continue;
            list.add(this.children[i]);
        }
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        boolean bl = false;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = this.children[i].analyze(staticContext, itemType);
                if (this.children[i] instanceof Block) {
                    bl = true;
                    continue;
                }
                if (!(this.children[i] instanceof EmptySequence)) continue;
                bl = true;
            }
        }
        if (bl) {
            ArrayList arrayList = new ArrayList(this.children.length * 2);
            this.flatten(arrayList);
            this.children = new Expression[arrayList.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = (Expression)arrayList.get(i);
                this.adoptChildExpression(this.children[i]);
            }
        }
        if (this.children.length == 0) {
            return EmptySequence.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0];
        }
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = this.children[i].promote(promotionOffer);
            }
        }
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].checkPermittedContents(schemaType, staticContext, false);
            }
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        if (this.children != null) {
            Block.displayChildren(this.children, n + 1, namePool, printStream);
        }
    }

    public static void displayChildren(Expression[] expressionArray, int n, NamePool namePool, PrintStream printStream) {
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i].display(n + 1, namePool, printStream);
            }
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        if (this.children == null) {
            return null;
        }
        TailCall tailCall = null;
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (this.children[i] instanceof Instruction) {
                    tailCall = ((Instruction)this.children[i]).processLeavingTail(xPathContext);
                    continue;
                }
                this.children[i].process(xPathContext);
                tailCall = null;
                continue;
            }
            catch (DynamicError dynamicError) {
                if (dynamicError.getXPathContext() == null) {
                    dynamicError.setXPathContext(xPathContext);
                }
                if (dynamicError.getLocator() == null) {
                    dynamicError.setLocator(ExpressionTool.getLocator(this.children[i]));
                }
                throw dynamicError;
            }
        }
        return tailCall;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterate(xPathContext);
        }
        return new BlockIterator(xPathContext);
    }

    private class BlockIterator
    implements SequenceIterator {
        private int i = 0;
        private SequenceIterator child;
        private XPathContext context;
        private Item current;
        private int position = 0;

        public BlockIterator(XPathContext xPathContext) {
            this.context = xPathContext;
        }

        public Item next() throws XPathException {
            if (this.position < 0) {
                return null;
            }
            do {
                if (this.child == null) {
                    this.child = Block.this.children[this.i++].iterate(this.context);
                }
                this.current = this.child.next();
                if (this.current != null) {
                    ++this.position;
                    return this.current;
                }
                this.child = null;
            } while (this.i < Block.this.children.length);
            this.current = null;
            this.position = -1;
            return null;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new BlockIterator(this.context);
        }
    }
}

