/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;

    public Choose(Expression[] expressionArray, Expression[] expressionArray2) {
        int n;
        this.conditions = expressionArray;
        this.actions = expressionArray2;
        for (n = 0; n < expressionArray.length; ++n) {
            this.adoptChildExpression(expressionArray[n]);
        }
        for (n = 0; n < expressionArray2.length; ++n) {
            this.adoptChildExpression(expressionArray2[n]);
        }
    }

    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 150 : 135;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        int n;
        for (n = 0; n < this.conditions.length; ++n) {
            this.conditions[n] = this.conditions[n].simplify(staticContext);
        }
        for (n = 0; n < this.actions.length; ++n) {
            this.actions[n] = this.actions[n].simplify(staticContext);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        for (n = 0; n < this.conditions.length; ++n) {
            this.conditions[n] = this.conditions[n].analyze(staticContext, itemType);
        }
        for (n = 0; n < this.actions.length; ++n) {
            this.actions[n] = this.actions[n].analyze(staticContext, itemType);
        }
        return this;
    }

    public ItemType getItemType() {
        ItemType itemType = this.actions[0].getItemType();
        for (int i = 1; i < this.actions.length; ++i) {
            itemType = Type.getCommonSuperType(itemType, this.actions[i].getItemType());
        }
        return itemType;
    }

    public final boolean createsNewNodes() {
        for (int i = 0; i < this.actions.length; ++i) {
            int n = this.actions[i].getSpecialProperties();
            if ((n & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public Iterator iterateSubExpressions() {
        int n;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.conditions.length + this.actions.length);
        for (n = 0; n < this.conditions.length; ++n) {
            arrayList.add(this.conditions[n]);
        }
        for (n = 0; n < this.actions.length; ++n) {
            arrayList.add(this.actions[n]);
        }
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (promotionOffer.action == 13 || promotionOffer.action == 12) {
            int n;
            for (n = 0; n < this.conditions.length; ++n) {
                this.conditions[n] = this.conditions[n].promote(promotionOffer);
            }
            for (n = 0; n < this.actions.length; ++n) {
                this.actions[n] = this.actions[n].promote(promotionOffer);
            }
        } else {
            this.conditions[0] = this.conditions[0].promote(promotionOffer);
        }
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].checkPermittedContents(schemaType, staticContext, bl);
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        for (int i = 0; i < this.conditions.length; ++i) {
            printStream.println(ExpressionTool.indent(n) + (i == 0 ? "if" : "else if"));
            this.conditions[i].display(n + 1, namePool, printStream);
            printStream.println(ExpressionTool.indent(n) + "then");
            this.actions[i].display(n + 1, namePool, printStream);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].effectiveBooleanValue(xPathContext)) continue;
            if (this.actions[i] instanceof Instruction) {
                return ((Instruction)this.actions[i]).processLeavingTail(xPathContext);
            }
            this.actions[i].process(xPathContext);
            return null;
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].effectiveBooleanValue(xPathContext)) continue;
            return this.actions[i].evaluateItem(xPathContext);
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].effectiveBooleanValue(xPathContext)) continue;
            return this.actions[i].iterate(xPathContext);
        }
        return EmptyIterator.getInstance();
    }
}

