/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class NumberInstruction
extends ComputedExpression {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression ordinal = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private HashMap nationalNumberers = null;
    private boolean hasVariablesInPatterns;
    private boolean backwardsCompatible;
    private static Numberer defaultNumberer = new Numberer_en();

    public NumberInstruction(Expression expression, int n, Pattern pattern, Pattern pattern2, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Expression expression6, Expression expression7, Expression expression8, NumberFormatter numberFormatter, Numberer numberer, boolean bl, boolean bl2) {
        this.select = expression;
        this.level = n;
        this.count = pattern;
        this.from = pattern2;
        this.value = expression2;
        this.format = expression3;
        this.groupSize = expression4;
        this.groupSeparator = expression5;
        this.letterValue = expression6;
        this.ordinal = expression7;
        this.lang = expression8;
        this.formatter = numberFormatter;
        this.numberer = numberer;
        this.hasVariablesInPatterns = bl;
        this.backwardsCompatible = bl2;
        if (this.value != null && !Type.isSubType(this.value.getItemType(), Type.ANY_ATOMIC_TYPE)) {
            this.value = new Atomizer(this.value, null);
        }
        if (expression != null) {
            this.adoptChildExpression(expression);
        }
        if (expression2 != null) {
            this.adoptChildExpression(expression2);
        }
        if (expression3 != null) {
            this.adoptChildExpression(expression3);
        }
        if (expression4 != null) {
            this.adoptChildExpression(expression4);
        }
        if (expression5 != null) {
            this.adoptChildExpression(expression5);
        }
        if (expression6 != null) {
            this.adoptChildExpression(expression6);
        }
        if (expression7 != null) {
            this.adoptChildExpression(expression7);
        }
        if (expression8 != null) {
            this.adoptChildExpression(expression8);
        }
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify(staticContext);
        }
        if (this.value != null) {
            this.value = this.value.simplify(staticContext);
        }
        if (this.format != null) {
            this.format = this.format.simplify(staticContext);
        }
        if (this.groupSize != null) {
            this.groupSize = this.groupSize.simplify(staticContext);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = this.groupSeparator.simplify(staticContext);
        }
        if (this.letterValue != null) {
            this.letterValue = this.letterValue.simplify(staticContext);
        }
        if (this.ordinal != null) {
            this.ordinal = this.ordinal.simplify(staticContext);
        }
        if (this.lang != null) {
            this.lang = this.lang.simplify(staticContext);
        }
        if (this.count != null) {
            this.count = this.count.simplify(staticContext);
        }
        if (this.from != null) {
            this.from = this.from.simplify(staticContext);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.select != null) {
            this.select = this.select.analyze(staticContext, itemType);
        } else if (this.value == null && itemType instanceof AtomicType) {
            StaticError staticError = new StaticError("xsl:number requires the context item to be a node, but it is an atomic value");
            staticError.setIsTypeError(true);
            staticError.setErrorCode("XTTE0990");
        }
        if (this.value != null) {
            this.value = this.value.analyze(staticContext, itemType);
        }
        if (this.format != null) {
            this.format = this.format.analyze(staticContext, itemType);
        }
        if (this.groupSize != null) {
            this.groupSize = this.groupSize.analyze(staticContext, itemType);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = this.groupSeparator.analyze(staticContext, itemType);
        }
        if (this.letterValue != null) {
            this.letterValue = this.letterValue.analyze(staticContext, itemType);
        }
        if (this.ordinal != null) {
            this.ordinal = this.ordinal.analyze(staticContext, itemType);
        }
        if (this.lang != null) {
            this.lang = this.lang.analyze(staticContext, itemType);
        }
        if (this.count != null) {
            this.count = this.count.analyze(staticContext, itemType);
        }
        if (this.from != null) {
            this.from = this.from.analyze(staticContext, itemType);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(9);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        if (this.value != null) {
            arrayList.add(this.value);
        }
        if (this.format != null) {
            arrayList.add(this.format);
        }
        if (this.groupSize != null) {
            arrayList.add(this.groupSize);
        }
        if (this.groupSeparator != null) {
            arrayList.add(this.groupSeparator);
        }
        if (this.letterValue != null) {
            arrayList.add(this.letterValue);
        }
        if (this.ordinal != null) {
            arrayList.add(this.ordinal);
        }
        if (this.lang != null) {
            arrayList.add(this.lang);
        }
        if (this.count != null) {
            arrayList.add(new PatternSponsor(this.count));
        }
        if (this.from != null) {
            arrayList.add(new PatternSponsor(this.from));
        }
        return arrayList.iterator();
    }

    public int getIntrinsicDependencies() {
        return this.select == null ? 2 : 0;
    }

    public ItemType getItemType() {
        return Type.STRING_TYPE;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        if (this.value != null) {
            this.value = this.value.promote(promotionOffer);
        }
        if (this.format != null) {
            this.format = this.format.promote(promotionOffer);
        }
        if (this.groupSize != null) {
            this.groupSize = this.groupSize.promote(promotionOffer);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = this.groupSeparator.promote(promotionOffer);
        }
        if (this.letterValue != null) {
            this.letterValue = this.letterValue.promote(promotionOffer);
        }
        if (this.ordinal != null) {
            this.ordinal = this.ordinal.promote(promotionOffer);
        }
        if (this.lang != null) {
            this.lang = this.lang.promote(promotionOffer);
        }
        if (this.count != null) {
            this.count.promote(promotionOffer);
        }
        if (this.from != null) {
            this.from.promote(promotionOffer);
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        long l = -1L;
        List<Long> list = null;
        if (this.value != null) {
            object5 = this.value.iterate(xPathContext);
            list = new ArrayList<String>(4);
            while ((object4 = (AtomicValue)object5.next()) != null) {
                try {
                    object3 = object4 instanceof NumericValue ? (NumericValue)object4 : NumberFn.convert((AtomicValue)object4);
                    if (((NumericValue)object3).isNaN()) {
                        throw new DynamicError("NaN");
                    }
                    if (((NumericValue)(object3 = ((NumericValue)object3).round())).compareTo(IntegerValue.MAX_LONG) > 0) {
                        list.add((Long)((Object)((BigIntegerValue)((AtomicValue)object3).convert(532, xPathContext)).getBigInteger()));
                        continue;
                    }
                    if (((NumericValue)object3).compareTo(IntegerValue.ZERO) < 0) {
                        DynamicError dynamicError = new DynamicError("The numbers to be formatted must not be negative");
                        throw dynamicError;
                    }
                    long l2 = ((NumericValue)((AtomicValue)object3).convert(532, xPathContext)).longValue();
                    list.add(new Long(l2));
                }
                catch (DynamicError dynamicError) {
                    if (this.backwardsCompatible) {
                        list.add((Long)((Object)"NaN"));
                        continue;
                    }
                    list.add((Long)((Object)((AtomicValue)object4).getStringValue()));
                    DynamicError dynamicError2 = new DynamicError("Cannot convert supplied value to an integer. " + dynamicError.getMessage());
                    dynamicError2.setErrorCode("XTDE0980");
                    dynamicError2.setXPathContext(xPathContext);
                    throw dynamicError2;
                }
            }
            if (this.backwardsCompatible && list.size() == 0) {
                list.add((Long)((Object)"NaN"));
            }
        } else {
            if (this.select != null) {
                object5 = (NodeInfo)this.select.evaluateItem(xPathContext);
            } else {
                object4 = xPathContext.getContextItem();
                if (!(object4 instanceof NodeInfo)) {
                    DynamicError dynamicError = new DynamicError("context item for xsl:number must be a node");
                    dynamicError.setErrorCode("XTTE0990");
                    dynamicError.setIsTypeError(true);
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                object5 = (NodeInfo)object4;
            }
            if (this.level == 3) {
                l = Navigator.getNumberSimple((NodeInfo)object5, xPathContext);
            } else if (this.level == 0) {
                l = Navigator.getNumberSingle((NodeInfo)object5, this.count, this.from, xPathContext);
                if (l == 0L) {
                    list = Collections.EMPTY_LIST;
                }
            } else if (this.level == 2) {
                l = Navigator.getNumberAny(this, (NodeInfo)object5, this.count, this.from, xPathContext, this.hasVariablesInPatterns);
                if (l == 0L) {
                    list = Collections.EMPTY_LIST;
                }
            } else if (this.level == 1) {
                list = Navigator.getNumberMulti((NodeInfo)object5, this.count, this.from, xPathContext);
            }
        }
        int n = 0;
        object4 = "";
        String string = null;
        if (this.groupSize != null) {
            object2 = this.groupSize.evaluateAsString(xPathContext);
            try {
                n = Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                DynamicError dynamicError = new DynamicError("grouping-size must be numeric");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTDE0030");
                throw dynamicError;
            }
        }
        if (this.groupSeparator != null) {
            object4 = this.groupSeparator.evaluateAsString(xPathContext);
        }
        if (this.ordinal != null) {
            string = this.ordinal.evaluateAsString(xPathContext);
        }
        if (list == null && this.format == null && n == 0 && this.lang == null) {
            return new StringValue("" + l);
        }
        object2 = this.numberer;
        if (object2 == null) {
            object = this.lang.evaluateAsString(xPathContext);
            if (this.nationalNumberers == null) {
                this.nationalNumberers = new HashMap(4);
            }
            if ((object2 = (Numberer)this.nationalNumberers.get(object)) == null) {
                object2 = NumberInstruction.makeNumberer((String)object, xPathContext);
                this.nationalNumberers.put(object, object2);
            }
        }
        if (this.letterValue == null) {
            object3 = "";
        } else {
            object3 = this.letterValue.evaluateAsString(xPathContext);
            if (!"alphabetic".equals(object3) && !"traditional".equals(object3)) {
                object = new DynamicError("letter-value must be \"traditional\" or \"alphabetic\"");
                ((DynamicError)object).setXPathContext(xPathContext);
                ((XPathException)object).setErrorCode("XTDE0030");
                throw object;
            }
        }
        if (list == null) {
            list = new ArrayList(1);
            list.add(new Long(l));
        }
        if (this.formatter == null) {
            object = new NumberFormatter();
            ((NumberFormatter)object).prepare(this.format.evaluateAsString(xPathContext));
        } else {
            object = this.formatter;
        }
        CharSequence charSequence = ((NumberFormatter)object).format(list, n, (String)object4, (String)object3, string, (Numberer)object2);
        return new StringValue(charSequence);
    }

    private void recoverableError(DynamicError dynamicError, XPathContext xPathContext) throws XPathException {
        dynamicError.setLocator(ExpressionTool.getLocator(this));
        xPathContext.getController().recoverableError(dynamicError);
    }

    public static Numberer makeNumberer(String string, XPathContext xPathContext) {
        Numberer numberer;
        if ("en".equals(string)) {
            numberer = defaultNumberer;
        } else {
            String string2 = "net.sf.saxon.number.Numberer_";
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i))) continue;
                string2 = string2 + string.charAt(i);
            }
            try {
                Controller controller = xPathContext.getController();
                Configuration configuration = controller.getConfiguration();
                numberer = (Numberer)configuration.getInstance(string2, controller.getClassLoader());
            }
            catch (XPathException xPathException) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "xsl:number");
    }
}

