/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class SimpleContentConstructor
extends ComputedExpression {
    Expression select;
    Expression separator;
    boolean isSingleton = false;
    boolean isAtomic = false;

    public SimpleContentConstructor(Expression expression, Expression expression2) {
        this.select = expression;
        this.separator = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    protected int computeCardinality() {
        return 16384;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.analyze(staticContext, itemType);
        this.separator = this.separator.analyze(staticContext, itemType);
        if (!Cardinality.allowsMany(this.select.getCardinality())) {
            this.isSingleton = true;
        }
        if (Type.isSubType(this.select.getItemType(), Type.ANY_ATOMIC_TYPE)) {
            this.isAtomic = true;
        }
        return this;
    }

    public ItemType getItemType() {
        return Type.STRING_TYPE;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "construct simple content");
        this.select.display(n + 1, namePool, printStream);
        this.separator.display(n + 1, namePool, printStream);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.separator = this.separator.simplify(staticContext);
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.select, this.separator);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.select = this.select.promote(promotionOffer);
        this.separator = this.separator.promote(promotionOffer);
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator;
        Object object;
        if (this.isSingleton) {
            object = this.select.evaluateItem(xPathContext);
            if (object == null || object instanceof StringValue) {
                return object;
            }
            if (object instanceof AtomicValue) {
                return ((AtomicValue)object).convert(513, xPathContext);
            }
            sequenceIterator = SingletonIterator.makeIterator((Item)object);
        } else {
            sequenceIterator = this.select.iterate(xPathContext);
        }
        object = new FastStringBuffer(1024);
        boolean bl = false;
        boolean bl2 = true;
        CharSequence charSequence = null;
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                Item item2;
                Object object2;
                if (((NodeInfo)item).getNodeKind() == 3) {
                    object2 = item.getStringValueCS();
                    if (object2.length() <= 0) continue;
                    if (!bl2 && !bl) {
                        if (charSequence == null) {
                            charSequence = this.separator.evaluateItem(xPathContext).getStringValueCS();
                        }
                        ((FastStringBuffer)object).append(charSequence);
                    }
                    bl2 = false;
                    ((FastStringBuffer)object).append((CharSequence)object2);
                    bl = true;
                    continue;
                }
                bl = false;
                object2 = item.getTypedValue();
                while ((item2 = object2.next()) != null) {
                    if (!bl2) {
                        if (charSequence == null) {
                            charSequence = this.separator.evaluateItem(xPathContext).getStringValueCS();
                        }
                        ((FastStringBuffer)object).append(charSequence);
                    }
                    bl2 = false;
                    ((FastStringBuffer)object).append(item2.getStringValueCS());
                }
                continue;
            }
            if (!bl2) {
                if (charSequence == null) {
                    charSequence = this.separator.evaluateItem(xPathContext).getStringValueCS();
                }
                ((FastStringBuffer)object).append(charSequence);
            }
            bl2 = false;
            ((FastStringBuffer)object).append(item.getStringValueCS());
        }
        return new StringValue(((FastStringBuffer)object).condense());
    }

    public int getImplementationMethod() {
        return 1;
    }
}

