/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public abstract class SimpleNodeConstructor
extends Instruction {
    protected Expression select = null;

    public void setSelect(Expression expression) throws StaticError {
        this.select = expression;
        this.adoptChildExpression(expression);
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify(staticContext);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public abstract void typeCheck(StaticContext var1, ItemType var2) throws XPathException;

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.typeCheck(staticContext, itemType);
        if (this.select != null) {
            this.select = this.select.analyze(staticContext, itemType);
            if (!Type.isSubType(this.select.getItemType(), Type.ANY_ATOMIC_TYPE)) {
                this.select = new Atomizer(this.select, staticContext.getConfiguration());
            }
            if (!Type.isSubType(this.select.getItemType(), Type.STRING_TYPE)) {
                this.select = new AtomicSequenceConverter(this.select, Type.STRING_TYPE);
            }
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public CharSequence expandChildren(XPathContext xPathContext) throws XPathException {
        Item item = this.select.evaluateItem(xPathContext);
        if (item == null) {
            return "";
        }
        return item.getStringValueCS();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.select == null ? "" : this.select.evaluateAsString(xPathContext);
        string = this.checkContent(string, xPathContext);
        try {
            Orphan orphan = new Orphan(xPathContext.getController().getConfiguration());
            orphan.setNodeKind((short)this.getItemType().getPrimitiveType());
            orphan.setStringValue(string);
            orphan.setNameCode(this.evaluateNameCode(xPathContext));
            return orphan;
        }
        catch (SkipInstructionException skipInstructionException) {
            return null;
        }
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        return string;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException, XPathException {
        return -1;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(xPathContext));
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        if (this.select != null) {
            this.select.display(n, namePool, printStream);
        }
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }
}

