/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class TraceWrapper
extends Instruction {
    Expression child;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.child = this.child.simplify(staticContext);
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.child = this.child.analyze(staticContext, itemType);
        return this;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        TraceListener traceListener = controller.getTraceListener();
        if (controller.isTracing()) {
            traceListener.enter(this.getInstructionInfo(), xPathContext);
        }
        this.child.process(xPathContext);
        if (controller.isTracing()) {
            traceListener.leave(this.getInstructionInfo());
        }
        return null;
    }

    public ItemType getItemType() {
        return this.child.getItemType();
    }

    public int getCardinality() {
        return this.child.getCardinality();
    }

    public int getDependencies() {
        return this.child.getDependencies();
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int computeDependencies() {
        if (this.child instanceof ComputedExpression) {
            return ((ComputedExpression)this.child).computeDependencies();
        }
        return 0;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        Item item = this.child.evaluateItem(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        SequenceIterator sequenceIterator = this.child.iterate(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return sequenceIterator;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.child);
    }

    public int getInstructionNameCode() {
        if (this.child instanceof Instruction) {
            return ((Instruction)this.child).getInstructionNameCode();
        }
        return -1;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        this.child.display(n, namePool, printStream);
    }
}

