/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import net.sf.saxon.number.Numberer_en;

public class Numberer_de
extends Numberer_en {
    private static String[] germanUnits = new String[]{"", "Eins", "Zwei", "Drei", "Vier", "F\u00fcnf", "Sechs", "Sieben", "Acht", "Neun", "Zehn", "Elf", "Zw\u00f6lf", "Dreizehn", "Vierzehn", "F\u00fcnfzehn", "Sechszehn", "Siebzehn", "Achtzehn", "Neunzehn"};
    private static String[] germanTens = new String[]{"", "Zehn", "Zwanzig", "Drei\u00dfig", "Vierzig", "F\u00fcnfzig", "Sechzig", "Siebzig", "Achtzig", "Neunzig"};
    private static String[] germanOrdinalUnits = new String[]{"", "Erst", "Zweit", "Dritt", "Viert", "F\u00fcnft", "Sechst", "Siebt", "Acht", "Neunt", "Zehnt", "Elft", "Zw\u00f6lft", "Dreizehnt", "Vierzehnt", "F\u00fcnfzehnt", "Sechszehnt", "Siebzehnt", "Achtzehnt", "Neunzehnt"};
    private static String[] germanMonths = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
    private static String[] germanDays = new String[]{"Sunday", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"};

    protected String ordinalSuffix(String string, long l) {
        return ".";
    }

    public String toWords(long l) {
        if (l >= 1000000000L) {
            long l2 = l % 1000000000L;
            long l3 = l / 100000000L;
            String string = l3 == 1L ? "Eine" : this.toWords(l3);
            return string + " Milliarde" + (l2 == 0L ? "" : " " + this.toWords(l2));
        }
        if (l >= 1000000L) {
            long l4 = l % 1000000L;
            long l5 = l / 1000000L;
            String string = l5 == 1L ? "Eine" : this.toWords(l5);
            return string + " Million" + (l4 == 0L ? "" : " " + this.toWords(l4));
        }
        if (l >= 1000L) {
            long l6 = l % 1000L;
            long l7 = l / 1000L;
            String string = l7 == 1L ? "Ein" : this.toWords(l7);
            return string + "tausend" + (l6 == 0L ? "" : " " + this.toWords(l6));
        }
        if (l >= 100L) {
            long l8 = l % 100L;
            long l9 = l / 100L;
            String string = l9 == 1L ? "Ein" : this.toWords(l9);
            return string + "hundert" + (l8 == 0L ? "" : (l8 > 20L ? "" : "und") + this.toWords(l8, 1));
        }
        if (l < 20L) {
            return germanUnits[(int)l];
        }
        int n = (int)(l % 10L);
        int n2 = (int)l / 10;
        return germanUnits[n] + (n2 == 0 ? "" : (n == 0 ? "" : "und") + germanTens[n2]);
    }

    public String toOrdinalWords(String string, long l, int n) {
        String string2 = "e";
        if (string.equalsIgnoreCase("-er")) {
            string2 = "er";
        } else if (string.equalsIgnoreCase("-es")) {
            string2 = "es";
        } else if (string.equalsIgnoreCase("-en")) {
            string2 = "en";
        }
        long l2 = l % 100L;
        if (l < 20L) {
            String string3 = germanOrdinalUnits[(int)l] + string2;
            if (n == 0) {
                return string3.toUpperCase();
            }
            if (n == 1) {
                return string3.toLowerCase();
            }
            return string3;
        }
        if (l2 < 20L && l2 > 0L) {
            return this.toWords(l - l2, n) + this.toOrdinalWords(string, l2, n == 2 ? 1 : n);
        }
        String string4 = "st" + string2;
        if (n == 0) {
            string4 = string4.toUpperCase();
        }
        return this.toWords(l, n) + (n == 0 ? string4.toUpperCase() : string4);
    }

    public String monthName(int n, int n2, int n3) {
        String string = germanMonths[n - 1];
        if (n3 < 3) {
            n3 = 3;
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        while (string.length() < n2) {
            string = string + " ";
        }
        return string;
    }

    public String dayName(int n, int n2, int n3) {
        String string = germanDays[n - 1];
        if (n3 < 10) {
            string = string.substring(0, 2);
        }
        while (string.length() < n2) {
            string = string + " ";
        }
        return string;
    }

    public String getOrdinalSuffixForDateTime(String string) {
        return "-e";
    }
}

