/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trans.DynamicError;

public class NamePool
implements Serializable {
    public static final int FP_MASK = 1048575;
    private static NamePool defaultNamePool = new NamePool();
    private transient WeakHashMap documentNumberMap = new WeakHashMap(10);
    private int numberOfDocuments = 0;
    NameEntry[] hashslots = new NameEntry[1024];
    String[] prefixes = new String[100];
    short prefixesUsed = 0;
    String[] uris = new String[100];
    String[] prefixesForUri = new String[100];
    short urisUsed = 0;

    public static NamePool getDefaultNamePool() {
        return defaultNamePool;
    }

    public static void setDefaultNamePool(NamePool namePool) {
        defaultNamePool = namePool;
    }

    public NamePool() {
        this.prefixes[0] = "";
        this.uris[0] = "";
        this.prefixesForUri[0] = "";
        this.prefixes[1] = "xml";
        this.uris[1] = "http://www.w3.org/XML/1998/namespace";
        this.prefixesForUri[1] = "xml ";
        this.prefixes[2] = "xsl";
        this.uris[2] = "http://www.w3.org/1999/XSL/Transform";
        this.prefixesForUri[2] = "xsl ";
        this.prefixes[3] = "saxon";
        this.uris[3] = "http://saxon.sf.net/";
        this.prefixesForUri[3] = "saxon ";
        this.prefixes[4] = "xs";
        this.uris[4] = "http://www.w3.org/2001/XMLSchema";
        this.prefixesForUri[4] = "xs ";
        this.prefixes[5] = "xdt";
        this.uris[5] = "http://www.w3.org/2005/04/xpath-datatypes";
        this.prefixesForUri[5] = "xdt ";
        this.prefixes[6] = "xsi";
        this.uris[6] = "http://www.w3.org/2001/XMLSchema-instance";
        this.prefixesForUri[6] = "xsi ";
        this.prefixesUsed = (short)7;
        this.urisUsed = (short)7;
    }

    public synchronized int allocateDocumentNumber(NodeInfo nodeInfo) {
        Integer n;
        if (this.documentNumberMap == null) {
            this.documentNumberMap = new WeakHashMap(10);
        }
        if ((n = (Integer)this.documentNumberMap.get(nodeInfo)) != null) {
            return n;
        }
        int n2 = this.numberOfDocuments++;
        this.documentNumberMap.put(nodeInfo, new Integer(n2));
        return n2;
    }

    public VirtualNode getDocumentWrapper(Object object) {
        Iterator iterator = this.documentNumberMap.keySet().iterator();
        while (iterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)iterator.next();
            if (!(nodeInfo instanceof VirtualNode) || ((VirtualNode)nodeInfo).getUnderlyingNode() != object) continue;
            return (VirtualNode)nodeInfo;
        }
        return null;
    }

    private NameEntry getNameEntry(int n) {
        int n2 = n & 0x3FF;
        int n3 = n >> 10 & 0x3FF;
        NameEntry nameEntry = this.hashslots[n2];
        for (int i = 1; i < n3; ++i) {
            if (nameEntry == null) {
                return null;
            }
            nameEntry = nameEntry.nextEntry;
        }
        return nameEntry;
    }

    public synchronized int allocateNamespaceCode(String string, String string2) {
        String string3;
        short s = this.allocateCodeForPrefix(string);
        short s2 = this.allocateCodeForURI(string2);
        if (s != 0 && this.prefixesForUri[s2].indexOf(string3 = string + ' ') < 0) {
            short s3 = s2;
            this.prefixesForUri[s3] = this.prefixesForUri[s3] + string3;
        }
        return (s << 16) + s2;
    }

    public int getNamespaceCode(String string, String string2) {
        String string3;
        short s = this.getCodeForPrefix(string);
        if (s < 0) {
            return -1;
        }
        short s2 = this.getCodeForURI(string2);
        if (s2 < 0) {
            return -1;
        }
        if (s != 0 && this.prefixesForUri[s2].indexOf(string3 = string + ' ') < 0) {
            return -1;
        }
        return (s << 16) + s2;
    }

    public int getNamespaceCode(int n) {
        short s;
        int n2 = n & 0xFFFFF;
        if ((n2 & 0xFFC00) == 0) {
            s = StandardNames.getURICode(n2);
        } else {
            NameEntry nameEntry = this.getNameEntry(n);
            if (nameEntry == null) {
                return -1;
            }
            s = nameEntry.uriCode;
        }
        int n3 = n >> 20 & 0xFF;
        String string = this.getPrefixWithIndex(s, n3);
        if (string == null) {
            return -1;
        }
        short s2 = this.getCodeForPrefix(string);
        if (s2 == -1) {
            return -1;
        }
        return (s2 << 16) + s;
    }

    public synchronized short allocateCodeForURI(String string) {
        for (short s = 0; s < this.urisUsed; s = (short)(s + 1)) {
            if (!this.uris[s].equals(string)) continue;
            return s;
        }
        if (this.urisUsed >= this.uris.length) {
            if (this.urisUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace URIs");
            }
            String[] stringArray = new String[this.urisUsed * 2];
            String[] stringArray2 = new String[this.urisUsed * 2];
            System.arraycopy(this.prefixesForUri, 0, stringArray, 0, this.urisUsed);
            System.arraycopy(this.uris, 0, stringArray2, 0, this.urisUsed);
            this.prefixesForUri = stringArray;
            this.uris = stringArray2;
        }
        this.uris[this.urisUsed] = string;
        this.prefixesForUri[this.urisUsed] = "";
        short s = this.urisUsed;
        this.urisUsed = (short)(s + 1);
        return s;
    }

    public short getCodeForURI(String string) {
        for (short s = 0; s < this.urisUsed; s = (short)(s + 1)) {
            if (!this.uris[s].equals(string)) continue;
            return s;
        }
        return -1;
    }

    private short allocateCodeForPrefix(String string) {
        short s = 1;
        if (string.equals("")) {
            return 0;
        }
        if (string.charAt(0) != 'x') {
            if (string.equals("saxon")) {
                return 3;
            }
            s = 7;
        }
        for (short s2 = s; s2 < this.prefixesUsed; s2 = (short)(s2 + 1)) {
            if (!this.prefixes[s2].equals(string)) continue;
            return s2;
        }
        if (this.prefixesUsed >= this.prefixes.length) {
            if (this.prefixesUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace prefixes");
            }
            String[] stringArray = new String[this.prefixesUsed * 2];
            System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixesUsed);
            this.prefixes = stringArray;
        }
        this.prefixes[this.prefixesUsed] = string;
        short s3 = this.prefixesUsed;
        this.prefixesUsed = (short)(s3 + 1);
        return s3;
    }

    public short getCodeForPrefix(String string) {
        for (short s = 0; s < this.prefixesUsed; s = (short)(s + 1)) {
            if (!this.prefixes[s].equals(string)) continue;
            return s;
        }
        return -1;
    }

    public String suggestPrefixForURI(String string) {
        short s = this.getCodeForURI(string);
        if (s == -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        if (stringTokenizer.hasMoreElements()) {
            return (String)stringTokenizer.nextElement();
        }
        return null;
    }

    private int getPrefixIndex(short s, String string) {
        if (string.equals("")) {
            return 0;
        }
        if (this.prefixesForUri[s].equals(string + ' ')) {
            return 1;
        }
        int n = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        while (stringTokenizer.hasMoreElements()) {
            if (string.equals(stringTokenizer.nextElement())) {
                return n;
            }
            if (n++ != 255) continue;
            throw new NamePoolLimitException("Too many prefixes for one namespace URI");
        }
        return -1;
    }

    public String getPrefixWithIndex(short s, int n) {
        if (n == 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        int n2 = 1;
        while (stringTokenizer.hasMoreElements()) {
            String string = (String)stringTokenizer.nextElement();
            if (n2++ != n) continue;
            return string;
        }
        return null;
    }

    public synchronized int allocate(String string, String string2, String string3) {
        short s;
        if ((NamespaceConstant.isReserved(string2) || string2.equals("http://saxon.sf.net/")) && (s = StandardNames.getFingerprint(string2, string3)) != -1) {
            short s2 = StandardNames.getURICode(s);
            int n = this.getPrefixIndex(s2, string);
            if (n < 0) {
                short s3 = s2;
                this.prefixesForUri[s3] = this.prefixesForUri[s3] + string + ' ';
                n = this.getPrefixIndex(s2, string);
            }
            return (n << 20) + s;
        }
        s = this.allocateCodeForURI(string2);
        return this.allocate(string, s, string3);
    }

    public synchronized int allocate(String string, short s, String string2) {
        int n = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n2 = 1;
        int n3 = this.getPrefixIndex(s, string);
        if (n3 < 0) {
            short s2 = s;
            this.prefixesForUri[s2] = this.prefixesForUri[s2] + string + ' ';
            n3 = this.getPrefixIndex(s, string);
        }
        if (this.hashslots[n] == null) {
            NameEntry nameEntry;
            this.hashslots[n] = nameEntry = new NameEntry(s, string2);
        } else {
            NameEntry nameEntry = this.hashslots[n];
            while (true) {
                boolean bl;
                boolean bl2 = nameEntry.localName.equals(string2);
                boolean bl3 = bl = nameEntry.uriCode == s;
                if (bl2 && bl) break;
                NameEntry nameEntry2 = nameEntry.nextEntry;
                if (++n2 >= 1024) {
                    throw new NamePoolLimitException("Saxon name pool is full");
                }
                if (nameEntry2 == null) {
                    NameEntry nameEntry3;
                    nameEntry.nextEntry = nameEntry3 = new NameEntry(s, string2);
                    break;
                }
                nameEntry = nameEntry2;
            }
        }
        return (n3 << 20) + (n2 << 10) + n;
    }

    public synchronized int allocateNamespaceCode(int n) {
        short s;
        int n2 = n & 0xFFFFF;
        if ((n2 & 0xFFC00) == 0) {
            s = StandardNames.getURICode(n2);
        } else {
            NameEntry nameEntry = this.getNameEntry(n);
            if (nameEntry == null) {
                this.unknownNameCode(n);
                return -1;
            }
            s = nameEntry.uriCode;
        }
        int n3 = n >> 20 & 0xFF;
        String string = this.getPrefixWithIndex(s, n3);
        short s2 = this.allocateCodeForPrefix(string);
        return (s2 << 16) + s;
    }

    public String getURI(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getURI(n & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
            return null;
        }
        return this.uris[nameEntry.uriCode];
    }

    public short getURICode(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getURICode(n & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
            return -1;
        }
        return nameEntry.uriCode;
    }

    public String getLocalName(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getLocalName(n & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
            return null;
        }
        return nameEntry.localName;
    }

    public String getPrefix(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getPrefix(n & 0xFFFFF);
        }
        short s = this.getURICode(n);
        int n2 = n >> 20 & 0xFF;
        return this.getPrefixWithIndex(s, n2);
    }

    public String getDisplayName(int n) {
        if ((n & 0xFFC00) == 0) {
            int n2 = n >> 20 & 0xFF;
            short s = this.getURICode(n);
            String string = this.getPrefixWithIndex(s, n2);
            if (string.equals("")) {
                return StandardNames.getLocalName(n & 0xFFFFF);
            }
            return string + ':' + StandardNames.getLocalName(n & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
            return null;
        }
        int n3 = n >> 20 & 0xFF;
        String string = this.getPrefixWithIndex(nameEntry.uriCode, n3);
        if (string == null || string.equals("")) {
            return nameEntry.localName;
        }
        return string + ':' + nameEntry.localName;
    }

    public String getClarkName(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getClarkName(n & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
            return null;
        }
        if (nameEntry.uriCode == 0) {
            return nameEntry.localName;
        }
        String string = '{' + this.getURIFromURICode(nameEntry.uriCode) + '}' + nameEntry.localName;
        return string.intern();
    }

    public int allocateClarkName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.allocate("", string3, string2);
    }

    private void unknownNameCode(int n) {
        throw new IllegalArgumentException("Unknown name code " + n);
    }

    public int getFingerprint(String string, String string2) {
        short s;
        short s2;
        if (string.equals("")) {
            s2 = 0;
        } else {
            if ((NamespaceConstant.isReserved(string) || string.equals("http://saxon.sf.net/")) && (s = StandardNames.getFingerprint(string, string2)) != -1) {
                return s;
            }
            s2 = -1;
            for (s = 0; s < this.urisUsed; s = (short)(s + 1)) {
                if (!this.uris[s].equals(string)) continue;
                s2 = s;
                break;
            }
            if (s2 == -1) {
                return -1;
            }
        }
        s = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n = 1;
        if (this.hashslots[s] == null) {
            return -1;
        }
        NameEntry nameEntry = this.hashslots[s];
        while (nameEntry.uriCode != s2 || !nameEntry.localName.equals(string2)) {
            NameEntry nameEntry2 = nameEntry.nextEntry;
            ++n;
            if (nameEntry2 == null) {
                return -1;
            }
            nameEntry = nameEntry2;
        }
        return (n << 10) + s;
    }

    public String getURIFromNamespaceCode(int n) {
        return this.uris[n & 0xFFFF];
    }

    public String getURIFromURICode(short s) {
        return this.uris[s];
    }

    public String getPrefixFromNamespaceCode(int n) {
        return this.prefixes[n >> 16];
    }

    public int allocateLexicalQName(CharSequence charSequence, boolean bl, NamespaceResolver namespaceResolver) throws DynamicError {
        try {
            String[] stringArray = Name.getQNameParts(charSequence);
            String string = namespaceResolver.getURIForPrefix(stringArray[0], bl);
            return this.allocate(stringArray[0], string, stringArray[1]);
        }
        catch (QNameException qNameException) {
            throw new DynamicError(qNameException.getMessage());
        }
    }

    public int getFingerprintForExpandedName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in parameter name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in parameter name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.allocate("", string3, string2);
    }

    public synchronized void diagnosticDump() {
        int n;
        System.err.println("Contents of NamePool " + this);
        for (n = 0; n < 1024; ++n) {
            NameEntry nameEntry = this.hashslots[n];
            int n2 = 0;
            while (nameEntry != null) {
                System.err.println("Fingerprint " + n2 + '/' + n);
                System.err.println("  local name = " + nameEntry.localName + " uri code = " + nameEntry.uriCode);
                nameEntry = nameEntry.nextEntry;
                ++n2;
            }
        }
        for (n = 0; n < this.prefixesUsed; ++n) {
            System.err.println("Prefix " + n + " = " + this.prefixes[n]);
        }
        for (n = 0; n < this.urisUsed; ++n) {
            System.err.println("URI " + n + " = " + this.uris[n]);
            System.err.println("Prefixes for URI " + n + " = " + this.prefixesForUri[n]);
        }
    }

    public synchronized void statistics() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 1024; ++i) {
            NameEntry nameEntry = this.hashslots[i];
            if (nameEntry != null) {
                ++n;
            }
            while (nameEntry != null) {
                nameEntry = nameEntry.nextEntry;
                ++n2;
            }
        }
        System.err.println("NamePool contents: " + n2 + " entries in " + n + " chains. " + this.prefixesUsed + " prefixes, " + this.urisUsed + " URIs");
    }

    public static class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String string) {
            super(string);
        }
    }

    private static class NameEntry
    implements Serializable {
        String localName;
        short uriCode;
        NameEntry nextEntry;

        public NameEntry(short s, String string) {
            this.uriCode = s;
            this.localName = string.intern();
            this.nextEntry = null;
        }
    }
}

