/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class NamespaceIterator
implements AxisIterator {
    private NodeInfo element;
    private NodeTest test;
    private int index;
    private int position;
    private NamespaceNodeImpl next;
    private NamespaceNodeImpl current;
    private Iterator nsIterator;
    private int count;
    private static final Integer xmlnscode = new Integer(65537);

    public NamespaceIterator(NodeInfo nodeInfo, NodeTest nodeTest) {
        this.element = nodeInfo;
        this.test = nodeTest;
        if (nodeTest instanceof AnyNodeTest || nodeTest == NodeKindTest.NAMESPACE) {
            this.test = null;
        }
        this.index = -1;
        HashSet<Integer> hashSet = new HashSet<Integer>(10);
        HashSet<Integer> hashSet2 = new HashSet<Integer>(10);
        int[] nArray = new int[10];
        hashSet2.add(xmlnscode);
        for (NodeInfo nodeInfo2 = nodeInfo; nodeInfo2 != null && nodeInfo2.getNodeKind() == 1; nodeInfo2 = nodeInfo2.getParent()) {
            int[] nArray2 = nodeInfo2.getDeclaredNamespaces(nArray);
            if (nArray2 == null) continue;
            for (int i = 0; i < nArray2.length && nArray2[i] != -1; ++i) {
                short s = (short)(nArray2[i] & 0xFFFF);
                short s2 = (short)(nArray2[i] >> 16);
                if (s == 0) {
                    hashSet.add(new Integer(s2));
                    continue;
                }
                Integer n = new Integer(s2);
                if (hashSet.contains(n)) continue;
                hashSet2.add(new Integer(nArray2[i]));
                hashSet.add(n);
            }
        }
        this.count = hashSet2.size();
        this.nsIterator = hashSet2.iterator();
    }

    public void advance() {
        while (this.nsIterator.hasNext()) {
            int n = (Integer)this.nsIterator.next();
            this.next = new NamespaceNodeImpl(this.element, n, this.index++);
            if (this.test != null && !this.test.matches(this.next)) continue;
            return;
        }
        this.next = null;
    }

    public Item next() {
        if (this.index == -1) {
            this.advance();
            this.index = 0;
        }
        this.current = this.next;
        if (this.current == null) {
            this.position = -1;
            return null;
        }
        this.advance();
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() {
        return new NamespaceIterator(this.element, this.test);
    }

    public int[] getInScopeNamespaceCodes() {
        int[] nArray = new int[this.count];
        int n = 0;
        while (this.nsIterator.hasNext()) {
            nArray[n++] = (Integer)this.nsIterator.next();
        }
        return nArray;
    }

    public static class NamespaceNodeImpl
    implements NodeInfo,
    FingerprintedNode {
        NodeInfo element;
        int nscode;
        int position;
        int namecode;

        public NamespaceNodeImpl(NodeInfo nodeInfo, int n, int n2) {
            this.element = nodeInfo;
            this.nscode = n;
            this.position = n2;
            NamePool namePool = nodeInfo.getNamePool();
            String string = namePool.getPrefixFromNamespaceCode(n);
            this.namecode = "".equals(string) ? -1 : namePool.allocate("", "", string);
        }

        public int getNodeKind() {
            return 13;
        }

        public boolean isSameNodeInfo(NodeInfo nodeInfo) {
            if (!(nodeInfo instanceof NamespaceNodeImpl)) {
                return false;
            }
            return this.element.isSameNodeInfo(((NamespaceNodeImpl)nodeInfo).element) && this.nscode == ((NamespaceNodeImpl)nodeInfo).nscode;
        }

        public String getSystemId() {
            return this.element.getSystemId();
        }

        public String getBaseURI() {
            return this.element.getBaseURI();
        }

        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        public int compareOrder(NodeInfo nodeInfo) {
            if (nodeInfo instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)nodeInfo).element)) {
                int n = this.position - ((NamespaceNodeImpl)nodeInfo).position;
                if (n == 0) {
                    return 0;
                }
                if (n < 0) {
                    return -1;
                }
                return 1;
            }
            return this.element.compareOrder(nodeInfo);
        }

        public String getStringValue() {
            return this.element.getNamePool().getURIFromURICode((short)(this.nscode & 0xFFFF));
        }

        public CharSequence getStringValueCS() {
            return this.getStringValue();
        }

        public int getNameCode() {
            return this.namecode;
        }

        public int getFingerprint() {
            if (this.namecode == -1) {
                return -1;
            }
            return this.namecode & 0xFFFFF;
        }

        public String getLocalPart() {
            if (this.namecode == -1) {
                return "";
            }
            return this.element.getNamePool().getLocalName(this.namecode);
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return this.getLocalPart();
        }

        public String getPrefix() {
            return "";
        }

        public Configuration getConfiguration() {
            return this.element.getConfiguration();
        }

        public NamePool getNamePool() {
            return this.element.getNamePool();
        }

        public int getTypeAnnotation() {
            return -1;
        }

        public NodeInfo getParent() {
            return this.element;
        }

        public AxisIterator iterateAxis(byte by) {
            return this.iterateAxis(by, new AnyNodeTest());
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            switch (by) {
                case 0: {
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 1: {
                    if (nodeTest.matches(this)) {
                        return new PrependIterator(this, this.element.iterateAxis((byte)1, nodeTest));
                    }
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 6: {
                    return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
                }
                case 9: {
                    if (nodeTest.matches(this.element)) {
                        return SingletonIterator.makeIterator(this.element);
                    }
                    return EmptyIterator.getInstance();
                }
                case 10: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
                }
                case 12: {
                    if (nodeTest.matches(this)) {
                        return SingletonIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 13: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public String getAttributeValue(int n) {
            return null;
        }

        public NodeInfo getRoot() {
            return this.element.getRoot();
        }

        public DocumentInfo getDocumentRoot() {
            return this.element.getDocumentRoot();
        }

        public boolean hasChildNodes() {
            return false;
        }

        public String generateId() {
            return this.element.generateId() + 'n' + this.position;
        }

        public int getDocumentNumber() {
            return this.element.getDocumentNumber();
        }

        public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
            receiver.namespace(this.getNamePool().getNamespaceCode(this.getNameCode()), 0);
        }

        public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        }

        public int[] getDeclaredNamespaces(int[] nArray) {
            return null;
        }

        public void setSystemId(String string) {
        }

        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new StringValue(this.getStringValueCS()));
        }
    }
}

