/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;

public final class LocalNameTest
extends NodeTest {
    private NamePool namePool;
    private int nodeKind;
    private String localName;

    public LocalNameTest(NamePool namePool, int n, String string) {
        this.namePool = namePool;
        this.nodeKind = n;
        this.localName = string;
    }

    public boolean matches(int n, int n2, int n3) {
        if (n2 == -1) {
            return false;
        }
        if (n != this.nodeKind) {
            return false;
        }
        return this.localName.equals(this.namePool.getLocalName(n2));
    }

    public boolean matches(NodeInfo nodeInfo) {
        return this.localName.equals(nodeInfo.getLocalPart());
    }

    public final double getDefaultPriority() {
        return -0.25;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public String toString() {
        return "*:" + this.localName;
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.localName.hashCode();
    }
}

